/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;

@Singleton
class GrpcExceptionHandler {
    private final Predicate<Throwable> isExpectedException = t2 -> t2 instanceof IllegalStateException || t2 instanceof IllegalArgumentException;
    private final Function<String, String> cliStyleErrorMessage = e -> {
        String[] line = e.split("\\r?\\n");
        int lastLine = line.length;
        return line[lastLine - 1].toLowerCase();
    };

    @Inject
    public GrpcExceptionHandler() {
    }

    public synchronized void handleException(Logger log, Throwable t2, StreamObserver<?> responseObserver) {
        log.error("", t2);
        StatusRuntimeException grpcStatusRuntimeException = this.wrapException(t2);
        responseObserver.onError(grpcStatusRuntimeException);
        throw grpcStatusRuntimeException;
    }

    public synchronized void handleExceptionAsWarning(Logger log, String calledMethod, Throwable t2, StreamObserver<?> responseObserver) {
        log.warn(calledMethod + " -> " + t2.getMessage());
        StatusRuntimeException grpcStatusRuntimeException = this.wrapException(t2);
        responseObserver.onError(grpcStatusRuntimeException);
        throw grpcStatusRuntimeException;
    }

    public void handleErrorMessage(Logger log, String errorMessage, StreamObserver<?> responseObserver) {
        log.error(errorMessage);
        StatusRuntimeException grpcStatusRuntimeException = new StatusRuntimeException(Status.UNKNOWN.withDescription(this.cliStyleErrorMessage.apply(errorMessage)));
        responseObserver.onError(grpcStatusRuntimeException);
        throw grpcStatusRuntimeException;
    }

    private StatusRuntimeException wrapException(Throwable t2) {
        if (this.isExpectedException.test(t2)) {
            if (t2.getCause() != null) {
                return new StatusRuntimeException(this.mapGrpcErrorStatus(t2.getCause(), t2.getCause().getMessage()));
            }
            return new StatusRuntimeException(this.mapGrpcErrorStatus(t2, t2.getMessage()));
        }
        return new StatusRuntimeException(this.mapGrpcErrorStatus(t2, "unexpected error on server"));
    }

    private Status mapGrpcErrorStatus(Throwable t2, String description) {
        switch (t2.getClass().getSimpleName()) {
            case "IllegalArgumentException": {
                return Status.INVALID_ARGUMENT.withDescription(description);
            }
        }
        return Status.UNKNOWN.withDescription(description);
    }
}

