/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.config.Config;
import haveno.core.api.CoreContext;
import haveno.daemon.grpc.GrpcAccountService;
import haveno.daemon.grpc.GrpcDisputeAgentsService;
import haveno.daemon.grpc.GrpcDisputesService;
import haveno.daemon.grpc.GrpcGetTradeStatisticsService;
import haveno.daemon.grpc.GrpcHelpService;
import haveno.daemon.grpc.GrpcNotificationsService;
import haveno.daemon.grpc.GrpcOffersService;
import haveno.daemon.grpc.GrpcPaymentAccountsService;
import haveno.daemon.grpc.GrpcPriceService;
import haveno.daemon.grpc.GrpcShutdownService;
import haveno.daemon.grpc.GrpcTradesService;
import haveno.daemon.grpc.GrpcVersionService;
import haveno.daemon.grpc.GrpcWalletsService;
import haveno.daemon.grpc.GrpcXmrConnectionService;
import haveno.daemon.grpc.GrpcXmrNodeService;
import haveno.daemon.grpc.interceptor.PasswordAuthInterceptor;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptors;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GrpcServer {
    private static final Logger log = LoggerFactory.getLogger(GrpcServer.class);
    private final Server server;

    @Inject
    public GrpcServer(CoreContext coreContext, Config config, PasswordAuthInterceptor passwordAuthInterceptor, GrpcAccountService accountService, GrpcDisputeAgentsService disputeAgentsService, GrpcDisputesService disputesService, GrpcHelpService helpService, GrpcOffersService offersService, GrpcPaymentAccountsService paymentAccountsService, GrpcPriceService priceService, GrpcShutdownService shutdownService, GrpcVersionService versionService, GrpcGetTradeStatisticsService tradeStatisticsService, GrpcTradesService tradesService, GrpcWalletsService walletsService, GrpcNotificationsService notificationsService, GrpcXmrConnectionService moneroConnectionsService, GrpcXmrNodeService moneroNodeService) {
        this.server = ((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)ServerBuilder.forPort(config.apiPort).addService(ServerInterceptors.interceptForward((BindableService)accountService, accountService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)disputeAgentsService, disputeAgentsService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)disputesService, disputesService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)helpService, helpService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)offersService, offersService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)paymentAccountsService, paymentAccountsService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)priceService, priceService.interceptors()))).addService(shutdownService)).addService(ServerInterceptors.interceptForward((BindableService)tradeStatisticsService, tradeStatisticsService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)tradesService, tradesService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)versionService, versionService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)walletsService, walletsService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)notificationsService, notificationsService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)moneroConnectionsService, moneroConnectionsService.interceptors()))).addService(ServerInterceptors.interceptForward((BindableService)moneroNodeService, moneroNodeService.interceptors()))).intercept(passwordAuthInterceptor)).build();
        coreContext.setApiUser(true);
    }

    public void start() {
        try {
            this.server.start();
            log.info("listening on port {}", (Object)this.server.getPort());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void shutdown() {
        log.info("Server shutdown started");
        this.server.shutdown();
        log.info("Server shutdown complete");
    }
}

