/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc;

import com.google.inject.Inject;
import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.core.api.CoreApi;
import haveno.core.api.model.AddressBalanceInfo;
import haveno.core.api.model.BalancesInfo;
import haveno.core.api.model.XmrTx;
import haveno.daemon.grpc.GrpcExceptionHandler;
import haveno.daemon.grpc.interceptor.CallRateMeteringInterceptor;
import haveno.daemon.grpc.interceptor.GrpcCallRateMeter;
import haveno.daemon.grpc.interceptor.GrpcServiceRateMeteringConfig;
import haveno.proto.grpc.CreateXmrTxReply;
import haveno.proto.grpc.CreateXmrTxRequest;
import haveno.proto.grpc.GetAddressBalanceReply;
import haveno.proto.grpc.GetAddressBalanceRequest;
import haveno.proto.grpc.GetBalancesReply;
import haveno.proto.grpc.GetBalancesRequest;
import haveno.proto.grpc.GetFundingAddressesReply;
import haveno.proto.grpc.GetFundingAddressesRequest;
import haveno.proto.grpc.GetXmrNewSubaddressReply;
import haveno.proto.grpc.GetXmrNewSubaddressRequest;
import haveno.proto.grpc.GetXmrPrimaryAddressReply;
import haveno.proto.grpc.GetXmrPrimaryAddressRequest;
import haveno.proto.grpc.GetXmrSeedReply;
import haveno.proto.grpc.GetXmrSeedRequest;
import haveno.proto.grpc.GetXmrTxsReply;
import haveno.proto.grpc.GetXmrTxsRequest;
import haveno.proto.grpc.LockWalletReply;
import haveno.proto.grpc.LockWalletRequest;
import haveno.proto.grpc.RelayXmrTxReply;
import haveno.proto.grpc.RelayXmrTxRequest;
import haveno.proto.grpc.RemoveWalletPasswordReply;
import haveno.proto.grpc.RemoveWalletPasswordRequest;
import haveno.proto.grpc.SetWalletPasswordReply;
import haveno.proto.grpc.SetWalletPasswordRequest;
import haveno.proto.grpc.UnlockWalletReply;
import haveno.proto.grpc.UnlockWalletRequest;
import haveno.proto.grpc.WalletsGrpc;
import io.grpc.ServerInterceptor;
import io.grpc.stub.StreamObserver;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import monero.wallet.model.MoneroDestination;
import monero.wallet.model.MoneroTxWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcWalletsService
extends WalletsGrpc.WalletsImplBase {
    private static final Logger log = LoggerFactory.getLogger(GrpcWalletsService.class);
    private final CoreApi coreApi;
    private final GrpcExceptionHandler exceptionHandler;

    @Inject
    public GrpcWalletsService(CoreApi coreApi, GrpcExceptionHandler exceptionHandler) {
        this.coreApi = coreApi;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void getBalances(GetBalancesRequest req, StreamObserver<GetBalancesReply> responseObserver) {
        UserThread.execute(() -> {
            try {
                BalancesInfo balances = this.coreApi.getBalances(req.getCurrencyCode());
                GetBalancesReply reply = GetBalancesReply.newBuilder().setBalances(balances.toProtoMessage()).build();
                responseObserver.onNext(reply);
                responseObserver.onCompleted();
            }
            catch (Throwable cause) {
                this.exceptionHandler.handleException(log, cause, responseObserver);
            }
        });
    }

    @Override
    public void getXmrSeed(GetXmrSeedRequest req, StreamObserver<GetXmrSeedReply> responseObserver) {
        try {
            GetXmrSeedReply reply = GetXmrSeedReply.newBuilder().setSeed(this.coreApi.getXmrSeed()).build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void getXmrPrimaryAddress(GetXmrPrimaryAddressRequest req, StreamObserver<GetXmrPrimaryAddressReply> responseObserver) {
        try {
            GetXmrPrimaryAddressReply reply = GetXmrPrimaryAddressReply.newBuilder().setPrimaryAddress(this.coreApi.getXmrPrimaryAddress()).build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void getXmrNewSubaddress(GetXmrNewSubaddressRequest req, StreamObserver<GetXmrNewSubaddressReply> responseObserver) {
        try {
            String subaddress = this.coreApi.getXmrNewSubaddress();
            GetXmrNewSubaddressReply reply = GetXmrNewSubaddressReply.newBuilder().setSubaddress(subaddress).build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void getXmrTxs(GetXmrTxsRequest req, StreamObserver<GetXmrTxsReply> responseObserver) {
        try {
            List<MoneroTxWallet> xmrTxs = this.coreApi.getXmrTxs();
            GetXmrTxsReply reply = GetXmrTxsReply.newBuilder().addAllTxs(xmrTxs.stream().map(s2 -> XmrTx.toXmrTx(s2).toProtoMessage()).collect(Collectors.toList())).build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void createXmrTx(CreateXmrTxRequest req, StreamObserver<CreateXmrTxReply> responseObserver) {
        try {
            MoneroTxWallet tx = this.coreApi.createXmrTx(req.getDestinationsList().stream().map(s2 -> new MoneroDestination(s2.getAddress(), new BigInteger(s2.getAmount()))).collect(Collectors.toList()));
            log.info("Successfully created XMR tx: hash {}", (Object)tx.getHash());
            CreateXmrTxReply reply = CreateXmrTxReply.newBuilder().setTx(XmrTx.toXmrTx(tx).toProtoMessage()).build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void relayXmrTx(RelayXmrTxRequest req, StreamObserver<RelayXmrTxReply> responseObserver) {
        try {
            String txHash = this.coreApi.relayXmrTx(req.getMetadata());
            RelayXmrTxReply reply = RelayXmrTxReply.newBuilder().setHash(txHash).build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void getAddressBalance(GetAddressBalanceRequest req, StreamObserver<GetAddressBalanceReply> responseObserver) {
        try {
            AddressBalanceInfo balanceInfo = this.coreApi.getAddressBalanceInfo(req.getAddress());
            GetAddressBalanceReply reply = GetAddressBalanceReply.newBuilder().setAddressBalanceInfo(balanceInfo.toProtoMessage()).build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void getFundingAddresses(GetFundingAddressesRequest req, StreamObserver<GetFundingAddressesReply> responseObserver) {
        try {
            List<AddressBalanceInfo> balanceInfo = this.coreApi.getFundingAddresses();
            GetFundingAddressesReply reply = GetFundingAddressesReply.newBuilder().addAllAddressBalanceInfo(balanceInfo.stream().map(AddressBalanceInfo::toProtoMessage).collect(Collectors.toList())).build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void setWalletPassword(SetWalletPasswordRequest req, StreamObserver<SetWalletPasswordReply> responseObserver) {
        try {
            this.coreApi.setWalletPassword(req.getPassword(), req.getNewPassword());
            SetWalletPasswordReply reply = SetWalletPasswordReply.newBuilder().build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void removeWalletPassword(RemoveWalletPasswordRequest req, StreamObserver<RemoveWalletPasswordReply> responseObserver) {
        try {
            this.coreApi.removeWalletPassword(req.getPassword());
            RemoveWalletPasswordReply reply = RemoveWalletPasswordReply.newBuilder().build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void lockWallet(LockWalletRequest req, StreamObserver<LockWalletReply> responseObserver) {
        try {
            this.coreApi.lockWallet();
            LockWalletReply reply = LockWalletReply.newBuilder().build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    @Override
    public void unlockWallet(UnlockWalletRequest req, StreamObserver<UnlockWalletReply> responseObserver) {
        try {
            this.coreApi.unlockWallet(req.getPassword(), req.getTimeout());
            UnlockWalletReply reply = UnlockWalletReply.newBuilder().build();
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable cause) {
            this.exceptionHandler.handleException(log, cause, responseObserver);
        }
    }

    /*
     * Exception decompiling
     */
    final ServerInterceptor[] interceptors() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final Optional<ServerInterceptor> rateMeteringInterceptor() {
        return GrpcServiceRateMeteringConfig.getCustomRateMeteringInterceptor(this.coreApi.getConfig().appDataDir, this.getClass()).or(() -> Optional.of(CallRateMeteringInterceptor.valueOf((Map<String, GrpcCallRateMeter>)new HashMap<String, GrpcCallRateMeter>(){
            {
                this.put(WalletsGrpc.getGetBalancesMethod().getFullMethodName(), new GrpcCallRateMeter(Config.baseCurrencyNetwork().isTestnet() ? 100 : 1, TimeUnit.SECONDS));
                this.put(WalletsGrpc.getGetAddressBalanceMethod().getFullMethodName(), new GrpcCallRateMeter(1, TimeUnit.SECONDS));
                this.put(WalletsGrpc.getGetFundingAddressesMethod().getFullMethodName(), new GrpcCallRateMeter(1, TimeUnit.SECONDS));
                this.put(WalletsGrpc.getSetWalletPasswordMethod().getFullMethodName(), new GrpcCallRateMeter(1, TimeUnit.SECONDS, 5));
                this.put(WalletsGrpc.getRemoveWalletPasswordMethod().getFullMethodName(), new GrpcCallRateMeter(1, TimeUnit.SECONDS, 5));
                this.put(WalletsGrpc.getLockWalletMethod().getFullMethodName(), new GrpcCallRateMeter(1, TimeUnit.SECONDS));
                this.put(WalletsGrpc.getUnlockWalletMethod().getFullMethodName(), new GrpcCallRateMeter(1, TimeUnit.SECONDS));
            }
        })));
    }

    private static /* synthetic */ ServerInterceptor[] lambda$interceptors$4() {
        return new ServerInterceptor[0];
    }
}

