/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc.interceptor;

import haveno.daemon.grpc.interceptor.GrpcCallRateMeter;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CallRateMeteringInterceptor
implements ServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CallRateMeteringInterceptor.class);
    protected final Map<String, GrpcCallRateMeter> serviceCallRateMeters;

    public CallRateMeteringInterceptor(Map<String, GrpcCallRateMeter> serviceCallRateMeters) {
        this.serviceCallRateMeters = serviceCallRateMeters;
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata headers, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        Optional<Map.Entry<String, GrpcCallRateMeter>> rateMeterKV = this.getRateMeterKV(serverCall);
        rateMeterKV.ifPresentOrElse(kv -> this.checkRateMeterAndMaybeCloseCall((Map.Entry<String, GrpcCallRateMeter>)kv, serverCall), () -> this.handleMissingRateMeterConfiguration(serverCall));
        return serverCallHandler.startCall(serverCall, headers);
    }

    private void checkRateMeterAndMaybeCloseCall(Map.Entry<String, GrpcCallRateMeter> rateMeterKV, ServerCall<?, ?> serverCall) {
        String methodName = rateMeterKV.getKey();
        GrpcCallRateMeter rateMeter = rateMeterKV.getValue();
        if (!rateMeter.checkAndIncrement()) {
            this.handlePermissionDeniedWarningAndCloseCall(methodName, rateMeter, serverCall);
        } else {
            log.info(rateMeter.getCallsCountProgress(methodName));
        }
    }

    private void handleMissingRateMeterConfiguration(ServerCall<?, ?> serverCall) throws StatusRuntimeException {
        log.debug("The gRPC service's call rate metering interceptor does not meter the {} method.", (Object)this.getRateMeterKey(serverCall));
    }

    private void handlePermissionDeniedWarningAndCloseCall(String methodName, GrpcCallRateMeter rateMeter, ServerCall<?, ?> serverCall) throws StatusRuntimeException {
        String msg = this.getDefaultRateExceededError(methodName, rateMeter);
        log.warn(msg + ".");
        serverCall.close(Status.PERMISSION_DENIED.withDescription(msg.toLowerCase()), new Metadata());
    }

    private String getDefaultRateExceededError(String methodName, GrpcCallRateMeter rateMeter) {
        String timeUnitName = StringUtils.chop(rateMeter.getTimeUnit().name().toLowerCase());
        String loggedMethodName = methodName.split("/")[1];
        return String.format("The maximum allowed number of %s calls (%d/%s) has been exceeded", loggedMethodName, rateMeter.getAllowedCallsPerTimeWindow(), timeUnitName);
    }

    private Optional<Map.Entry<String, GrpcCallRateMeter>> getRateMeterKV(ServerCall<?, ?> serverCall) {
        String rateMeterKey = this.getRateMeterKey(serverCall);
        return this.serviceCallRateMeters.entrySet().stream().filter(e -> ((String)e.getKey()).equals(rateMeterKey)).findFirst();
    }

    private String getRateMeterKey(ServerCall<?, ?> serverCall) {
        return serverCall.getMethodDescriptor().getFullMethodName();
    }

    public String toString() {
        String rateMetersString = this.serviceCallRateMeters.entrySet().stream().map(Object::toString).collect(Collectors.joining("\n\t\t"));
        return "CallRateMeteringInterceptor {\n\tserviceCallRateMeters {\n\t\t" + rateMetersString + "\n\t}\n}";
    }

    public static CallRateMeteringInterceptor valueOf(final Map<String, GrpcCallRateMeter> rateMeters) {
        return new CallRateMeteringInterceptor((Map<String, GrpcCallRateMeter>)new HashMap<String, GrpcCallRateMeter>(){
            {
                this.putAll(rateMeters);
            }
        });
    }
}

