/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc.interceptor;

import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcCallRateMeter {
    private static final Logger log = LoggerFactory.getLogger(GrpcCallRateMeter.class);
    private final int allowedCallsPerTimeWindow;
    private final TimeUnit timeUnit;
    private final int numTimeUnits;
    private final transient long timeUnitIntervalInMilliseconds;
    private final transient ArrayDeque<Long> callTimestamps;
    private final Predicate<Long> isStale = t2 -> {
        long stale = System.currentTimeMillis() - this.getTimeUnitIntervalInMilliseconds();
        return t2 < stale;
    };

    public GrpcCallRateMeter(int allowedCallsPerTimeWindow, TimeUnit timeUnit) {
        this(allowedCallsPerTimeWindow, timeUnit, 1);
    }

    public GrpcCallRateMeter(int allowedCallsPerTimeWindow, TimeUnit timeUnit, int numTimeUnits) {
        this.allowedCallsPerTimeWindow = allowedCallsPerTimeWindow;
        this.timeUnit = timeUnit;
        this.numTimeUnits = numTimeUnits;
        this.timeUnitIntervalInMilliseconds = timeUnit.toMillis(1L) * (long)numTimeUnits;
        this.callTimestamps = new ArrayDeque();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndIncrement() {
        ArrayDeque<Long> arrayDeque = this.callTimestamps;
        synchronized (arrayDeque) {
            if (this.getCallsCount() < this.allowedCallsPerTimeWindow) {
                this.incrementCallsCount();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCallsCount() {
        ArrayDeque<Long> arrayDeque = this.callTimestamps;
        synchronized (arrayDeque) {
            this.removeStaleCallTimestamps();
            return this.callTimestamps.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCallsCountProgress(String calledMethodName) {
        ArrayDeque<Long> arrayDeque = this.callTimestamps;
        synchronized (arrayDeque) {
            String shortTimeUnitName = StringUtils.chop(this.timeUnit.name().toLowerCase());
            String loggedMethodName = calledMethodName.split("/")[1];
            return String.format("%s has been called %d time%s in the last %s, rate limit is %d/%s", loggedMethodName, this.callTimestamps.size(), this.callTimestamps.size() == 1 ? "" : "s", shortTimeUnitName, this.allowedCallsPerTimeWindow, shortTimeUnitName);
        }
    }

    private void incrementCallsCount() {
        this.callTimestamps.add(System.currentTimeMillis());
    }

    private void removeStaleCallTimestamps() {
        while (!this.callTimestamps.isEmpty() && this.isStale.test(this.callTimestamps.peek())) {
            this.callTimestamps.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayDeque<Long> arrayDeque = this.callTimestamps;
        synchronized (arrayDeque) {
            return "GrpcCallRateMeter{allowedCallsPerTimeWindow=" + this.allowedCallsPerTimeWindow + ", timeUnit=" + this.timeUnit.name() + ", timeUnitIntervalInMilliseconds=" + this.timeUnitIntervalInMilliseconds + ", callsCount=" + this.callTimestamps.size() + "}";
        }
    }

    public int getAllowedCallsPerTimeWindow() {
        return this.allowedCallsPerTimeWindow;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public int getNumTimeUnits() {
        return this.numTimeUnits;
    }

    public long getTimeUnitIntervalInMilliseconds() {
        return this.timeUnitIntervalInMilliseconds;
    }
}

