/*
 * Decompiled with CFR 0.152.
 */
package haveno.daemon.grpc.interceptor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import haveno.common.file.FileUtil;
import haveno.daemon.grpc.interceptor.CallRateMeteringInterceptor;
import haveno.daemon.grpc.interceptor.GrpcCallRateMeter;
import io.grpc.ServerInterceptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class GrpcServiceRateMeteringConfig {
    private static final Logger log = LoggerFactory.getLogger(GrpcServiceRateMeteringConfig.class);
    public static final String RATE_METERS_CONFIG_FILENAME = "ratemeters.json";
    private static final String KEY_GRPC_SERVICE_CLASS_NAME = "grpcServiceClassName";
    private static final String KEY_METHOD_RATE_METERS = "methodRateMeters";
    private static final String KEY_ALLOWED_CALL_PER_TIME_WINDOW = "allowedCallsPerTimeWindow";
    private static final String KEY_TIME_UNIT = "timeUnit";
    private static final String KEY_NUM_TIME_UNITS = "numTimeUnits";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final List<Map<String, GrpcCallRateMeter>> methodRateMeters;
    private final String grpcServiceClassName;
    private static List<GrpcServiceRateMeteringConfig> allDeserializedConfigs;

    public GrpcServiceRateMeteringConfig(String grpcServiceClassName) {
        this(grpcServiceClassName, new ArrayList<Map<String, GrpcCallRateMeter>>());
    }

    public GrpcServiceRateMeteringConfig(String grpcServiceClassName, List<Map<String, GrpcCallRateMeter>> methodRateMeters) {
        this.grpcServiceClassName = grpcServiceClassName;
        this.methodRateMeters = methodRateMeters;
    }

    public GrpcServiceRateMeteringConfig addMethodCallRateMeter(String methodName, int maxCalls, TimeUnit timeUnit) {
        return this.addMethodCallRateMeter(methodName, maxCalls, timeUnit, 1);
    }

    public GrpcServiceRateMeteringConfig addMethodCallRateMeter(final String methodName, final int maxCalls, final TimeUnit timeUnit, final int numTimeUnits) {
        this.methodRateMeters.add((Map<String, GrpcCallRateMeter>)new LinkedHashMap<String, GrpcCallRateMeter>(){
            {
                this.put(methodName, new GrpcCallRateMeter(maxCalls, timeUnit, numTimeUnits));
            }
        });
        return this;
    }

    public boolean isConfigForGrpcService(Class<?> clazz) {
        return this.isConfigForGrpcService(clazz.getSimpleName());
    }

    public boolean isConfigForGrpcService(String grpcServiceClassSimpleName) {
        return this.grpcServiceClassName.equals(grpcServiceClassSimpleName);
    }

    public String toString() {
        return "GrpcServiceRateMeteringConfig{\n  grpcServiceClassName='" + this.grpcServiceClassName + "'\n, methodRateMeters=" + String.valueOf(this.methodRateMeters) + "\n}";
    }

    public static Optional<ServerInterceptor> getCustomRateMeteringInterceptor(File installationDir, Class<?> grpcServiceClass) {
        File configFile = new File(installationDir, RATE_METERS_CONFIG_FILENAME);
        return configFile.exists() ? GrpcServiceRateMeteringConfig.toServerInterceptor(configFile, grpcServiceClass) : Optional.empty();
    }

    public static Optional<ServerInterceptor> toServerInterceptor(File configFile, Class<?> grpcServiceClass) {
        Optional<GrpcServiceRateMeteringConfig> grpcServiceConfig = GrpcServiceRateMeteringConfig.getAllDeserializedConfigs(configFile).stream().filter(x -> x.isConfigForGrpcService(grpcServiceClass)).findFirst();
        if (grpcServiceConfig.isPresent()) {
            HashMap<String, GrpcCallRateMeter> serviceCallRateMeters = new HashMap<String, GrpcCallRateMeter>();
            for (Map<String, GrpcCallRateMeter> methodToRateMeterMap : grpcServiceConfig.get().methodRateMeters) {
                Map.Entry entry = (Map.Entry)methodToRateMeterMap.entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("Gson deserialized a method rate meter configuration into an empty map."));
                serviceCallRateMeters.put((String)entry.getKey(), (GrpcCallRateMeter)entry.getValue());
            }
            return Optional.of(new CallRateMeteringInterceptor(serviceCallRateMeters));
        }
        return Optional.empty();
    }

    private static List<Map<String, GrpcCallRateMeter>> getMethodRateMetersMap(Map<String, Object> gsonMap) {
        ArrayList<Map<String, GrpcCallRateMeter>> rateMeters = new ArrayList<Map<String, GrpcCallRateMeter>>();
        for (Map singleEntryRateMeterMap : (List)gsonMap.get(KEY_METHOD_RATE_METERS)) {
            log.debug("Gson's single entry {} {}<String, Object> = {}", gsonMap.get(KEY_GRPC_SERVICE_CLASS_NAME), singleEntryRateMeterMap.getClass().getSimpleName(), singleEntryRateMeterMap);
            Map.Entry entry = (Map.Entry)singleEntryRateMeterMap.entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("Gson deserialized a method rate meter configuration into an empty map."));
            final String methodName = (String)entry.getKey();
            final GrpcCallRateMeter rateMeter = GrpcServiceRateMeteringConfig.getGrpcCallRateMeter(entry);
            rateMeters.add((Map<String, GrpcCallRateMeter>)new LinkedHashMap<String, GrpcCallRateMeter>(){
                {
                    this.put(methodName, rateMeter);
                }
            });
        }
        return rateMeters;
    }

    public static List<GrpcServiceRateMeteringConfig> deserialize(File configFile) {
        GrpcServiceRateMeteringConfig.verifyConfigFile(configFile);
        ArrayList<GrpcServiceRateMeteringConfig> serviceMethodConfigurations = new ArrayList<GrpcServiceRateMeteringConfig>();
        List rawConfigList = gson.fromJson(GrpcServiceRateMeteringConfig.toJson(configFile), ArrayList.class);
        for (Object rawConfig : rawConfigList) {
            Map gsonMap = (Map)rawConfig;
            String grpcServiceClassName = (String)gsonMap.get(KEY_GRPC_SERVICE_CLASS_NAME);
            List<Map<String, GrpcCallRateMeter>> rateMeters = GrpcServiceRateMeteringConfig.getMethodRateMetersMap(gsonMap);
            serviceMethodConfigurations.add(new GrpcServiceRateMeteringConfig(grpcServiceClassName, rateMeters));
        }
        return serviceMethodConfigurations;
    }

    private static GrpcCallRateMeter getGrpcCallRateMeter(Map.Entry<String, Object> gsonEntry) {
        Map valueMap = (Map)gsonEntry.getValue();
        int allowedCallsPerTimeWindow = ((Number)valueMap.get(KEY_ALLOWED_CALL_PER_TIME_WINDOW)).intValue();
        TimeUnit timeUnit = TimeUnit.valueOf((String)valueMap.get(KEY_TIME_UNIT));
        int numTimeUnits = ((Number)valueMap.get(KEY_NUM_TIME_UNITS)).intValue();
        return new GrpcCallRateMeter(allowedCallsPerTimeWindow, timeUnit, numTimeUnits);
    }

    private static void verifyConfigFile(File configFile) {
        if (configFile == null) {
            throw new IllegalStateException("Cannot read null json config file.");
        }
        if (!configFile.exists()) {
            throw new IllegalStateException(String.format("cannot find json config file %s", configFile.getAbsolutePath()));
        }
    }

    private static String toJson(File configFile) {
        try {
            return new String(Files.readAllBytes(Paths.get(configFile.getAbsolutePath(), new String[0])));
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Cannot read json string from file %s.", configFile.getAbsolutePath()));
        }
    }

    private static List<GrpcServiceRateMeteringConfig> getAllDeserializedConfigs(File configFile) {
        if (allDeserializedConfigs == null) {
            allDeserializedConfigs = GrpcServiceRateMeteringConfig.deserialize(configFile);
        }
        return allDeserializedConfigs;
    }

    @VisibleForTesting
    public static class Builder {
        private final List<GrpcServiceRateMeteringConfig> rateMeterConfigs = new ArrayList<GrpcServiceRateMeteringConfig>();

        public void addCallRateMeter(String grpcServiceClassName, String methodName, int maxCalls, TimeUnit timeUnit) {
            this.addCallRateMeter(grpcServiceClassName, methodName, maxCalls, timeUnit, 1);
        }

        public void addCallRateMeter(String grpcServiceClassName, String methodName, int maxCalls, TimeUnit timeUnit, int numTimeUnits) {
            log.info("Adding call rate metering definition {}.{} ({}/{}ms).", grpcServiceClassName, methodName, maxCalls, timeUnit.toMillis(1L) * (long)numTimeUnits);
            this.rateMeterConfigs.stream().filter(c -> c.isConfigForGrpcService(grpcServiceClassName)).findFirst().ifPresentOrElse(config -> config.addMethodCallRateMeter(methodName, maxCalls, timeUnit, numTimeUnits), () -> this.rateMeterConfigs.add(new GrpcServiceRateMeteringConfig(grpcServiceClassName).addMethodCallRateMeter(methodName, maxCalls, timeUnit, numTimeUnits)));
        }

        public File build() {
            File tmpFile = this.serializeRateMeterDefinitions();
            File configFile = Paths.get(System.getProperty("java.io.tmpdir"), GrpcServiceRateMeteringConfig.RATE_METERS_CONFIG_FILENAME).toFile();
            try {
                FileUtil.deleteFileIfExists(configFile);
                FileUtil.renameFile(tmpFile, configFile);
            }
            catch (IOException ex) {
                throw new IllegalStateException(String.format("Could not create config file %s.", configFile.getAbsolutePath()), ex);
            }
            return configFile;
        }

        private File serializeRateMeterDefinitions() {
            String json = gson.toJson(this.rateMeterConfigs);
            File file = this.createTmpFile();
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(Preconditions.checkNotNull(file), false), StandardCharsets.UTF_8);){
                outputStreamWriter.write(json);
            }
            catch (Exception ex) {
                throw new IllegalStateException(String.format("Cannot write file for json string %s.", json), ex);
            }
            return file;
        }

        private File createTmpFile() {
            File file;
            try {
                file = File.createTempFile("ratemeters_", ".tmp", Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).toFile());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot create tmp ratemeters json file.", ex);
            }
            return file;
        }
    }
}

