/*
 * Decompiled with CFR 0.152.
 */
package haveno.network;

import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import haveno.network.Socks5DnsDiscovery;
import haveno.network.Socks5SeedOnionDiscovery;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.net.discovery.SeedPeers;
import org.bitcoinj.params.MainNetParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Socks5MultiDiscovery
implements PeerDiscovery {
    private static final Logger log = LoggerFactory.getLogger(Socks5MultiDiscovery.class);
    public static final int SOCKS5_DISCOVER_ADDR = 1;
    public static final int SOCKS5_DISCOVER_DNS = 16;
    public static final int SOCKS5_DISCOVER_ONION = 256;
    public static final int SOCKS5_DISCOVER_ALL = 4369;
    private final ArrayList<PeerDiscovery> discoveryList = new ArrayList();

    public Socks5MultiDiscovery(Socks5Proxy proxy, NetworkParameters params, int mode) {
        if ((mode & 0x100) != 0) {
            this.discoveryList.add(new Socks5SeedOnionDiscovery(proxy, params));
        }
        if ((mode & 1) != 0 && params == MainNetParams.get()) {
            this.discoveryList.add(new SeedPeers(params));
        }
        if ((mode & 0x10) != 0) {
            this.discoveryList.add(new Socks5DnsDiscovery(proxy, params));
        }
    }

    @Override
    public InetSocketAddress[] getPeers(long services, long timeoutValue, TimeUnit timeoutUnit) throws PeerDiscoveryException {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>();
        for (PeerDiscovery discovery : this.discoveryList) {
            list.addAll(Arrays.asList(discovery.getPeers(services, timeoutValue, timeoutUnit)));
        }
        return list.toArray(new InetSocketAddress[list.size()]);
    }

    @Override
    public void shutdown() {
    }
}

