/*
 * Decompiled with CFR 0.152.
 */
package haveno.network;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import haveno.network.p2p.network.NetworkNode;
import java.net.UnknownHostException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Socks5ProxyProvider {
    private static final Logger log = LoggerFactory.getLogger(Socks5ProxyProvider.class);
    @Nullable
    private NetworkNode socks5ProxyInternalFactory;
    @Nullable
    private final Socks5Proxy socks5ProxyXmr;
    @Nullable
    private final Socks5Proxy socks5ProxyHttp;

    @Inject
    public Socks5ProxyProvider(@Named(value="socks5ProxyXmrAddress") String socks5ProxyXmrAddress, @Named(value="socks5ProxyHttpAddress") String socks5ProxyHttpAddress) {
        this.socks5ProxyXmr = this.getProxyFromAddress(socks5ProxyXmrAddress);
        this.socks5ProxyHttp = this.getProxyFromAddress(socks5ProxyHttpAddress);
    }

    @Nullable
    public Socks5Proxy getSocks5Proxy() {
        if (this.socks5ProxyXmr != null) {
            return this.socks5ProxyXmr;
        }
        if (this.socks5ProxyInternalFactory != null) {
            return this.getSocks5ProxyInternal();
        }
        return null;
    }

    @Nullable
    public Socks5Proxy getSocks5ProxyXmr() {
        return this.socks5ProxyXmr;
    }

    @Nullable
    public Socks5Proxy getSocks5ProxyHttp() {
        return this.socks5ProxyHttp;
    }

    @Nullable
    public Socks5Proxy getSocks5ProxyInternal() {
        return this.socks5ProxyInternalFactory.getSocksProxy();
    }

    public void setSocks5ProxyInternal(@Nullable NetworkNode havenoSocks5ProxyFactory) {
        this.socks5ProxyInternalFactory = havenoSocks5ProxyFactory;
    }

    @Nullable
    private Socks5Proxy getProxyFromAddress(String socks5ProxyAddress) {
        if (!socks5ProxyAddress.isEmpty()) {
            String[] tokens = socks5ProxyAddress.split(":");
            if (tokens.length == 2) {
                try {
                    Socks5Proxy proxy = new Socks5Proxy(tokens[0], (int)Integer.valueOf(tokens[1]));
                    proxy.resolveAddrLocally(false);
                    return proxy;
                }
                catch (UnknownHostException e) {
                    log.error(ExceptionUtils.getStackTrace(e));
                }
            } else {
                log.error("Incorrect format for socks5ProxyAddress. Should be: host:port.\nsocks5ProxyAddress=" + socks5ProxyAddress);
            }
        }
        return null;
    }
}

