/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.crypto;

import com.google.inject.Inject;
import com.google.protobuf.InvalidProtocolBufferException;
import haveno.common.crypto.CryptoException;
import haveno.common.crypto.Encryption;
import haveno.common.crypto.Hash;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.PubKeyRing;
import haveno.common.crypto.SealedAndSigned;
import haveno.common.crypto.Sig;
import haveno.common.proto.ProtobufferException;
import haveno.common.proto.network.NetworkProtoResolver;
import haveno.network.crypto.DecryptedDataTuple;
import haveno.network.p2p.DecryptedMessageWithPubKey;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.NetworkEnvelope;

public class EncryptionService {
    private static final Logger log = LoggerFactory.getLogger(EncryptionService.class);
    private final KeyRing keyRing;
    private final NetworkProtoResolver networkProtoResolver;

    @Inject
    public EncryptionService(KeyRing keyRing, NetworkProtoResolver networkProtoResolver) {
        this.keyRing = keyRing;
        this.networkProtoResolver = networkProtoResolver;
    }

    public SealedAndSigned encryptAndSign(PubKeyRing pubKeyRing, haveno.common.proto.network.NetworkEnvelope networkEnvelope) throws CryptoException {
        return EncryptionService.encryptHybridWithSignature(networkEnvelope, this.keyRing.getSignatureKeyPair(), pubKeyRing.getEncryptionPubKey());
    }

    public DecryptedDataTuple decryptHybridWithSignature(SealedAndSigned sealedAndSigned, PrivateKey privateKey) throws CryptoException, ProtobufferException {
        SecretKey secretKey = Encryption.decryptSecretKey(sealedAndSigned.getEncryptedSecretKey(), privateKey);
        boolean isValid = Sig.verify(sealedAndSigned.getSigPublicKey(), Hash.getSha256Hash(sealedAndSigned.getEncryptedPayloadWithHmac()), sealedAndSigned.getSignature());
        if (!isValid) {
            throw new CryptoException("Signature verification failed.");
        }
        try {
            byte[] bytes = Encryption.decryptPayloadWithHmac(sealedAndSigned.getEncryptedPayloadWithHmac(), secretKey);
            NetworkEnvelope envelope = NetworkEnvelope.parseFrom(bytes);
            haveno.common.proto.network.NetworkEnvelope decryptedPayload = this.networkProtoResolver.fromProto(envelope);
            return new DecryptedDataTuple(decryptedPayload, sealedAndSigned.getSigPublicKey());
        }
        catch (InvalidProtocolBufferException e) {
            throw new ProtobufferException("Unable to parse protobuffer message.", e);
        }
    }

    public DecryptedMessageWithPubKey decryptAndVerify(SealedAndSigned sealedAndSigned) throws CryptoException, ProtobufferException {
        DecryptedDataTuple decryptedDataTuple = this.decryptHybridWithSignature(sealedAndSigned, this.keyRing.getEncryptionKeyPair().getPrivate());
        return new DecryptedMessageWithPubKey(decryptedDataTuple.getNetworkEnvelope(), decryptedDataTuple.getSigPublicKey());
    }

    private static byte[] encryptPayloadWithHmac(haveno.common.proto.network.NetworkEnvelope networkEnvelope, SecretKey secretKey) throws CryptoException {
        return Encryption.encryptPayloadWithHmac(networkEnvelope.toProtoNetworkEnvelope().toByteArray(), secretKey);
    }

    public static SealedAndSigned encryptHybridWithSignature(haveno.common.proto.network.NetworkEnvelope payload, KeyPair signatureKeyPair, PublicKey encryptionPublicKey) throws CryptoException {
        SecretKey secretKey = Encryption.generateSecretKey(256);
        byte[] encryptedSecretKey = Encryption.encryptSecretKey(secretKey, encryptionPublicKey);
        byte[] encryptedPayloadWithHmac = EncryptionService.encryptPayloadWithHmac(payload, secretKey);
        byte[] hash = Hash.getSha256Hash(encryptedPayloadWithHmac);
        byte[] signature = Sig.sign(signatureKeyPair.getPrivate(), hash);
        return new SealedAndSigned(encryptedSecretKey, encryptedPayloadWithHmac, signature, signatureKeyPair.getPublic());
    }
}

