/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p;

import com.google.protobuf.ByteString;
import haveno.common.crypto.Sig;
import haveno.common.proto.ProtobufferException;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.proto.network.NetworkProtoResolver;
import haveno.common.proto.persistable.PersistablePayload;
import java.security.PublicKey;
import java.util.Arrays;

public final class DecryptedMessageWithPubKey
implements PersistablePayload {
    private final NetworkEnvelope networkEnvelope;
    private final byte[] signaturePubKeyBytes;
    private final transient PublicKey signaturePubKey;

    public DecryptedMessageWithPubKey(NetworkEnvelope networkEnvelope, PublicKey signaturePubKey) {
        this.networkEnvelope = networkEnvelope;
        this.signaturePubKey = signaturePubKey;
        this.signaturePubKeyBytes = Sig.getPublicKeyBytes(signaturePubKey);
    }

    private DecryptedMessageWithPubKey(NetworkEnvelope networkEnvelope, byte[] signaturePubKeyBytes) {
        this.networkEnvelope = networkEnvelope;
        this.signaturePubKeyBytes = signaturePubKeyBytes;
        this.signaturePubKey = Sig.getPublicKeyFromBytes(signaturePubKeyBytes);
    }

    @Override
    public protobuf.DecryptedMessageWithPubKey toProtoMessage() {
        return protobuf.DecryptedMessageWithPubKey.newBuilder().setNetworkEnvelope(this.networkEnvelope.toProtoNetworkEnvelope()).setSignaturePubKeyBytes(ByteString.copyFrom(this.signaturePubKeyBytes)).build();
    }

    public static DecryptedMessageWithPubKey fromProto(protobuf.DecryptedMessageWithPubKey proto, NetworkProtoResolver networkProtoResolver) throws ProtobufferException {
        return new DecryptedMessageWithPubKey(networkProtoResolver.fromProto(proto.getNetworkEnvelope()), proto.getSignaturePubKeyBytes().toByteArray());
    }

    public NetworkEnvelope getNetworkEnvelope() {
        return this.networkEnvelope;
    }

    public byte[] getSignaturePubKeyBytes() {
        return this.signaturePubKeyBytes;
    }

    public PublicKey getSignaturePubKey() {
        return this.signaturePubKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecryptedMessageWithPubKey)) {
            return false;
        }
        DecryptedMessageWithPubKey other = (DecryptedMessageWithPubKey)o;
        NetworkEnvelope this$networkEnvelope = this.getNetworkEnvelope();
        NetworkEnvelope other$networkEnvelope = other.getNetworkEnvelope();
        if (this$networkEnvelope == null ? other$networkEnvelope != null : !((Object)this$networkEnvelope).equals(other$networkEnvelope)) {
            return false;
        }
        return Arrays.equals(this.getSignaturePubKeyBytes(), other.getSignaturePubKeyBytes());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NetworkEnvelope $networkEnvelope = this.getNetworkEnvelope();
        result = result * 59 + ($networkEnvelope == null ? 43 : ((Object)$networkEnvelope).hashCode());
        result = result * 59 + Arrays.hashCode(this.getSignaturePubKeyBytes());
        return result;
    }

    public String toString() {
        return "DecryptedMessageWithPubKey(networkEnvelope=" + String.valueOf(this.getNetworkEnvelope()) + ", signaturePubKeyBytes=" + Arrays.toString(this.getSignaturePubKeyBytes()) + ", signaturePubKey=" + String.valueOf(this.getSignaturePubKey()) + ")";
    }
}

