/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p;

import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import haveno.common.app.AppModule;
import haveno.common.config.Config;
import haveno.network.Socks5ProxyProvider;
import haveno.network.http.HttpClient;
import haveno.network.http.HttpClientImpl;
import haveno.network.p2p.NetworkNodeProvider;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.peers.Broadcaster;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.peers.getdata.RequestDataManager;
import haveno.network.p2p.peers.keepalive.KeepAliveManager;
import haveno.network.p2p.peers.peerexchange.PeerExchangeManager;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.persistence.AppendOnlyDataStoreService;
import haveno.network.p2p.storage.persistence.ProtectedDataStoreService;
import haveno.network.p2p.storage.persistence.ResourceDataStoreService;
import java.io.File;
import java.time.Clock;
import java.util.List;

public class P2PModule
extends AppModule {
    public P2PModule(Config config) {
        super(config);
    }

    @Override
    protected void configure() {
        this.bind(Clock.class).toInstance(Clock.systemDefaultZone());
        this.bind(P2PService.class).in(Singleton.class);
        this.bind(PeerManager.class).in(Singleton.class);
        this.bind(P2PDataStorage.class).in(Singleton.class);
        this.bind(AppendOnlyDataStoreService.class).in(Singleton.class);
        this.bind(ProtectedDataStoreService.class).in(Singleton.class);
        this.bind(ResourceDataStoreService.class).in(Singleton.class);
        this.bind(RequestDataManager.class).in(Singleton.class);
        this.bind(PeerExchangeManager.class).in(Singleton.class);
        this.bind(KeepAliveManager.class).in(Singleton.class);
        this.bind(Broadcaster.class).in(Singleton.class);
        this.bind(NetworkNode.class).toProvider(NetworkNodeProvider.class).in(Singleton.class);
        this.bind(Socks5ProxyProvider.class).in(Singleton.class);
        this.bind(HttpClient.class).to(HttpClientImpl.class);
        this.requestStaticInjection(Connection.class);
        this.bindConstant().annotatedWith(Names.named("useLocalhostForP2P")).to(this.config.useLocalhostForP2P);
        this.bind(File.class).annotatedWith(Names.named("torDir")).toInstance(this.config.torDir);
        this.bind(Integer.TYPE).annotatedWith(Names.named("nodePort")).toInstance(this.config.nodePort);
        this.bind(String.class).annotatedWith(Names.named("hiddenServiceAddress")).toInstance(this.config.hiddenServiceAddress);
        this.bindConstant().annotatedWith(Names.named("maxConnections")).to(this.config.maxConnections);
        this.bind(new TypeLiteral<List<String>>(){}).annotatedWith(Names.named("banList")).toInstance(this.config.banList);
        this.bindConstant().annotatedWith(Names.named("socks5ProxyXmrAddress")).to(this.config.socks5ProxyXmrAddress);
        this.bindConstant().annotatedWith(Names.named("socks5ProxyHttpAddress")).to(this.config.socks5ProxyHttpAddress);
        this.bind(File.class).annotatedWith(Names.named("torrcFile")).toProvider(Providers.of(this.config.torrcFile));
        this.bindConstant().annotatedWith(Names.named("torrcOptions")).to(this.config.torrcOptions);
        this.bindConstant().annotatedWith(Names.named("torControlHost")).to(this.config.torControlHost);
        this.bindConstant().annotatedWith(Names.named("torControlPort")).to(this.config.torControlPort);
        this.bindConstant().annotatedWith(Names.named("torControlPassword")).to(this.config.torControlPassword);
        this.bind(File.class).annotatedWith(Names.named("torControlCookieFile")).toProvider(Providers.of(this.config.torControlCookieFile));
        this.bindConstant().annotatedWith(Names.named("torControlUseSafeCookieAuth")).to(this.config.useTorControlSafeCookieAuth);
        this.bindConstant().annotatedWith(Names.named("torStreamIsolation")).to(this.config.torStreamIsolation);
        this.bindConstant().annotatedWith(Names.named("MAX_SEQUENCE_NUMBER_MAP_SIZE_BEFORE_PURGE")).to(1000);
        this.bind(Boolean.class).annotatedWith(Names.named("republishMailboxEntries")).toInstance(this.config.republishMailboxEntries);
    }
}

