/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import haveno.common.UserThread;
import haveno.common.app.Capabilities;
import haveno.common.crypto.CryptoException;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.PubKeyRing;
import haveno.common.proto.ProtobufferException;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.network.Socks5ProxyProvider;
import haveno.network.crypto.EncryptionService;
import haveno.network.p2p.DecryptedDirectMessageListener;
import haveno.network.p2p.DecryptedMessageWithPubKey;
import haveno.network.p2p.NetworkNotReadyException;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PServiceListener;
import haveno.network.p2p.PrefixedSealedAndSignedMessage;
import haveno.network.p2p.SendDirectMessageListener;
import haveno.network.p2p.mailbox.MailboxMessageService;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.ConnectionListener;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.network.SetupListener;
import haveno.network.p2p.peers.Broadcaster;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.peers.getdata.RequestDataManager;
import haveno.network.p2p.peers.keepalive.KeepAliveManager;
import haveno.network.p2p.peers.peerexchange.PeerExchangeManager;
import haveno.network.p2p.storage.HashMapChangedListener;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.messages.RefreshOfferMessage;
import haveno.network.p2p.storage.payload.PersistableNetworkPayload;
import haveno.network.p2p.storage.payload.ProtectedStorageEntry;
import haveno.network.p2p.storage.payload.ProtectedStoragePayload;
import haveno.network.utils.CapabilityUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P2PService
implements SetupListener,
MessageListener,
ConnectionListener,
RequestDataManager.Listener {
    private static final Logger log = LoggerFactory.getLogger(P2PService.class);
    private final EncryptionService encryptionService;
    private final KeyRing keyRing;
    private final MailboxMessageService mailboxMessageService;
    private final NetworkNode networkNode;
    private final PeerManager peerManager;
    private final Broadcaster broadcaster;
    private final P2PDataStorage p2PDataStorage;
    private final RequestDataManager requestDataManager;
    private final PeerExchangeManager peerExchangeManager;
    private final MonadicBinding<Boolean> networkReadyBinding;
    private final Set<DecryptedDirectMessageListener> decryptedDirectMessageListeners = new CopyOnWriteArraySet<DecryptedDirectMessageListener>();
    private final Set<P2PServiceListener> p2pServiceListeners = new CopyOnWriteArraySet<P2PServiceListener>();
    private final Set<Runnable> shutDownResultHandlers = new CopyOnWriteArraySet<Runnable>();
    private final BooleanProperty hiddenServicePublished = new SimpleBooleanProperty();
    private final BooleanProperty preliminaryDataReceived = new SimpleBooleanProperty();
    private final IntegerProperty numConnectedPeers = new SimpleIntegerProperty(0);
    private final Subscription networkReadySubscription;
    private boolean isBootstrapped;
    private final KeepAliveManager keepAliveManager;
    private final Socks5ProxyProvider socks5ProxyProvider;
    private static NodeAddress myNodeAddress;
    private boolean isShutDownStarted = false;

    @Inject
    public P2PService(NetworkNode networkNode, PeerManager peerManager, P2PDataStorage p2PDataStorage, RequestDataManager requestDataManager, PeerExchangeManager peerExchangeManager, KeepAliveManager keepAliveManager, Broadcaster broadcaster, Socks5ProxyProvider socks5ProxyProvider, EncryptionService encryptionService, KeyRing keyRing, MailboxMessageService mailboxMessageService) {
        this.networkNode = networkNode;
        this.peerManager = peerManager;
        this.p2PDataStorage = p2PDataStorage;
        this.requestDataManager = requestDataManager;
        this.peerExchangeManager = peerExchangeManager;
        this.keepAliveManager = keepAliveManager;
        this.broadcaster = broadcaster;
        this.socks5ProxyProvider = socks5ProxyProvider;
        this.encryptionService = encryptionService;
        this.keyRing = keyRing;
        this.mailboxMessageService = mailboxMessageService;
        this.networkNode.addConnectionListener(this);
        this.networkNode.addMessageListener(this);
        this.requestDataManager.setListener(this);
        this.networkReadyBinding = EasyBind.combine(this.hiddenServicePublished, this.preliminaryDataReceived, (hiddenServicePublished, preliminaryDataReceived) -> hiddenServicePublished != false && preliminaryDataReceived != false);
        this.networkReadySubscription = this.networkReadyBinding.subscribe((observable2, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.onNetworkReady();
            }
        });
    }

    public void start(@Nullable P2PServiceListener listener) {
        if (listener != null) {
            this.addP2PServiceListener(listener);
        }
        this.networkNode.start(this);
    }

    public void onAllServicesInitialized() {
        if (this.networkNode.getNodeAddress() != null) {
            myNodeAddress = this.networkNode.getNodeAddress();
        } else {
            this.networkNode.nodeAddressProperty().addListener((observable2, oldValue, newValue) -> {
                if (newValue != null) {
                    myNodeAddress = this.networkNode.getNodeAddress();
                }
            });
        }
    }

    public void shutDown(Runnable shutDownCompleteHandler) {
        log.info("P2PService shutdown started");
        this.shutDownResultHandlers.add(shutDownCompleteHandler);
        if (this.broadcaster != null) {
            this.broadcaster.shutDown(this::doShutDown);
        } else {
            this.doShutDown();
        }
    }

    private void doShutDown() {
        log.info("P2PService doShutDown started");
        this.isShutDownStarted = true;
        if (this.p2PDataStorage != null) {
            this.p2PDataStorage.shutDown();
        }
        if (this.peerManager != null) {
            this.peerManager.shutDown();
        }
        if (this.requestDataManager != null) {
            this.requestDataManager.shutDown();
        }
        if (this.peerExchangeManager != null) {
            this.peerExchangeManager.shutDown();
        }
        if (this.keepAliveManager != null) {
            this.keepAliveManager.shutDown();
        }
        if (this.networkReadySubscription != null) {
            this.networkReadySubscription.unsubscribe();
        }
        if (this.networkNode != null) {
            this.networkNode.shutDown(() -> this.shutDownResultHandlers.forEach(Runnable::run));
        } else {
            this.shutDownResultHandlers.forEach(Runnable::run);
        }
    }

    @Override
    public void onTorNodeReady() {
        this.socks5ProxyProvider.setSocks5ProxyInternal(this.networkNode);
        this.requestDataManager.requestPreliminaryData();
        this.keepAliveManager.start();
        this.p2pServiceListeners.forEach(SetupListener::onTorNodeReady);
    }

    @Override
    public void onHiddenServicePublished() {
        Preconditions.checkArgument(this.networkNode.getNodeAddress() != null, "Address must be set when we have the hidden service ready");
        this.hiddenServicePublished.set(true);
        this.p2pServiceListeners.forEach(SetupListener::onHiddenServicePublished);
    }

    @Override
    public void onSetupFailed(Throwable throwable) {
        this.p2pServiceListeners.forEach(e -> e.onSetupFailed(throwable));
    }

    @Override
    public void onRequestCustomBridges() {
        this.p2pServiceListeners.forEach(SetupListener::onRequestCustomBridges);
    }

    private void onNetworkReady() {
        this.networkReadySubscription.unsubscribe();
        Optional<NodeAddress> seedNodeOfPreliminaryDataRequest = this.requestDataManager.getNodeAddressOfPreliminaryDataRequest();
        Preconditions.checkArgument(seedNodeOfPreliminaryDataRequest.isPresent(), "seedNodeOfPreliminaryDataRequest must be present");
        this.requestDataManager.requestUpdateData();
        UserThread.runAfter(() -> this.peerExchangeManager.requestReportedPeersFromSeedNodes((NodeAddress)seedNodeOfPreliminaryDataRequest.get()), 100L, TimeUnit.MILLISECONDS);
        UserThread.runAfter(this.peerExchangeManager::initialRequestPeersFromReportedOrPersistedPeers, 300L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onPreliminaryDataReceived() {
        Preconditions.checkArgument(!this.preliminaryDataReceived.get(), "preliminaryDataReceived was already set before.");
        this.preliminaryDataReceived.set(true);
    }

    @Override
    public void onUpdatedDataReceived() {
        this.p2pServiceListeners.forEach(P2PServiceListener::onUpdatedDataReceived);
    }

    @Override
    public void onNoSeedNodeAvailable() {
        this.applyIsBootstrapped(P2PServiceListener::onNoSeedNodeAvailable);
    }

    @Override
    public void onNoPeersAvailable() {
        this.p2pServiceListeners.forEach(P2PServiceListener::onNoPeersAvailable);
    }

    @Override
    public void onDataReceived() {
        this.applyIsBootstrapped(P2PServiceListener::onDataReceived);
    }

    private void applyIsBootstrapped(Consumer<P2PServiceListener> listenerHandler) {
        if (!this.isBootstrapped) {
            this.isBootstrapped = true;
            this.p2PDataStorage.onBootstrapped();
            this.mailboxMessageService.onBootstrapped();
            this.p2pServiceListeners.forEach(listenerHandler);
            this.mailboxMessageService.initAfterBootstrapped();
        }
    }

    @Override
    public void onConnection(Connection connection) {
        this.numConnectedPeers.set(this.networkNode.getAllConnections().size());
        UserThread.runAfter(() -> this.numConnectedPeers.set(this.networkNode.getAllConnections().size()), 3L);
    }

    @Override
    public void onDisconnect(CloseConnectionReason closeConnectionReason, Connection connection) {
        this.numConnectedPeers.set(this.networkNode.getAllConnections().size());
        UserThread.runAfter(() -> this.numConnectedPeers.set(this.networkNode.getAllConnections().size()), 3L);
    }

    @Override
    public void onMessage(NetworkEnvelope networkEnvelope, Connection connection) {
        if (networkEnvelope instanceof PrefixedSealedAndSignedMessage) {
            PrefixedSealedAndSignedMessage sealedMsg = (PrefixedSealedAndSignedMessage)networkEnvelope;
            try {
                DecryptedMessageWithPubKey decryptedMsg = this.encryptionService.decryptAndVerify(sealedMsg.getSealedAndSigned());
                connection.maybeHandleSupportedCapabilitiesMessage(decryptedMsg.getNetworkEnvelope());
                connection.getPeersNodeAddressOptional().ifPresentOrElse(nodeAddress -> this.decryptedDirectMessageListeners.forEach(e -> e.onDirectMessage(decryptedMsg, (NodeAddress)nodeAddress)), () -> log.error("peersNodeAddress is expected to be available at onMessage for processing PrefixedSealedAndSignedMessage."));
            }
            catch (CryptoException e) {
                log.warn("Decryption of a direct message failed. This is not expected as the direct message was sent to our node.");
            }
            catch (ProtobufferException e) {
                log.error("ProtobufferException at decryptAndVerify: {}", (Object)e.toString());
                e.getStackTrace();
            }
        }
    }

    public void sendEncryptedDirectMessage(NodeAddress peerNodeAddress, PubKeyRing pubKeyRing, NetworkEnvelope message, SendDirectMessageListener sendDirectMessageListener) {
        this.sendEncryptedDirectMessage(peerNodeAddress, pubKeyRing, message, sendDirectMessageListener, null);
    }

    public void sendEncryptedDirectMessage(NodeAddress peerNodeAddress, PubKeyRing pubKeyRing, NetworkEnvelope message, SendDirectMessageListener sendDirectMessageListener, Integer timeoutSeconds) {
        Preconditions.checkNotNull(peerNodeAddress, "PeerAddress must not be null (sendEncryptedDirectMessage)");
        if (!this.isBootstrapped()) {
            throw new NetworkNotReadyException();
        }
        this.doSendEncryptedDirectMessage(peerNodeAddress, pubKeyRing, message, sendDirectMessageListener, timeoutSeconds);
    }

    private void doSendEncryptedDirectMessage(@NotNull NodeAddress peersNodeAddress, PubKeyRing pubKeyRing, NetworkEnvelope message, final SendDirectMessageListener sendDirectMessageListener, Integer timeoutSeconds) {
        log.debug("Send encrypted direct message {} to peer {}", (Object)message.getClass().getSimpleName(), (Object)peersNodeAddress);
        Preconditions.checkNotNull(peersNodeAddress, "Peer node address must not be null at doSendEncryptedDirectMessage");
        Preconditions.checkNotNull(this.networkNode.getNodeAddress(), "My node address must not be null at doSendEncryptedDirectMessage");
        if (CapabilityUtils.capabilityRequiredAndCapabilityNotSupported(peersNodeAddress, message, this.peerManager)) {
            sendDirectMessageListener.onFault("We did not send the EncryptedMessage because the peer does not support the capability.");
            return;
        }
        try {
            PrefixedSealedAndSignedMessage sealedMsg = new PrefixedSealedAndSignedMessage(this.networkNode.getNodeAddress(), this.encryptionService.encryptAndSign(pubKeyRing, message));
            SettableFuture<Connection> future = this.networkNode.sendMessage(peersNodeAddress, (NetworkEnvelope)sealedMsg, timeoutSeconds);
            Futures.addCallback(future, new FutureCallback<Connection>(){

                @Override
                public void onSuccess(@Nullable Connection connection) {
                    sendDirectMessageListener.onArrived();
                }

                @Override
                public void onFailure(@NotNull Throwable throwable) {
                    log.error(ExceptionUtils.getStackTrace(throwable));
                    sendDirectMessageListener.onFault(throwable.toString());
                }
            }, MoreExecutors.directExecutor());
        }
        catch (CryptoException e) {
            log.error("Error sending encrypted direct message, message={}, error={}\n", message.toString(), e.getMessage(), e);
            sendDirectMessageListener.onFault(e.toString());
        }
    }

    public boolean addPersistableNetworkPayload(PersistableNetworkPayload payload, boolean reBroadcast) {
        return this.p2PDataStorage.addPersistableNetworkPayload(payload, this.networkNode.getNodeAddress(), reBroadcast);
    }

    public boolean addProtectedStorageEntry(ProtectedStoragePayload protectedStoragePayload) {
        if (this.isBootstrapped()) {
            try {
                ProtectedStorageEntry protectedStorageEntry = this.p2PDataStorage.getProtectedStorageEntry(protectedStoragePayload, this.keyRing.getSignatureKeyPair());
                return this.p2PDataStorage.addProtectedStorageEntry(protectedStorageEntry, this.networkNode.getNodeAddress(), null);
            }
            catch (CryptoException e) {
                log.error("Signing at getDataWithSignedSeqNr failed. That should never happen.");
                return false;
            }
        }
        throw new NetworkNotReadyException();
    }

    public boolean refreshTTL(ProtectedStoragePayload protectedStoragePayload) {
        if (this.isBootstrapped()) {
            try {
                RefreshOfferMessage refreshTTLMessage = this.p2PDataStorage.getRefreshTTLMessage(protectedStoragePayload, this.keyRing.getSignatureKeyPair());
                return this.p2PDataStorage.refreshTTL(refreshTTLMessage, this.networkNode.getNodeAddress());
            }
            catch (CryptoException e) {
                log.error("Signing at getDataWithSignedSeqNr failed. That should never happen.");
                return false;
            }
        }
        throw new NetworkNotReadyException();
    }

    public boolean removeData(ProtectedStoragePayload protectedStoragePayload) {
        if (this.isBootstrapped()) {
            try {
                ProtectedStorageEntry protectedStorageEntry = this.p2PDataStorage.getProtectedStorageEntry(protectedStoragePayload, this.keyRing.getSignatureKeyPair());
                return this.p2PDataStorage.remove(protectedStorageEntry, this.networkNode.getNodeAddress());
            }
            catch (CryptoException e) {
                log.error("Signing at getDataWithSignedSeqNr failed. That should never happen.");
                return false;
            }
        }
        throw new NetworkNotReadyException();
    }

    public void addDecryptedDirectMessageListener(DecryptedDirectMessageListener listener) {
        this.decryptedDirectMessageListeners.add(listener);
    }

    public void removeDecryptedDirectMessageListener(DecryptedDirectMessageListener listener) {
        this.decryptedDirectMessageListeners.remove(listener);
    }

    public void addP2PServiceListener(P2PServiceListener listener) {
        this.p2pServiceListeners.add(listener);
    }

    public void removeP2PServiceListener(P2PServiceListener listener) {
        this.p2pServiceListeners.remove(listener);
    }

    public void addHashSetChangedListener(HashMapChangedListener hashMapChangedListener) {
        this.p2PDataStorage.addHashMapChangedListener(hashMapChangedListener);
    }

    public void removeHashMapChangedListener(HashMapChangedListener hashMapChangedListener) {
        this.p2PDataStorage.removeHashMapChangedListener(hashMapChangedListener);
    }

    public boolean isBootstrapped() {
        return this.isBootstrapped;
    }

    public NetworkNode getNetworkNode() {
        return this.networkNode;
    }

    @Nullable
    public NodeAddress getAddress() {
        return this.networkNode.getNodeAddress();
    }

    public ReadOnlyIntegerProperty getNumConnectedPeers() {
        return this.numConnectedPeers;
    }

    public Map<P2PDataStorage.ByteArray, ProtectedStorageEntry> getDataMap() {
        return this.p2PDataStorage.getMap();
    }

    @VisibleForTesting
    public P2PDataStorage getP2PDataStorage() {
        return this.p2PDataStorage;
    }

    @VisibleForTesting
    public PeerManager getPeerManager() {
        return this.peerManager;
    }

    @VisibleForTesting
    public KeyRing getKeyRing() {
        return this.keyRing;
    }

    public Optional<Capabilities> findPeersCapabilities(NodeAddress peer) {
        return this.networkNode.getConfirmedConnections().stream().filter(e -> e.getPeersNodeAddressOptional().isPresent()).filter(e -> e.getPeersNodeAddressOptional().get().equals(peer)).map(Connection::getCapabilities).findAny();
    }

    public MailboxMessageService getMailboxMessageService() {
        return this.mailboxMessageService;
    }

    public Broadcaster getBroadcaster() {
        return this.broadcaster;
    }

    public static NodeAddress getMyNodeAddress() {
        return myNodeAddress;
    }

    public boolean isShutDownStarted() {
        return this.isShutDownStarted;
    }
}

