/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import haveno.common.app.Version;
import haveno.common.crypto.SealedAndSigned;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.SendersNodeAddressMessage;
import haveno.network.p2p.mailbox.MailboxMessage;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import protobuf.NetworkEnvelope;

public final class PrefixedSealedAndSignedMessage
extends haveno.common.proto.network.NetworkEnvelope
implements MailboxMessage,
SendersNodeAddressMessage {
    public static final long TTL = TimeUnit.DAYS.toMillis(15L);
    private final NodeAddress senderNodeAddress;
    private final SealedAndSigned sealedAndSigned;
    private final byte[] addressPrefixHash;
    private final String uid;

    public PrefixedSealedAndSignedMessage(NodeAddress senderNodeAddress, SealedAndSigned sealedAndSigned) {
        this(senderNodeAddress, sealedAndSigned, new byte[0], UUID.randomUUID().toString(), Version.getP2PMessageVersion());
    }

    private PrefixedSealedAndSignedMessage(NodeAddress senderNodeAddress, SealedAndSigned sealedAndSigned, byte[] addressPrefixHash, String uid, String messageVersion) {
        super(messageVersion);
        this.senderNodeAddress = Preconditions.checkNotNull(senderNodeAddress, "senderNodeAddress must not be null");
        this.sealedAndSigned = sealedAndSigned;
        this.addressPrefixHash = addressPrefixHash;
        this.uid = uid;
    }

    @Override
    public NetworkEnvelope toProtoNetworkEnvelope() {
        return this.getNetworkEnvelopeBuilder().setPrefixedSealedAndSignedMessage(protobuf.PrefixedSealedAndSignedMessage.newBuilder().setNodeAddress(this.senderNodeAddress.toProtoMessage()).setSealedAndSigned(this.sealedAndSigned.toProtoMessage()).setAddressPrefixHash(ByteString.copyFrom(this.addressPrefixHash)).setUid(this.uid)).build();
    }

    public static PrefixedSealedAndSignedMessage fromProto(protobuf.PrefixedSealedAndSignedMessage proto, String messageVersion) {
        return new PrefixedSealedAndSignedMessage(NodeAddress.fromProto(proto.getNodeAddress()), SealedAndSigned.fromProto(proto.getSealedAndSigned()), proto.getAddressPrefixHash().toByteArray(), proto.getUid(), messageVersion);
    }

    public static PrefixedSealedAndSignedMessage fromPayloadProto(protobuf.PrefixedSealedAndSignedMessage proto) {
        return new PrefixedSealedAndSignedMessage(NodeAddress.fromProto(proto.getNodeAddress()), SealedAndSigned.fromProto(proto.getSealedAndSigned()), proto.getAddressPrefixHash().toByteArray(), proto.getUid(), "-1");
    }

    @Override
    public long getTTL() {
        return TTL;
    }

    @Override
    public NodeAddress getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    public SealedAndSigned getSealedAndSigned() {
        return this.sealedAndSigned;
    }

    public byte[] getAddressPrefixHash() {
        return this.addressPrefixHash;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String toString() {
        return "PrefixedSealedAndSignedMessage(senderNodeAddress=" + String.valueOf(this.getSenderNodeAddress()) + ", sealedAndSigned=" + String.valueOf(this.getSealedAndSigned()) + ", addressPrefixHash=" + Arrays.toString(this.getAddressPrefixHash()) + ", uid=" + this.getUid() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrefixedSealedAndSignedMessage)) {
            return false;
        }
        PrefixedSealedAndSignedMessage other = (PrefixedSealedAndSignedMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeAddress this$senderNodeAddress = this.getSenderNodeAddress();
        NodeAddress other$senderNodeAddress = other.getSenderNodeAddress();
        if (this$senderNodeAddress == null ? other$senderNodeAddress != null : !((Object)this$senderNodeAddress).equals(other$senderNodeAddress)) {
            return false;
        }
        SealedAndSigned this$sealedAndSigned = this.getSealedAndSigned();
        SealedAndSigned other$sealedAndSigned = other.getSealedAndSigned();
        if (this$sealedAndSigned == null ? other$sealedAndSigned != null : !((Object)this$sealedAndSigned).equals(other$sealedAndSigned)) {
            return false;
        }
        if (!Arrays.equals(this.getAddressPrefixHash(), other.getAddressPrefixHash())) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        return !(this$uid == null ? other$uid != null : !this$uid.equals(other$uid));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PrefixedSealedAndSignedMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        NodeAddress $senderNodeAddress = this.getSenderNodeAddress();
        result = result * 59 + ($senderNodeAddress == null ? 43 : ((Object)$senderNodeAddress).hashCode());
        SealedAndSigned $sealedAndSigned = this.getSealedAndSigned();
        result = result * 59 + ($sealedAndSigned == null ? 43 : ((Object)$sealedAndSigned).hashCode());
        result = result * 59 + Arrays.hashCode(this.getAddressPrefixHash());
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        return result;
    }
}

