/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.network;

import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.network.p2p.BundleOfEnvelopes;
import haveno.network.p2p.InitialDataRequest;
import haveno.network.p2p.InitialDataResponse;
import haveno.network.p2p.PrefixedSealedAndSignedMessage;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.PeerType;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionState
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(ConnectionState.class);
    private static final long PEER_RESET_TIMER_DELAY_SEC = TimeUnit.MINUTES.toSeconds(4L);
    private static final long COMPLETED_TIMER_DELAY_SEC = 10L;
    private static int expectedRequests = 6;
    private static final int MIN_EXPECTED_RESPONSES = 5;
    private static int expectedInitialDataResponses = 5;
    private final Connection connection;
    private PeerType peerType = PeerType.PEER;
    private int numInitialDataRequests = 0;
    private int numInitialDataResponses = 0;
    private long lastInitialDataMsgTimeStamp;
    private boolean isSeedNode;
    private Timer peerTypeResetDueTimeoutTimer;
    private Timer initialDataExchangeCompletedTimer;

    public static void incrementExpectedInitialDataResponses() {
        ++expectedInitialDataResponses;
    }

    public ConnectionState(Connection connection) {
        this.connection = connection;
        connection.addMessageListener(this);
    }

    public void shutDown() {
        this.connection.removeMessageListener(this);
        this.stopTimer();
    }

    @Override
    public void onMessage(NetworkEnvelope networkEnvelope, Connection connection) {
        if (networkEnvelope instanceof BundleOfEnvelopes) {
            ((BundleOfEnvelopes)networkEnvelope).getEnvelopes().forEach(this::onMessageSentOrReceived);
        } else {
            this.onMessageSentOrReceived(networkEnvelope);
        }
    }

    @Override
    public void onMessageSent(NetworkEnvelope networkEnvelope, Connection connection) {
        if (networkEnvelope instanceof BundleOfEnvelopes) {
            ((BundleOfEnvelopes)networkEnvelope).getEnvelopes().forEach(this::onMessageSentOrReceived);
        } else {
            this.onMessageSentOrReceived(networkEnvelope);
        }
    }

    private void onMessageSentOrReceived(NetworkEnvelope networkEnvelope) {
        if (networkEnvelope instanceof InitialDataRequest) {
            ++this.numInitialDataRequests;
            this.onInitialDataExchange();
        } else if (networkEnvelope instanceof InitialDataResponse) {
            ++this.numInitialDataResponses;
            this.onInitialDataExchange();
        } else if (networkEnvelope instanceof PrefixedSealedAndSignedMessage && this.connection.getPeersNodeAddressOptional().isPresent()) {
            this.peerType = PeerType.DIRECT_MSG_PEER;
        }
    }

    private void onInitialDataExchange() {
        if (this.peerType == PeerType.DIRECT_MSG_PEER) {
            this.stopTimer();
            return;
        }
        this.peerType = PeerType.INITIAL_DATA_EXCHANGE;
        this.lastInitialDataMsgTimeStamp = System.currentTimeMillis();
        this.maybeResetInitialDataExchangeType();
        if (this.peerTypeResetDueTimeoutTimer == null) {
            this.peerTypeResetDueTimeoutTimer = UserThread.runAfter(this::resetInitialDataExchangeType, PEER_RESET_TIMER_DELAY_SEC);
        }
    }

    private void maybeResetInitialDataExchangeType() {
        if (this.numInitialDataResponses >= expectedInitialDataResponses && this.initialDataExchangeCompletedTimer == null) {
            this.initialDataExchangeCompletedTimer = UserThread.runAfter(this::resetInitialDataExchangeType, 10L);
        }
    }

    private void resetInitialDataExchangeType() {
        if (this.peerType == PeerType.DIRECT_MSG_PEER) {
            this.stopTimer();
            return;
        }
        this.stopTimer();
        this.peerType = PeerType.PEER;
        log.info("We have changed the peerType from INITIAL_DATA_EXCHANGE to PEER as we have received all expected initial data responses at connection with peer {}/{}.", (Object)this.connection.getPeersNodeAddressOptional(), (Object)this.connection.getUid());
    }

    private void stopTimer() {
        if (this.peerTypeResetDueTimeoutTimer != null) {
            this.peerTypeResetDueTimeoutTimer.stop();
            this.peerTypeResetDueTimeoutTimer = null;
        }
        if (this.initialDataExchangeCompletedTimer != null) {
            this.initialDataExchangeCompletedTimer.stop();
            this.initialDataExchangeCompletedTimer = null;
        }
    }

    public String toString() {
        return "ConnectionState{,\n     peerType=" + String.valueOf((Object)this.peerType) + ",\n     numInitialDataRequests=" + this.numInitialDataRequests + ",\n     numInitialDataResponses=" + this.numInitialDataResponses + ",\n     lastInitialDataMsgTimeStamp=" + this.lastInitialDataMsgTimeStamp + ",\n     isSeedNode=" + this.isSeedNode + ",\n     expectedInitialDataResponses=" + expectedInitialDataResponses + "\n}";
    }

    public static void setExpectedRequests(int expectedRequests) {
        ConnectionState.expectedRequests = expectedRequests;
    }

    public PeerType getPeerType() {
        return this.peerType;
    }

    public int getNumInitialDataRequests() {
        return this.numInitialDataRequests;
    }

    public int getNumInitialDataResponses() {
        return this.numInitialDataResponses;
    }

    public long getLastInitialDataMsgTimeStamp() {
        return this.lastInitialDataMsgTimeStamp;
    }

    public void setSeedNode(boolean isSeedNode) {
        this.isSeedNode = isSeedNode;
    }

    public boolean isSeedNode() {
        return this.isSeedNode;
    }
}

