/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.network;

import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.util.Utilities;
import haveno.network.p2p.BundleOfEnvelopes;
import haveno.network.p2p.InitialDataRequest;
import haveno.network.p2p.InitialDataResponse;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.ConnectionState;
import haveno.network.p2p.network.InboundConnection;
import haveno.network.p2p.network.MessageListener;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionStatistics
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(ConnectionStatistics.class);
    private final Connection connection;
    private final ConnectionState connectionState;
    private final Map<String, Integer> sentDataMap = new HashMap<String, Integer>();
    private final Map<String, Integer> receivedDataMap = new HashMap<String, Integer>();
    private final Map<String, Long> rrtMap = new HashMap<String, Long>();
    private final long connectionCreationTimeStamp;
    private long lastMessageTimestamp;
    private long timeOnSendMsg = 0L;
    private long timeOnReceivedMsg = 0L;
    private int sentBytes = 0;
    private int receivedBytes = 0;

    public ConnectionStatistics(Connection connection, ConnectionState connectionState) {
        this.connection = connection;
        this.connectionState = connectionState;
        connection.addMessageListener(this);
        this.connectionCreationTimeStamp = System.currentTimeMillis();
    }

    public void shutDown() {
        this.connection.removeMessageListener(this);
    }

    public String getInfo() {
        String ls = System.lineSeparator();
        long now = System.currentTimeMillis();
        String conInstance = this.connection instanceof InboundConnection ? "Inbound" : "Outbound";
        String age = Utilities.formatDurationAsWords(now - this.connectionCreationTimeStamp);
        String lastMsg = Utilities.formatDurationAsWords(now - this.lastMessageTimestamp);
        String peer = this.connection.getPeersNodeAddressOptional().map(NodeAddress::getFullAddress).orElse("[address not known yet]");
        Object rrt = this.rrtMap.entrySet().stream().map(e -> {
            long value = (Long)e.getValue();
            if (value < this.connectionCreationTimeStamp) {
                String key = ((String)e.getKey()).replace("Request", "Request/Response");
                return key + ": " + Utilities.formatDurationAsWords(value);
            }
            return (String)e.getKey() + " awaiting response... ";
        }).collect(Collectors.toList()).toString();
        rrt = ((String)rrt).equals("[]") ? "" : "Time for response: " + (String)rrt + ls;
        boolean seedNode = this.connectionState.isSeedNode();
        return String.format("Age: %s" + ls + "Peer: %s%s " + ls + "Type: %s " + ls + "Direction: %s" + ls + "UID: %s" + ls + "Time since last message: %s" + ls + "%sSent data: %s; %s" + ls + "Received data: %s; %s" + ls + "CPU time spent on sending messages: %s" + ls + "CPU time spent on receiving messages: %s", age, seedNode ? "[Seed node] " : "", peer, this.connectionState.getPeerType().name(), conInstance, this.connection.getUid(), lastMsg, rrt, Utilities.readableFileSize(this.sentBytes), this.sentDataMap.toString(), Utilities.readableFileSize(this.receivedBytes), this.receivedDataMap.toString(), Utilities.formatDurationAsWords(this.timeOnSendMsg), Utilities.formatDurationAsWords(this.timeOnReceivedMsg));
    }

    @Override
    public void onMessage(NetworkEnvelope networkEnvelope, Connection connection) {
        this.lastMessageTimestamp = System.currentTimeMillis();
        if (networkEnvelope instanceof BundleOfEnvelopes) {
            ((BundleOfEnvelopes)networkEnvelope).getEnvelopes().forEach(e -> this.addToMap((NetworkEnvelope)e, this.receivedDataMap));
            this.addToMap(networkEnvelope, this.receivedDataMap);
        } else {
            this.addToMap(networkEnvelope, this.receivedDataMap);
        }
    }

    @Override
    public void onMessageSent(NetworkEnvelope networkEnvelope, Connection connection) {
        this.lastMessageTimestamp = System.currentTimeMillis();
        if (networkEnvelope instanceof BundleOfEnvelopes) {
            ((BundleOfEnvelopes)networkEnvelope).getEnvelopes().forEach(e -> this.addToMap((NetworkEnvelope)e, this.sentDataMap));
            this.addToMap(networkEnvelope, this.sentDataMap);
        } else {
            this.addToMap(networkEnvelope, this.sentDataMap);
        }
    }

    private void addToMap(NetworkEnvelope networkEnvelope, Map<String, Integer> map) {
        String associatedRequest;
        String key = networkEnvelope.getClass().getSimpleName();
        map.putIfAbsent(key, 0);
        map.put(key, map.get(key) + 1);
        if (networkEnvelope instanceof InitialDataRequest) {
            this.rrtMap.putIfAbsent(key, System.currentTimeMillis());
        } else if (networkEnvelope instanceof InitialDataResponse && this.rrtMap.containsKey(associatedRequest = ((InitialDataResponse)((Object)networkEnvelope)).associatedRequest().getSimpleName())) {
            this.rrtMap.put(associatedRequest, System.currentTimeMillis() - this.rrtMap.get(associatedRequest));
        }
    }

    public void addSendMsgMetrics(long timeSpent, int bytes) {
        this.timeOnSendMsg += timeSpent;
        this.sentBytes += bytes;
    }

    public void addReceivedMsgMetrics(long timeSpent, int bytes) {
        this.timeOnReceivedMsg += timeSpent;
        this.receivedBytes += bytes;
    }

    public long getConnectionCreationTimeStamp() {
        return this.connectionCreationTimeStamp;
    }

    public long getLastMessageTimestamp() {
        return this.lastMessageTimestamp;
    }

    public long getTimeOnSendMsg() {
        return this.timeOnSendMsg;
    }

    public long getTimeOnReceivedMsg() {
        return this.timeOnReceivedMsg;
    }

    public int getSentBytes() {
        return this.sentBytes;
    }

    public int getReceivedBytes() {
        return this.receivedBytes;
    }
}

