/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.network;

import haveno.common.UserThread;
import haveno.common.proto.network.NetworkProtoResolver;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.BanFilter;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.network.SetupListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalhostNetworkNode
extends NetworkNode {
    private static final Logger log = LoggerFactory.getLogger(LocalhostNetworkNode.class);
    private static int simulateTorDelayTorNode = 500;
    private static int simulateTorDelayHiddenService = 500;

    public static void setSimulateTorDelayTorNode(int simulateTorDelayTorNode) {
        LocalhostNetworkNode.simulateTorDelayTorNode = simulateTorDelayTorNode;
    }

    public static void setSimulateTorDelayHiddenService(int simulateTorDelayHiddenService) {
        LocalhostNetworkNode.simulateTorDelayHiddenService = simulateTorDelayHiddenService;
    }

    public LocalhostNetworkNode(int port, NetworkProtoResolver networkProtoResolver, @Nullable BanFilter banFilter, int maxConnections) {
        super(port, networkProtoResolver, banFilter, maxConnections);
    }

    @Override
    public void start(@Nullable SetupListener setupListener) {
        if (setupListener != null) {
            this.addSetupListener(setupListener);
        }
        UserThread.runAfter(() -> {
            this.nodeAddressProperty.set(new NodeAddress("localhost", this.servicePort));
            this.setupListeners.stream().forEach(SetupListener::onTorNodeReady);
            UserThread.runAfter(() -> {
                try {
                    this.startServer(new ServerSocket(this.servicePort));
                }
                catch (IOException e) {
                    log.error("Exception at startServer: {}\n", (Object)e.getMessage(), (Object)e);
                }
                this.setupListeners.stream().forEach(SetupListener::onHiddenServicePublished);
            }, simulateTorDelayTorNode, TimeUnit.MILLISECONDS);
        }, simulateTorDelayHiddenService, TimeUnit.MILLISECONDS);
    }

    @Override
    protected Socket createSocket(NodeAddress peerNodeAddress) throws IOException {
        return new Socket(peerNodeAddress.getHostName(), peerNodeAddress.getPort());
    }
}

