/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.network;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.app.Capabilities;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.proto.network.NetworkProtoResolver;
import haveno.common.util.Utilities;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.BanFilter;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.ConnectionListener;
import haveno.network.p2p.network.InboundConnection;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.OutboundConnection;
import haveno.network.p2p.network.Server;
import haveno.network.p2p.network.SetupListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetworkNode
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(NetworkNode.class);
    private static final int CREATE_SOCKET_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(120L);
    final int servicePort;
    private final NetworkProtoResolver networkProtoResolver;
    @Nullable
    private final BanFilter banFilter;
    private final CopyOnWriteArraySet<InboundConnection> inBoundConnections = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<MessageListener> messageListeners = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<ConnectionListener> connectionListeners = new CopyOnWriteArraySet();
    final CopyOnWriteArraySet<SetupListener> setupListeners = new CopyOnWriteArraySet();
    private final ListeningExecutorService connectionExecutor;
    private final ListeningExecutorService sendMessageExecutor;
    private Server server;
    private volatile boolean isShutDownStarted;
    private final CopyOnWriteArraySet<OutboundConnection> outBoundConnections = new CopyOnWriteArraySet();
    protected final ObjectProperty<NodeAddress> nodeAddressProperty = new SimpleObjectProperty<NodeAddress>();

    NetworkNode(int servicePort, NetworkProtoResolver networkProtoResolver, @Nullable BanFilter banFilter, int maxConnections) {
        this.servicePort = servicePort;
        this.networkProtoResolver = networkProtoResolver;
        this.banFilter = banFilter;
        this.connectionExecutor = Utilities.getListeningExecutorService("NetworkNode.connection", maxConnections * 2, maxConnections * 3, 30, 30L);
        this.sendMessageExecutor = Utilities.getListeningExecutorService("NetworkNode.sendMessage", maxConnections * 2, maxConnections * 3, 30, 30L);
    }

    public abstract void start(@Nullable SetupListener var1);

    public SettableFuture<Connection> sendMessage(@NotNull NodeAddress peersNodeAddress, NetworkEnvelope networkEnvelope) {
        return this.sendMessage(peersNodeAddress, networkEnvelope, null);
    }

    public SettableFuture<Connection> sendMessage(@NotNull NodeAddress peersNodeAddress, NetworkEnvelope networkEnvelope, Integer timeoutSeconds) {
        log.debug("Send {} to {}. Message details: {}", networkEnvelope.getClass().getSimpleName(), peersNodeAddress, Utilities.toTruncatedString(networkEnvelope));
        Preconditions.checkNotNull(peersNodeAddress, "peerAddress must not be null");
        Connection connection = this.getOutboundConnection(peersNodeAddress);
        if (connection == null) {
            connection = this.getInboundConnection(peersNodeAddress);
        }
        if (connection != null) {
            return this.sendMessage(connection, networkEnvelope);
        }
        log.debug("We have not found any connection for peerAddress {}.\n\tWe will create a new outbound connection.", (Object)peersNodeAddress);
        SettableFuture<Connection> resultFuture = SettableFuture.create();
        CompletableFuture<Connection> future = CompletableFuture.supplyAsync(() -> {
            try {
                Thread.currentThread().setName("NetworkNode.connectionExecutor:SendMessage-to-" + Utilities.toTruncatedString(peersNodeAddress.getFullAddress(), 15));
                if (peersNodeAddress.equals(this.getNodeAddress())) {
                    log.warn("We are sending a message to ourselves");
                }
                long startTs = System.currentTimeMillis();
                log.debug("Start create socket to peersNodeAddress {}", (Object)peersNodeAddress.getFullAddress());
                Socket socket = this.createSocket(peersNodeAddress);
                long duration = System.currentTimeMillis() - startTs;
                log.info("Socket creation to peersNodeAddress {} took {} ms", (Object)peersNodeAddress.getFullAddress(), (Object)duration);
                if (duration > (long)CREATE_SOCKET_TIMEOUT) {
                    throw new TimeoutException("A timeout occurred when creating a socket.");
                }
                Connection existingConnection = this.getInboundConnection(peersNodeAddress);
                if (existingConnection == null) {
                    existingConnection = this.getOutboundConnection(peersNodeAddress);
                }
                if (existingConnection != null) {
                    block9: {
                        log.debug("We found in the meantime a connection for peersNodeAddress {}, so we use that for sending the message.\nThat can happen if Tor needs long for creating a new outbound connection.\nWe might have got a new inbound or outbound connection.", (Object)peersNodeAddress.getFullAddress());
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable) {
                            if (this.isShutDownStarted) break block9;
                            log.error("Error at closing socket " + String.valueOf(throwable));
                        }
                    }
                    existingConnection.sendMessage(networkEnvelope);
                    return existingConnection;
                }
                ConnectionListener connectionListener = new ConnectionListener(){

                    @Override
                    public void onConnection(Connection connection) {
                        if (!connection.isStopped()) {
                            NetworkNode.this.outBoundConnections.add((OutboundConnection)connection);
                            NetworkNode.this.printOutBoundConnections();
                            NetworkNode.this.connectionListeners.forEach(e -> e.onConnection(connection));
                        }
                    }

                    @Override
                    public void onDisconnect(CloseConnectionReason closeConnectionReason, Connection connection) {
                        NetworkNode.this.outBoundConnections.remove(connection);
                        NetworkNode.this.printOutBoundConnections();
                        NetworkNode.this.connectionListeners.forEach(e -> e.onDisconnect(closeConnectionReason, connection));
                    }
                };
                OutboundConnection outboundConnection = new OutboundConnection(socket, this, connectionListener, peersNodeAddress, this.networkProtoResolver, this.banFilter);
                if (log.isDebugEnabled()) {
                    log.debug("\n\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\nNetworkNode created new outbound connection:\nmyNodeAddress=" + String.valueOf(this.getNodeAddress()) + "\npeersNodeAddress=" + String.valueOf(peersNodeAddress) + "\nuid=" + outboundConnection.getUid() + "\nmessage=" + String.valueOf(networkEnvelope) + "\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
                }
                outboundConnection.sendMessage(networkEnvelope);
                return outboundConnection;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, this.connectionExecutor);
        if (timeoutSeconds != null) {
            future.orTimeout(timeoutSeconds.intValue(), TimeUnit.SECONDS);
        }
        future.exceptionally(throwable -> {
            log.debug("onFailure at sendMessage: peersNodeAddress={}\n\tmessage={}\n\tthrowable={}", peersNodeAddress, networkEnvelope.getClass().getSimpleName(), throwable.toString());
            UserThread.execute(() -> {
                if (!resultFuture.setException((Throwable)throwable)) {
                    resultFuture.cancel(true);
                }
            });
            return null;
        });
        future.thenAccept(resultFuture::set);
        return resultFuture;
    }

    @Nullable
    private InboundConnection getInboundConnection(@NotNull NodeAddress peersNodeAddress) {
        Optional<InboundConnection> inboundConnectionOptional = this.lookupInBoundConnection(peersNodeAddress);
        if (inboundConnectionOptional.isPresent()) {
            InboundConnection connection = inboundConnectionOptional.get();
            log.trace("We have found a connection in inBoundConnections. Connection.uid={}", (Object)connection.getUid());
            if (connection.isStopped()) {
                log.warn("We have a connection which is already stopped in inBoundConnections. Connection.uid=" + connection.getUid());
                this.inBoundConnections.remove(connection);
                return null;
            }
            return connection;
        }
        return null;
    }

    @Nullable
    private OutboundConnection getOutboundConnection(@NotNull NodeAddress peersNodeAddress) {
        Optional<OutboundConnection> outboundConnectionOptional = this.lookupOutBoundConnection(peersNodeAddress);
        if (outboundConnectionOptional.isPresent()) {
            OutboundConnection connection = outboundConnectionOptional.get();
            log.trace("We have found a connection in outBoundConnections. Connection.uid={}", (Object)connection.getUid());
            if (connection.isStopped()) {
                log.warn("We have a connection which is already stopped in outBoundConnections. Connection.uid=" + connection.getUid());
                this.outBoundConnections.remove(connection);
                return null;
            }
            return connection;
        }
        return null;
    }

    @Nullable
    public Socks5Proxy getSocksProxy() {
        return null;
    }

    public SettableFuture<Connection> sendMessage(Connection connection, NetworkEnvelope networkEnvelope) {
        return this.sendMessage(connection, networkEnvelope, this.sendMessageExecutor);
    }

    public SettableFuture<Connection> sendMessage(Connection connection, NetworkEnvelope networkEnvelope, ListeningExecutorService executor) {
        SettableFuture<Connection> resultFuture;
        block2: {
            resultFuture = SettableFuture.create();
            try {
                Future future = executor.submit(() -> {
                    String id = connection.getPeersNodeAddressOptional().isPresent() ? connection.getPeersNodeAddressOptional().get().getFullAddress() : connection.getUid();
                    Thread.currentThread().setName("NetworkNode:SendMessage-to-" + Utilities.toTruncatedString(id, 15));
                    connection.sendMessage(networkEnvelope);
                    return connection;
                });
                Futures.addCallback(future, new FutureCallback<Connection>(){

                    @Override
                    public void onSuccess(Connection connection) {
                        UserThread.execute(() -> resultFuture.set(connection));
                    }

                    @Override
                    public void onFailure(@NotNull Throwable throwable) {
                        UserThread.execute(() -> NetworkNode.this.resolveWithException(resultFuture, throwable));
                    }
                }, MoreExecutors.directExecutor());
            }
            catch (RejectedExecutionException exception) {
                if (executor.isShutdown()) break block2;
                log.error("RejectedExecutionException at sendMessage: ", exception);
                UserThread.execute(() -> this.resolveWithException(resultFuture, exception));
            }
        }
        return resultFuture;
    }

    private void resolveWithException(SettableFuture<?> future, Throwable exception) {
        if (!future.setException(exception)) {
            future.cancel(true);
        }
    }

    public ReadOnlyObjectProperty<NodeAddress> nodeAddressProperty() {
        return this.nodeAddressProperty;
    }

    public Set<Connection> getAllConnections() {
        HashSet<Connection> set = new HashSet<Connection>(this.inBoundConnections);
        set.addAll(this.outBoundConnections);
        return set;
    }

    public Set<Connection> getConfirmedConnections() {
        return this.getAllConnections().stream().filter(Connection::hasPeersNodeAddress).collect(Collectors.toSet());
    }

    public Set<NodeAddress> getNodeAddressesOfConfirmedConnections() {
        return this.getConfirmedConnections().stream().map(e -> e.getPeersNodeAddressOptional().get()).collect(Collectors.toSet());
    }

    public void shutDown(Runnable shutDownCompleteHandler) {
        log.info("NetworkNode shutdown started");
        if (!this.isShutDownStarted) {
            Set<Connection> allConnections;
            int numConnections;
            this.isShutDownStarted = true;
            if (this.server != null) {
                this.server.shutDown();
                this.server = null;
            }
            if ((numConnections = (allConnections = this.getAllConnections()).size()) == 0) {
                log.info("Shutdown immediately because no connections are open.");
                if (shutDownCompleteHandler != null) {
                    shutDownCompleteHandler.run();
                }
                return;
            }
            log.info("Shutdown {} connections", (Object)numConnections);
            AtomicInteger shutdownCompleted = new AtomicInteger();
            Timer timeoutHandler = UserThread.runAfter(() -> {
                if (shutDownCompleteHandler != null) {
                    log.info("Shutdown completed due timeout");
                    shutDownCompleteHandler.run();
                }
            }, 1500L, TimeUnit.MILLISECONDS);
            allConnections.forEach(c -> c.shutDown(CloseConnectionReason.APP_SHUT_DOWN, () -> {
                shutdownCompleted.getAndIncrement();
                log.info("Shutdown of node {} completed", (Object)c.getPeersNodeAddressOptional());
                if (shutdownCompleted.get() == numConnections) {
                    log.info("Shutdown completed with all connections closed");
                    timeoutHandler.stop();
                    this.connectionExecutor.shutdownNow();
                    this.sendMessageExecutor.shutdownNow();
                    if (shutDownCompleteHandler != null) {
                        shutDownCompleteHandler.run();
                    }
                }
            }));
        }
    }

    public void addSetupListener(SetupListener setupListener) {
        boolean isNewEntry = this.setupListeners.add(setupListener);
        if (!isNewEntry) {
            log.warn("Try to add a setupListener which was already added.");
        }
    }

    @Override
    public void onMessage(NetworkEnvelope networkEnvelope, Connection connection) {
        this.messageListeners.stream().forEach(e -> e.onMessage(networkEnvelope, connection));
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        boolean isNewEntry = this.connectionListeners.add(connectionListener);
        if (!isNewEntry) {
            log.warn("Try to add a connectionListener which was already added.\n\tconnectionListener={}\n\tconnectionListeners={}", (Object)connectionListener, (Object)this.connectionListeners);
        }
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        boolean contained = this.connectionListeners.remove(connectionListener);
        if (!contained) {
            log.debug("Try to remove a connectionListener which was never added.\n\tThat might happen because of async behaviour of CopyOnWriteArraySet");
        }
    }

    public void addMessageListener(MessageListener messageListener) {
        boolean isNewEntry = this.messageListeners.add(messageListener);
        if (!isNewEntry) {
            log.warn("Try to add a messageListener which was already added.");
        }
    }

    public void removeMessageListener(MessageListener messageListener) {
        boolean contained = this.messageListeners.remove(messageListener);
        if (!contained) {
            log.debug("Try to remove a messageListener which was never added.\n\tThat might happen because of async behaviour of CopyOnWriteArraySet");
        }
    }

    void startServer(ServerSocket serverSocket) {
        ConnectionListener connectionListener = new ConnectionListener(){

            @Override
            public void onConnection(Connection connection) {
                if (!connection.isStopped()) {
                    NetworkNode.this.inBoundConnections.add((InboundConnection)connection);
                    NetworkNode.this.printInboundConnections();
                    NetworkNode.this.connectionListeners.stream().forEach(e -> e.onConnection(connection));
                }
            }

            @Override
            public void onDisconnect(CloseConnectionReason closeConnectionReason, Connection connection) {
                log.trace("onDisconnect at server socket connectionListener\n\tconnection={}", (Object)connection);
                NetworkNode.this.inBoundConnections.remove(connection);
                NetworkNode.this.printInboundConnections();
                NetworkNode.this.connectionListeners.stream().forEach(e -> e.onDisconnect(closeConnectionReason, connection));
            }
        };
        this.server = new Server(serverSocket, this, connectionListener, this.networkProtoResolver, this.banFilter);
        this.server.start();
    }

    private Optional<OutboundConnection> lookupOutBoundConnection(NodeAddress peersNodeAddress) {
        log.trace("lookupOutboundConnection for peersNodeAddress={}", (Object)peersNodeAddress.getFullAddress());
        this.printOutBoundConnections();
        return this.outBoundConnections.stream().filter(connection -> connection.hasPeersNodeAddress() && peersNodeAddress.equals(connection.getPeersNodeAddressOptional().get())).findAny();
    }

    private void printOutBoundConnections() {
        StringBuilder sb = new StringBuilder("outBoundConnections size()=").append(this.outBoundConnections.size()).append("\n\toutBoundConnections=");
        this.outBoundConnections.stream().forEach(e -> sb.append(e).append("\n\t"));
        log.debug(sb.toString());
    }

    private Optional<InboundConnection> lookupInBoundConnection(NodeAddress peersNodeAddress) {
        log.trace("lookupInboundConnection for peersNodeAddress={}", (Object)peersNodeAddress.getFullAddress());
        this.printInboundConnections();
        return this.inBoundConnections.stream().filter(connection -> connection.hasPeersNodeAddress() && peersNodeAddress.equals(connection.getPeersNodeAddressOptional().get())).findAny();
    }

    private void printInboundConnections() {
        StringBuilder sb = new StringBuilder("inBoundConnections size()=").append(this.inBoundConnections.size()).append("\n\tinBoundConnections=");
        this.inBoundConnections.stream().forEach(e -> sb.append(e).append("\n\t"));
        log.debug(sb.toString());
    }

    protected abstract Socket createSocket(NodeAddress var1) throws IOException;

    @Nullable
    public NodeAddress getNodeAddress() {
        return (NodeAddress)this.nodeAddressProperty.get();
    }

    public Optional<Capabilities> findPeersCapabilities(NodeAddress nodeAddress) {
        return this.getConfirmedConnections().stream().filter(c -> c.getPeersNodeAddressProperty().get() != null).filter(c -> ((NodeAddress)c.getPeersNodeAddressProperty().get()).equals(nodeAddress)).map(Connection::getCapabilities).findAny();
    }

    public long upTime() {
        long earliestConnection = new Date().getTime();
        for (Connection connection : this.outBoundConnections) {
            earliestConnection = Math.min(earliestConnection, connection.getStatistic().getCreationDate().getTime());
        }
        return new Date().getTime() - earliestConnection;
    }

    public int getInboundConnectionCount() {
        return this.inBoundConnections.size();
    }

    public int getOutboundConnectionCount() {
        return this.outBoundConnections.size();
    }

    public boolean isShutDownStarted() {
        return this.isShutDownStarted;
    }
}

