/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.network;

import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.HavenoRuntimeException;
import haveno.network.p2p.network.Statistic;
import haveno.network.p2p.peers.keepalive.messages.KeepAliveMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.NetworkEnvelope;

@ThreadSafe
class ProtoOutputStream {
    private static final Logger log = LoggerFactory.getLogger(ProtoOutputStream.class);
    private final OutputStream outputStream;
    private final Statistic statistic;
    private final AtomicBoolean isConnectionActive = new AtomicBoolean(true);
    private final Lock lock = new ReentrantLock();

    ProtoOutputStream(OutputStream outputStream, Statistic statistic) {
        this.outputStream = outputStream;
        this.statistic = statistic;
    }

    void writeEnvelope(haveno.common.proto.network.NetworkEnvelope envelope) {
        this.lock.lock();
        try {
            this.writeEnvelopeOrThrow(envelope);
        }
        catch (IOException e) {
            if (!this.isConnectionActive.get()) {
                return;
            }
            log.error("Failed to write envelope", e);
            throw new HavenoRuntimeException("Failed to write envelope", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    void onConnectionShutdown() {
        this.isConnectionActive.set(false);
        boolean acquiredLock = this.tryToAcquireLock();
        if (!acquiredLock) {
            return;
        }
        try {
            this.outputStream.close();
        }
        catch (Throwable t2) {
            log.error("Failed to close connection", t2);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeEnvelopeOrThrow(haveno.common.proto.network.NetworkEnvelope envelope) throws IOException {
        long ts = System.currentTimeMillis();
        NetworkEnvelope proto = envelope.toProtoNetworkEnvelope();
        proto.writeDelimitedTo(this.outputStream);
        this.outputStream.flush();
        long duration = System.currentTimeMillis() - ts;
        if (duration > 10000L) {
            log.info("Sending {} to peer took {} sec.", (Object)envelope.getClass().getSimpleName(), (Object)((double)duration / 1000.0));
        }
        this.statistic.addSentBytes(proto.getSerializedSize());
        this.statistic.addSentMessage(envelope);
        if (!(envelope instanceof KeepAliveMessage)) {
            this.statistic.updateLastActivityTimestamp();
        }
    }

    private boolean tryToAcquireLock() {
        long shutdownTimeout = Connection.getShutdownTimeout();
        try {
            return this.lock.tryLock(shutdownTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

