/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.network;

import haveno.network.p2p.network.TorMode;
import java.io.File;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Date;
import org.berndpruenster.netlayer.tor.ExternalTor;
import org.berndpruenster.netlayer.tor.Tor;
import org.berndpruenster.netlayer.tor.TorCtlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningTor
extends TorMode {
    private static final Logger log = LoggerFactory.getLogger(RunningTor.class);
    private final String controlHost;
    private final int controlPort;
    private final String password;
    private final File cookieFile;
    private final boolean useSafeCookieAuthentication;

    public RunningTor(File torDir, String controlHost, int controlPort, String password, File cookieFile, boolean useSafeCookieAuthentication) {
        super(torDir);
        this.controlHost = controlHost;
        this.controlPort = controlPort;
        this.password = password;
        this.cookieFile = cookieFile;
        this.useSafeCookieAuthentication = useSafeCookieAuthentication;
    }

    @Override
    public Tor getTor() throws TorCtlException {
        long ts1 = new Date().getTime();
        boolean retry = true;
        long twoMinutesInMilli = 120000L;
        while (retry && new Date().getTime() - ts1 <= twoMinutesInMilli) {
            retry = false;
            try {
                log.info("Connecting to running tor");
                ExternalTor result = !this.password.isEmpty() ? new ExternalTor(this.controlHost, this.controlPort, this.password) : (this.cookieFile != null && this.cookieFile.exists() ? new ExternalTor(this.controlHost, this.controlPort, this.cookieFile, this.useSafeCookieAuthentication) : new ExternalTor(this.controlHost, this.controlPort));
                boolean isTorBootstrapped = result.control.waitUntilBootstrapped();
                if (!isTorBootstrapped) {
                    log.error("Couldn't bootstrap Tor.");
                }
                log.info("\n################################################################\nConnecting to Tor successful after {} ms. Start publishing hidden service.\n################################################################", (Object)(new Date().getTime() - ts1));
                return result;
            }
            catch (Exception e) {
                if (e instanceof UnknownHostException || e instanceof ConnectException) {
                    log.warn("Couldn't connect to Tor control port. Retrying...", e);
                    retry = true;
                }
                log.error("Couldn't connect to Tor.", e);
            }
        }
        return null;
    }

    @Override
    public String getHiddenServiceDirectory() {
        return new File(this.torDir, "hiddenservice").getAbsolutePath();
    }
}

