/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.network;

import haveno.common.proto.network.NetworkProtoResolver;
import haveno.network.p2p.network.BanFilter;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.ConnectionListener;
import haveno.network.p2p.network.InboundConnection;
import haveno.network.p2p.network.MessageListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Server
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    private final MessageListener messageListener;
    private final ConnectionListener connectionListener;
    @Nullable
    private final BanFilter banFilter;
    private final ServerSocket serverSocket;
    private final int localPort;
    private final Set<Connection> connections = new CopyOnWriteArraySet<Connection>();
    private final NetworkProtoResolver networkProtoResolver;
    private final Thread serverThread = new Thread(this);

    public Server(ServerSocket serverSocket, MessageListener messageListener, ConnectionListener connectionListener, NetworkProtoResolver networkProtoResolver, @Nullable BanFilter banFilter) {
        this.networkProtoResolver = networkProtoResolver;
        this.serverSocket = serverSocket;
        this.localPort = serverSocket.getLocalPort();
        this.messageListener = messageListener;
        this.connectionListener = connectionListener;
        this.banFilter = banFilter;
    }

    public void start() {
        this.serverThread.setName("Server-" + this.localPort);
        this.serverThread.start();
    }

    @Override
    public void run() {
        try {
            try {
                while (this.isServerActive()) {
                    log.debug("Ready to accept new clients on port " + this.localPort);
                    Socket socket = this.serverSocket.accept();
                    if (!this.isServerActive()) continue;
                    log.debug("Accepted new client on localPort/port " + socket.getLocalPort() + "/" + socket.getPort());
                    InboundConnection connection = new InboundConnection(socket, this.messageListener, this.connectionListener, this.networkProtoResolver, this.banFilter);
                    log.debug("\n\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\nServer created new inbound connection:\nlocalPort/port={}/{}\nconnection.uid={}", this.serverSocket.getLocalPort(), socket.getPort(), connection.getUid() + "\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
                    if (this.isServerActive()) {
                        this.connections.add(connection);
                        continue;
                    }
                    connection.shutDown(CloseConnectionReason.APP_SHUT_DOWN);
                }
            }
            catch (IOException e) {
                if (this.isServerActive()) {
                    log.error("Error executing server loop: {}\n", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        catch (Throwable t2) {
            log.error("Executing task failed: {}\n", (Object)t2.getMessage(), (Object)t2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void shutDown() {
        log.info("Server shutdown started");
        if (this.isServerActive()) {
            this.serverThread.interrupt();
            this.connections.forEach(connection -> connection.shutDown(CloseConnectionReason.APP_SHUT_DOWN));
            try {
                if (this.serverSocket.isClosed()) return;
                this.serverSocket.close();
                return;
            }
            catch (SocketException e) {
                log.debug("SocketException at shutdown might be expected " + e.getMessage());
                return;
            }
            catch (IOException e) {
                log.debug("Exception at shutdown. " + e.getMessage());
                return;
            }
            finally {
                log.debug("Server shutdown complete");
            }
        } else {
            log.warn("stopped already called ast shutdown");
        }
    }

    private boolean isServerActive() {
        return !this.serverThread.isInterrupted();
    }
}

