/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.peers;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.util.Utilities;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.peers.BroadcastHandler;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.storage.messages.BroadcastMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Broadcaster
implements BroadcastHandler.ResultHandler {
    private static final Logger log = LoggerFactory.getLogger(Broadcaster.class);
    private static final long BROADCAST_INTERVAL_MS = 2000L;
    private final NetworkNode networkNode;
    private final PeerManager peerManager;
    private final Set<BroadcastHandler> broadcastHandlers = new CopyOnWriteArraySet<BroadcastHandler>();
    private final List<BroadcastRequest> broadcastRequests = new ArrayList<BroadcastRequest>();
    private Timer timer;
    private boolean shutDownRequested;
    private Runnable shutDownResultHandler;
    private final ListeningExecutorService executor;

    @Inject
    public Broadcaster(NetworkNode networkNode, PeerManager peerManager, @Named(value="maxConnections") int maxConnections) {
        this.networkNode = networkNode;
        this.peerManager = peerManager;
        ThreadPoolExecutor threadPoolExecutor = Utilities.getThreadPoolExecutor("Broadcaster", maxConnections * 3, maxConnections * 4, 30, 30L);
        this.executor = MoreExecutors.listeningDecorator(threadPoolExecutor);
    }

    public void shutDown(Runnable resultHandler) {
        log.info("Broadcaster shutdown started");
        this.shutDownRequested = true;
        this.shutDownResultHandler = resultHandler;
        if (this.broadcastRequests.isEmpty()) {
            this.doShutDown();
        } else {
            this.maybeBroadcastBundle();
        }
        this.executor.shutdown();
    }

    public void flush() {
        this.maybeBroadcastBundle();
    }

    private void doShutDown() {
        log.info("Broadcaster doShutDown started");
        this.broadcastHandlers.forEach(BroadcastHandler::cancel);
        if (this.timer != null) {
            this.timer.stop();
        }
        this.shutDownResultHandler.run();
    }

    public void broadcast(BroadcastMessage message, @Nullable NodeAddress sender) {
        this.broadcast(message, sender, null);
    }

    public void broadcast(BroadcastMessage message, @Nullable NodeAddress sender, @Nullable BroadcastHandler.Listener listener) {
        this.broadcastRequests.add(new BroadcastRequest(message, sender, listener));
        if (this.timer == null) {
            this.timer = UserThread.runAfter(this::maybeBroadcastBundle, 2000L, TimeUnit.MILLISECONDS);
        }
    }

    private void maybeBroadcastBundle() {
        if (!this.broadcastRequests.isEmpty()) {
            BroadcastHandler broadcastHandler = new BroadcastHandler(this.networkNode, this.peerManager, this);
            this.broadcastHandlers.add(broadcastHandler);
            broadcastHandler.broadcast(new ArrayList<BroadcastRequest>(this.broadcastRequests), this.shutDownRequested, this.executor);
            this.broadcastRequests.clear();
            if (this.timer != null) {
                this.timer.stop();
            }
            this.timer = null;
        }
    }

    @Override
    public void onCompleted(BroadcastHandler broadcastHandler) {
        this.broadcastHandlers.remove(broadcastHandler);
        if (this.shutDownRequested) {
            this.doShutDown();
        }
    }

    public static final class BroadcastRequest {
        private final BroadcastMessage message;
        @Nullable
        private final NodeAddress sender;
        @Nullable
        private final BroadcastHandler.Listener listener;

        private BroadcastRequest(BroadcastMessage message, @Nullable NodeAddress sender, @Nullable BroadcastHandler.Listener listener) {
            this.message = message;
            this.sender = sender;
            this.listener = listener;
        }

        public BroadcastMessage getMessage() {
            return this.message;
        }

        @Nullable
        public NodeAddress getSender() {
            return this.sender;
        }

        @Nullable
        public BroadcastHandler.Listener getListener() {
            return this.listener;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BroadcastRequest)) {
                return false;
            }
            BroadcastRequest other = (BroadcastRequest)o;
            BroadcastMessage this$message = this.getMessage();
            BroadcastMessage other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            NodeAddress this$sender = this.getSender();
            NodeAddress other$sender = other.getSender();
            if (this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender)) {
                return false;
            }
            BroadcastHandler.Listener this$listener = this.getListener();
            BroadcastHandler.Listener other$listener = other.getListener();
            return !(this$listener == null ? other$listener != null : !this$listener.equals(other$listener));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BroadcastMessage $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            NodeAddress $sender = this.getSender();
            result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
            BroadcastHandler.Listener $listener = this.getListener();
            result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
            return result;
        }

        public String toString() {
            return "Broadcaster.BroadcastRequest(message=" + String.valueOf(this.getMessage()) + ", sender=" + String.valueOf(this.getSender()) + ", listener=" + String.valueOf(this.getListener()) + ")";
        }
    }
}

