/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.peers.getdata.messages;

import com.google.protobuf.ByteString;
import haveno.common.app.Version;
import haveno.common.proto.ProtoUtil;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.SendersNodeAddressMessage;
import haveno.network.p2p.peers.getdata.messages.GetDataRequest;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.GetUpdatedDataRequest;
import protobuf.NetworkEnvelope;

public final class GetUpdatedDataRequest
extends GetDataRequest
implements SendersNodeAddressMessage {
    private static final Logger log = LoggerFactory.getLogger(GetUpdatedDataRequest.class);
    private final NodeAddress senderNodeAddress;

    public GetUpdatedDataRequest(NodeAddress senderNodeAddress, int nonce, Set<byte[]> excludedKeys) {
        this(senderNodeAddress, nonce, excludedKeys, "1.1.1", Version.getP2PMessageVersion());
    }

    private GetUpdatedDataRequest(NodeAddress senderNodeAddress, int nonce, Set<byte[]> excludedKeys, @Nullable String version, String messageVersion) {
        super(messageVersion, nonce, excludedKeys, version);
        this.senderNodeAddress = senderNodeAddress;
    }

    @Override
    public NetworkEnvelope toProtoNetworkEnvelope() {
        GetUpdatedDataRequest.Builder builder = protobuf.GetUpdatedDataRequest.newBuilder().setSenderNodeAddress(this.senderNodeAddress.toProtoMessage()).setNonce(this.nonce).addAllExcludedKeys(this.excludedKeys.stream().map(ByteString::copyFrom).collect(Collectors.toList()));
        Optional.ofNullable(this.version).ifPresent(builder::setVersion);
        NetworkEnvelope proto = this.getNetworkEnvelopeBuilder().setGetUpdatedDataRequest(builder).build();
        log.info("Sending a GetUpdatedDataRequest with {} kB and {} excluded key entries. Requesters version={}", (double)proto.getSerializedSize() / 1000.0, this.excludedKeys.size(), this.version);
        return proto;
    }

    public static GetUpdatedDataRequest fromProto(protobuf.GetUpdatedDataRequest proto, String messageVersion) {
        Set<byte[]> excludedKeys = ProtoUtil.byteSetFromProtoByteStringList(proto.getExcludedKeysList());
        String requestersVersion = ProtoUtil.stringOrNullFromProto(proto.getVersion());
        log.info("Received a GetUpdatedDataRequest with {} kB and {} excluded key entries. Requesters version={}", (double)proto.getSerializedSize() / 1000.0, excludedKeys.size(), requestersVersion);
        return new GetUpdatedDataRequest(NodeAddress.fromProto(proto.getSenderNodeAddress()), proto.getNonce(), excludedKeys, requestersVersion, messageVersion);
    }

    @Override
    public NodeAddress getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    @Override
    public String toString() {
        return "GetUpdatedDataRequest(senderNodeAddress=" + String.valueOf(this.getSenderNodeAddress()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetUpdatedDataRequest)) {
            return false;
        }
        GetUpdatedDataRequest other = (GetUpdatedDataRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeAddress this$senderNodeAddress = this.getSenderNodeAddress();
        NodeAddress other$senderNodeAddress = other.getSenderNodeAddress();
        return !(this$senderNodeAddress == null ? other$senderNodeAddress != null : !((Object)this$senderNodeAddress).equals(other$senderNodeAddress));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetUpdatedDataRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        NodeAddress $senderNodeAddress = this.getSenderNodeAddress();
        result = result * 59 + ($senderNodeAddress == null ? 43 : ((Object)$senderNodeAddress).hashCode());
        return result;
    }
}

