/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.peers.keepalive;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.util.Utilities;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.ConnectionListener;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.network.OutboundConnection;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.peers.keepalive.KeepAliveHandler;
import haveno.network.p2p.peers.keepalive.messages.Ping;
import haveno.network.p2p.peers.keepalive.messages.Pong;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepAliveManager
implements MessageListener,
ConnectionListener,
PeerManager.Listener {
    private static final Logger log = LoggerFactory.getLogger(KeepAliveManager.class);
    private static final int INTERVAL_SEC = new Random().nextInt(30) + 30;
    private static final long LAST_ACTIVITY_AGE_MS = INTERVAL_SEC * 1000 / 2;
    private final NetworkNode networkNode;
    private final PeerManager peerManager;
    private final Map<String, KeepAliveHandler> handlerMap = new HashMap<String, KeepAliveHandler>();
    private boolean stopped;
    private Timer keepAliveTimer;

    @Inject
    public KeepAliveManager(NetworkNode networkNode, PeerManager peerManager) {
        this.networkNode = networkNode;
        this.peerManager = peerManager;
        this.networkNode.addMessageListener(this);
        this.networkNode.addConnectionListener(this);
        this.peerManager.addListener(this);
    }

    public void shutDown() {
        this.stopped = true;
        this.networkNode.removeMessageListener(this);
        this.networkNode.removeConnectionListener(this);
        this.peerManager.removeListener(this);
        this.closeAllHandlers();
        this.stopKeepAliveTimer();
    }

    public void start() {
        this.restart();
    }

    @Override
    public void onMessage(NetworkEnvelope networkEnvelope, Connection connection) {
        if (networkEnvelope instanceof Ping) {
            if (!this.stopped) {
                Ping ping = (Ping)networkEnvelope;
                connection.getStatistic().setRoundTripTime(ping.getLastRoundTripTime());
                Pong pong = new Pong(ping.getNonce());
                SettableFuture<Connection> future = this.networkNode.sendMessage(connection, (NetworkEnvelope)pong);
                Futures.addCallback(future, Utilities.failureCallback(throwable -> {
                    if (!this.stopped) {
                        String errorMessage = "Sending pong to " + String.valueOf(connection) + " failed. That is expected if the peer is offline. Exception: " + throwable.getMessage();
                        log.info(errorMessage);
                        this.peerManager.handleConnectionFault(connection);
                    } else {
                        log.warn("We have stopped already. We ignore that  networkNode.sendMessage.onFailure call.");
                    }
                }), MoreExecutors.directExecutor());
            } else {
                log.warn("We have stopped already. We ignore that onMessage call.");
            }
        }
    }

    @Override
    public void onConnection(Connection connection) {
    }

    @Override
    public void onDisconnect(CloseConnectionReason closeConnectionReason, Connection connection) {
        this.closeHandler(connection);
    }

    @Override
    public void onAllConnectionsLost() {
        this.closeAllHandlers();
        this.stopKeepAliveTimer();
        this.stopped = true;
        this.restart();
    }

    @Override
    public void onNewConnectionAfterAllConnectionsLost() {
        this.closeAllHandlers();
        this.stopped = false;
        this.restart();
    }

    @Override
    public void onAwakeFromStandby() {
        this.closeAllHandlers();
        this.stopped = false;
        if (!this.networkNode.getAllConnections().isEmpty()) {
            this.restart();
        }
    }

    private void restart() {
        if (this.keepAliveTimer == null) {
            this.keepAliveTimer = UserThread.runPeriodically(() -> {
                this.stopped = false;
                this.keepAlive();
            }, INTERVAL_SEC);
        }
    }

    private void keepAlive() {
        if (!this.stopped) {
            this.networkNode.getConfirmedConnections().stream().filter(connection -> connection instanceof OutboundConnection && connection.getStatistic().getLastActivityAge() > LAST_ACTIVITY_AGE_MS).forEach(connection -> {
                final String uid = connection.getUid();
                if (!this.handlerMap.containsKey(uid)) {
                    KeepAliveHandler keepAliveHandler = new KeepAliveHandler(this.networkNode, this.peerManager, new KeepAliveHandler.Listener(){

                        @Override
                        public void onComplete() {
                            KeepAliveManager.this.handlerMap.remove(uid);
                        }

                        @Override
                        public void onFault(String errorMessage) {
                            KeepAliveManager.this.handlerMap.remove(uid);
                        }
                    });
                    this.handlerMap.put(uid, keepAliveHandler);
                    keepAliveHandler.sendPingAfterRandomDelay((Connection)connection);
                } else {
                    log.debug("Connection with id {} has not completed and is still in our map. We will try to ping that peer at the next schedule.", (Object)uid);
                }
            });
            int size = this.handlerMap.size();
            log.debug("handlerMap size=" + size);
            if (size > this.peerManager.getMaxConnections()) {
                log.warn("Seems we didn't clean up out map correctly.\nhandlerMap size={}, peerManager.getMaxConnections()={}", (Object)size, (Object)this.peerManager.getMaxConnections());
            }
        } else {
            log.warn("We have stopped already. We ignore that keepAlive call.");
        }
    }

    private void stopKeepAliveTimer() {
        this.stopped = true;
        if (this.keepAliveTimer != null) {
            this.keepAliveTimer.stop();
            this.keepAliveTimer = null;
        }
    }

    private void closeHandler(Connection connection) {
        String uid = connection.getUid();
        if (this.handlerMap.containsKey(uid)) {
            this.handlerMap.get(uid).cancel();
            this.handlerMap.remove(uid);
        }
    }

    private void closeAllHandlers() {
        this.handlerMap.values().stream().forEach(KeepAliveHandler::cancel);
        this.handlerMap.clear();
    }
}

