/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.peers.peerexchange;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.peers.peerexchange.Peer;
import haveno.network.p2p.peers.peerexchange.messages.GetPeersRequest;
import haveno.network.p2p.peers.peerexchange.messages.GetPeersResponse;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetPeersRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(GetPeersRequestHandler.class);
    private static final long TIMEOUT = 90L;
    private final NetworkNode networkNode;
    private final PeerManager peerManager;
    private final Listener listener;
    private Timer timeoutTimer;
    private boolean stopped;

    public GetPeersRequestHandler(NetworkNode networkNode, PeerManager peerManager, Listener listener) {
        this.networkNode = networkNode;
        this.peerManager = peerManager;
        this.listener = listener;
    }

    public void handle(GetPeersRequest getPeersRequest, final Connection connection) {
        Preconditions.checkArgument(connection.getPeersNodeAddressOptional().isPresent(), "The peers address must have been already set at the moment");
        final GetPeersResponse getPeersResponse = new GetPeersResponse(getPeersRequest.getNonce(), new HashSet<Peer>(this.peerManager.getLivePeers(connection.getPeersNodeAddressOptional().get())));
        Preconditions.checkArgument(this.timeoutTimer == null, "onGetPeersRequest must not be called twice.");
        this.timeoutTimer = UserThread.runAfter(() -> {
            if (!this.stopped) {
                String errorMessage = "A timeout occurred at sending getPeersResponse:" + String.valueOf(getPeersResponse) + " on connection:" + String.valueOf(connection);
                log.debug(errorMessage + " / PeerExchangeHandshake=" + String.valueOf(this));
                log.debug("timeoutTimer called. this=" + String.valueOf(this));
                this.handleFault(errorMessage, CloseConnectionReason.SEND_MSG_TIMEOUT, connection);
            } else {
                log.trace("We have stopped already. We ignore that timeoutTimer.run call.");
            }
        }, 90L, TimeUnit.SECONDS);
        SettableFuture<Connection> future = this.networkNode.sendMessage(connection, (NetworkEnvelope)getPeersResponse);
        Futures.addCallback(future, new FutureCallback<Connection>(){

            @Override
            public void onSuccess(Connection connection2) {
                if (!GetPeersRequestHandler.this.stopped) {
                    log.trace("GetPeersResponse sent successfully");
                    GetPeersRequestHandler.this.cleanup();
                    GetPeersRequestHandler.this.listener.onComplete();
                } else {
                    log.trace("We have stopped already. We ignore that networkNode.sendMessage.onSuccess call.");
                }
            }

            @Override
            public void onFailure(@NotNull Throwable throwable) {
                if (!GetPeersRequestHandler.this.stopped) {
                    String errorMessage = "Sending getPeersResponse to " + String.valueOf(connection) + " failed. That is expected if the peer is offline. getPeersResponse=" + String.valueOf(getPeersResponse) + ".Exception: " + throwable.getMessage();
                    log.info(errorMessage);
                    GetPeersRequestHandler.this.handleFault(errorMessage, CloseConnectionReason.SEND_MSG_FAILURE, connection);
                } else {
                    log.trace("We have stopped already. We ignore that networkNode.sendMessage.onFailure call.");
                }
            }
        }, MoreExecutors.directExecutor());
        this.peerManager.addToReportedPeers(getPeersRequest.getReportedPeers(), connection, getPeersRequest.getSupportedCapabilities());
    }

    private void handleFault(String errorMessage, CloseConnectionReason closeConnectionReason, Connection connection) {
        this.cleanup();
        this.listener.onFault(errorMessage, connection);
    }

    private void cleanup() {
        this.stopped = true;
        if (this.timeoutTimer != null) {
            this.timeoutTimer.stop();
            this.timeoutTimer = null;
        }
    }

    public static interface Listener {
        public void onComplete();

        public void onFault(String var1, Connection var2);
    }
}

