/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.peers.peerexchange;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.peers.peerexchange.Peer;
import haveno.network.p2p.peers.peerexchange.messages.GetPeersRequest;
import haveno.network.p2p.peers.peerexchange.messages.GetPeersResponse;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PeerExchangeHandler
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(PeerExchangeHandler.class);
    private static final long TIMEOUT = 90L;
    private static final int DELAY_MS = 500;
    private static final long LOG_THROTTLE_INTERVAL_MS = 60000L;
    private static long lastLoggedWarningTs = 0L;
    private static int numThrottledWarnings = 0;
    private final NetworkNode networkNode;
    private final PeerManager peerManager;
    private final Listener listener;
    private final int nonce = new Random().nextInt();
    private Timer timeoutTimer;
    private Connection connection;
    private boolean stopped;
    private Timer delayTimer;

    public PeerExchangeHandler(NetworkNode networkNode, PeerManager peerManager, Listener listener) {
        this.networkNode = networkNode;
        this.peerManager = peerManager;
        this.listener = listener;
    }

    public void cancel() {
        this.cleanup();
    }

    public void sendGetPeersRequestAfterRandomDelay(NodeAddress nodeAddress) {
        this.delayTimer = UserThread.runAfterRandomDelay(() -> this.sendGetPeersRequest(nodeAddress), 1L, 500L, TimeUnit.MILLISECONDS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendGetPeersRequest(final NodeAddress nodeAddress) {
        log.debug("sendGetPeersRequest to nodeAddress={}", (Object)nodeAddress);
        if (!this.stopped) {
            if (this.networkNode.getNodeAddress() != null) {
                GetPeersRequest getPeersRequest = new GetPeersRequest(this.networkNode.getNodeAddress(), this.nonce, new HashSet<Peer>(this.peerManager.getLivePeers(nodeAddress)));
                if (this.timeoutTimer == null) {
                    this.timeoutTimer = UserThread.runAfter(() -> {
                        if (!this.stopped) {
                            String errorMessage = "A timeout occurred at sending getPeersRequest. nodeAddress=" + String.valueOf(nodeAddress);
                            this.handleFault(errorMessage, CloseConnectionReason.SEND_MSG_TIMEOUT, nodeAddress);
                        } else {
                            log.trace("We have stopped that handler already. We ignore that timeoutTimer.run call.");
                        }
                    }, 90L, TimeUnit.SECONDS);
                }
                try {
                    SettableFuture<Connection> future = this.networkNode.sendMessage(nodeAddress, (NetworkEnvelope)getPeersRequest);
                    Futures.addCallback(future, new FutureCallback<Connection>(){

                        @Override
                        public void onSuccess(Connection connection) {
                            if (!PeerExchangeHandler.this.stopped) {
                                PeerExchangeHandler.this.connection = connection;
                                connection.addMessageListener(PeerExchangeHandler.this);
                            } else {
                                log.trace("We have stopped that handler already. We ignore that sendGetPeersRequest.onSuccess call.");
                            }
                        }

                        @Override
                        public void onFailure(@NotNull Throwable throwable) {
                            if (!PeerExchangeHandler.this.stopped) {
                                String errorMessage = "Sending getPeersRequest to " + String.valueOf(nodeAddress) + " failed. That is expected if the peer is offline. Exception=" + throwable.getMessage();
                                PeerExchangeHandler.this.handleFault(errorMessage, CloseConnectionReason.SEND_MSG_FAILURE, nodeAddress);
                            } else {
                                log.trace("We have stopped that handler already. We ignore that sendGetPeersRequest.onFailure call.");
                            }
                        }
                    }, MoreExecutors.directExecutor());
                    return;
                }
                catch (Exception e) {
                    if (this.networkNode.isShutDownStarted()) return;
                    throw e;
                }
            } else {
                log.debug("My node address is still null at sendGetPeersRequest. We ignore that call.");
            }
            return;
        } else {
            log.trace("We have stopped that handler already. We ignore that sendGetPeersRequest call.");
        }
    }

    @Override
    public void onMessage(NetworkEnvelope networkEnvelope, Connection connection) {
        if (networkEnvelope instanceof GetPeersResponse) {
            if (!this.stopped) {
                GetPeersResponse getPeersResponse = (GetPeersResponse)networkEnvelope;
                if (getPeersResponse.getRequestNonce() == this.nonce) {
                    this.peerManager.addToReportedPeers(getPeersResponse.getReportedPeers(), connection, getPeersResponse.getSupportedCapabilities());
                    this.cleanup();
                    this.listener.onComplete();
                } else {
                    this.throttleWarn("Nonce not matching. That should never happen.\n\tWe drop that message. nonce=" + this.nonce + ", requestNonce=" + getPeersResponse.getRequestNonce() + ", peerNodeAddress=" + String.valueOf(connection.getPeersNodeAddressOptional().orElseGet(null)));
                }
            } else {
                log.trace("We have stopped that handler already. We ignore that onMessage call.");
            }
        }
    }

    private void handleFault(String errorMessage, CloseConnectionReason closeConnectionReason, NodeAddress nodeAddress) {
        this.cleanup();
        this.peerManager.handleConnectionFault(nodeAddress, this.connection);
        this.listener.onFault(errorMessage, this.connection);
    }

    private void cleanup() {
        this.stopped = true;
        if (this.connection != null) {
            this.connection.removeMessageListener(this);
        }
        if (this.timeoutTimer != null) {
            this.timeoutTimer.stop();
            this.timeoutTimer = null;
        }
        if (this.delayTimer != null) {
            this.delayTimer.stop();
            this.delayTimer = null;
        }
    }

    private synchronized void throttleWarn(String msg) {
        boolean logWarning;
        boolean bl = logWarning = System.currentTimeMillis() - lastLoggedWarningTs > 60000L;
        if (logWarning) {
            log.warn(msg);
            if (numThrottledWarnings > 0) {
                log.warn("{} warnings were throttled since the last log entry", (Object)numThrottledWarnings);
            }
            numThrottledWarnings = 0;
            lastLoggedWarningTs = System.currentTimeMillis();
        } else {
            ++numThrottledWarnings;
        }
    }

    public static interface Listener {
        public void onComplete();

        public void onFault(String var1, @Nullable Connection var2);
    }
}

