/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.peers.peerexchange.messages;

import haveno.common.app.Capabilities;
import haveno.common.app.Version;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.SupportedCapabilitiesMessage;
import haveno.network.p2p.peers.peerexchange.Peer;
import haveno.network.p2p.peers.peerexchange.messages.PeerExchangeMessage;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import protobuf.GetPeersResponse;
import protobuf.NetworkEnvelope;

public final class GetPeersResponse
extends haveno.common.proto.network.NetworkEnvelope
implements PeerExchangeMessage,
SupportedCapabilitiesMessage {
    private final int requestNonce;
    private final Set<Peer> reportedPeers;
    @Nullable
    private final Capabilities supportedCapabilities;

    public GetPeersResponse(int requestNonce, Set<Peer> reportedPeers) {
        this(requestNonce, reportedPeers, Capabilities.app, Version.getP2PMessageVersion());
    }

    private GetPeersResponse(int requestNonce, Set<Peer> reportedPeers, @Nullable Capabilities supportedCapabilities, String messageVersion) {
        super(messageVersion);
        this.requestNonce = requestNonce;
        this.reportedPeers = reportedPeers;
        this.supportedCapabilities = supportedCapabilities;
    }

    @Override
    public NetworkEnvelope toProtoNetworkEnvelope() {
        HashSet<Peer> clone = new HashSet<Peer>(this.reportedPeers);
        GetPeersResponse.Builder builder = protobuf.GetPeersResponse.newBuilder().setRequestNonce(this.requestNonce).addAllReportedPeers(clone.stream().map(Peer::toProtoMessage).collect(Collectors.toList()));
        Optional.ofNullable(this.supportedCapabilities).ifPresent(e -> builder.addAllSupportedCapabilities(Capabilities.toIntList(this.supportedCapabilities)));
        return this.getNetworkEnvelopeBuilder().setGetPeersResponse(builder).build();
    }

    public static GetPeersResponse fromProto(protobuf.GetPeersResponse proto, String messageVersion) {
        HashSet reportedPeers = proto.getReportedPeersList().stream().map(peer -> {
            NodeAddress nodeAddress = new NodeAddress(peer.getNodeAddress().getHostName(), peer.getNodeAddress().getPort());
            return new Peer(nodeAddress, Capabilities.fromIntList(peer.getSupportedCapabilitiesList()));
        }).collect(Collectors.toCollection(HashSet::new));
        return new GetPeersResponse(proto.getRequestNonce(), reportedPeers, Capabilities.fromIntList(proto.getSupportedCapabilitiesList()), messageVersion);
    }

    public int getRequestNonce() {
        return this.requestNonce;
    }

    public Set<Peer> getReportedPeers() {
        return this.reportedPeers;
    }

    @Override
    @Nullable
    public Capabilities getSupportedCapabilities() {
        return this.supportedCapabilities;
    }

    @Override
    public String toString() {
        return "GetPeersResponse(requestNonce=" + this.getRequestNonce() + ", reportedPeers=" + String.valueOf(this.getReportedPeers()) + ", supportedCapabilities=" + String.valueOf(this.getSupportedCapabilities()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetPeersResponse)) {
            return false;
        }
        GetPeersResponse other = (GetPeersResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getRequestNonce() != other.getRequestNonce()) {
            return false;
        }
        Set<Peer> this$reportedPeers = this.getReportedPeers();
        Set<Peer> other$reportedPeers = other.getReportedPeers();
        if (this$reportedPeers == null ? other$reportedPeers != null : !((Object)this$reportedPeers).equals(other$reportedPeers)) {
            return false;
        }
        Capabilities this$supportedCapabilities = this.getSupportedCapabilities();
        Capabilities other$supportedCapabilities = other.getSupportedCapabilities();
        return !(this$supportedCapabilities == null ? other$supportedCapabilities != null : !((Object)this$supportedCapabilities).equals(other$supportedCapabilities));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetPeersResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getRequestNonce();
        Set<Peer> $reportedPeers = this.getReportedPeers();
        result = result * 59 + ($reportedPeers == null ? 43 : ((Object)$reportedPeers).hashCode());
        Capabilities $supportedCapabilities = this.getSupportedCapabilities();
        result = result * 59 + ($supportedCapabilities == null ? 43 : ((Object)$supportedCapabilities).hashCode());
        return result;
    }
}

