/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.app.Capabilities;
import haveno.common.crypto.CryptoException;
import haveno.common.crypto.Hash;
import haveno.common.crypto.Sig;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.network.GetDataResponsePriority;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.proto.network.NetworkPayload;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.common.util.Hex;
import haveno.common.util.Tuple2;
import haveno.common.util.Utilities;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.ConnectionListener;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.peers.BroadcastHandler;
import haveno.network.p2p.peers.Broadcaster;
import haveno.network.p2p.peers.getdata.messages.GetDataRequest;
import haveno.network.p2p.peers.getdata.messages.GetDataResponse;
import haveno.network.p2p.peers.getdata.messages.GetUpdatedDataRequest;
import haveno.network.p2p.peers.getdata.messages.PreliminaryGetDataRequest;
import haveno.network.p2p.storage.HashMapChangedListener;
import haveno.network.p2p.storage.messages.AddDataMessage;
import haveno.network.p2p.storage.messages.AddOncePayload;
import haveno.network.p2p.storage.messages.AddPersistableNetworkPayloadMessage;
import haveno.network.p2p.storage.messages.BroadcastMessage;
import haveno.network.p2p.storage.messages.RefreshOfferMessage;
import haveno.network.p2p.storage.messages.RemoveDataMessage;
import haveno.network.p2p.storage.messages.RemoveMailboxDataMessage;
import haveno.network.p2p.storage.payload.CapabilityRequiringPayload;
import haveno.network.p2p.storage.payload.DateSortedTruncatablePayload;
import haveno.network.p2p.storage.payload.DateTolerantPayload;
import haveno.network.p2p.storage.payload.MailboxStoragePayload;
import haveno.network.p2p.storage.payload.PersistableNetworkPayload;
import haveno.network.p2p.storage.payload.ProcessOncePersistableNetworkPayload;
import haveno.network.p2p.storage.payload.ProtectedMailboxStorageEntry;
import haveno.network.p2p.storage.payload.ProtectedStorageEntry;
import haveno.network.p2p.storage.payload.ProtectedStoragePayload;
import haveno.network.p2p.storage.payload.RequiresOwnerIsOnlinePayload;
import haveno.network.p2p.storage.persistence.AppendOnlyDataStoreListener;
import haveno.network.p2p.storage.persistence.AppendOnlyDataStoreService;
import haveno.network.p2p.storage.persistence.HistoricalDataStoreService;
import haveno.network.p2p.storage.persistence.ProtectedDataStoreService;
import haveno.network.p2p.storage.persistence.RemovedPayloadsService;
import haveno.network.p2p.storage.persistence.ResourceDataStoreService;
import haveno.network.p2p.storage.persistence.SequenceNumberMap;
import java.security.KeyPair;
import java.security.PublicKey;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleBooleanProperty;
import javax.annotation.Nullable;
import org.bitcoinj.core.Utils;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.StoragePayload;

public class P2PDataStorage
implements MessageListener,
ConnectionListener,
PersistedDataHost {
    private static final Logger log = LoggerFactory.getLogger(P2PDataStorage.class);
    @VisibleForTesting
    public static final int PURGE_AGE_DAYS = 10;
    @VisibleForTesting
    public static final int CHECK_TTL_INTERVAL_SEC = 60;
    private boolean initialRequestApplied = false;
    private final Broadcaster broadcaster;
    @VisibleForTesting
    final AppendOnlyDataStoreService appendOnlyDataStoreService;
    private final ProtectedDataStoreService protectedDataStoreService;
    private final ResourceDataStoreService resourceDataStoreService;
    private final Map<ByteArray, ProtectedStorageEntry> map = new ConcurrentHashMap<ByteArray, ProtectedStorageEntry>();
    private final Set<HashMapChangedListener> hashMapChangedListeners = new CopyOnWriteArraySet<HashMapChangedListener>();
    private Timer removeExpiredEntriesTimer;
    private final PersistenceManager<SequenceNumberMap> persistenceManager;
    @VisibleForTesting
    final SequenceNumberMap sequenceNumberMap = new SequenceNumberMap();
    private final Set<AppendOnlyDataStoreListener> appendOnlyDataStoreListeners = new CopyOnWriteArraySet<AppendOnlyDataStoreListener>();
    private final RemovedPayloadsService removedPayloadsService;
    private final Clock clock;
    private final int maxSequenceNumberMapSizeBeforePurge;
    private MonadicBinding<Boolean> readFromResourcesCompleteBinding;
    private Predicate<ProtectedStoragePayload> filterPredicate;

    @Inject
    public P2PDataStorage(NetworkNode networkNode, Broadcaster broadcaster, AppendOnlyDataStoreService appendOnlyDataStoreService, ProtectedDataStoreService protectedDataStoreService, ResourceDataStoreService resourceDataStoreService, PersistenceManager<SequenceNumberMap> persistenceManager, RemovedPayloadsService removedPayloadsService, Clock clock, @Named(value="MAX_SEQUENCE_NUMBER_MAP_SIZE_BEFORE_PURGE") int maxSequenceNumberBeforePurge) {
        this.broadcaster = broadcaster;
        this.appendOnlyDataStoreService = appendOnlyDataStoreService;
        this.protectedDataStoreService = protectedDataStoreService;
        this.resourceDataStoreService = resourceDataStoreService;
        this.persistenceManager = persistenceManager;
        this.removedPayloadsService = removedPayloadsService;
        this.clock = clock;
        this.maxSequenceNumberMapSizeBeforePurge = maxSequenceNumberBeforePurge;
        networkNode.addMessageListener(this);
        networkNode.addConnectionListener(this);
        this.persistenceManager.initialize(this.sequenceNumberMap, PersistenceManager.Source.PRIVATE_LOW_PRIO);
    }

    @Override
    public void readPersisted(Runnable completeHandler) {
        this.persistenceManager.readPersisted(persisted -> {
            Map<ByteArray, MapValue> map = persisted.getMap();
            synchronized (map) {
                this.sequenceNumberMap.setMap(this.getPurgedSequenceNumberMap(persisted.getMap()));
            }
            completeHandler.run();
        }, completeHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void readPersistedSync() {
        SequenceNumberMap persisted = this.persistenceManager.getPersisted();
        if (persisted != null) {
            Map<ByteArray, MapValue> map = persisted.getMap();
            synchronized (map) {
                this.sequenceNumberMap.setMap(this.getPurgedSequenceNumberMap(persisted.getMap()));
            }
        }
    }

    public void readFromResources(String postFix, Runnable completeHandler) {
        SimpleBooleanProperty appendOnlyDataStoreServiceReady = new SimpleBooleanProperty();
        SimpleBooleanProperty protectedDataStoreServiceReady = new SimpleBooleanProperty();
        SimpleBooleanProperty resourceDataStoreServiceReady = new SimpleBooleanProperty();
        this.readFromResourcesCompleteBinding = EasyBind.combine(appendOnlyDataStoreServiceReady, protectedDataStoreServiceReady, resourceDataStoreServiceReady, (a, b, c) -> a != false && b != false && c != false);
        this.readFromResourcesCompleteBinding.subscribe((observable2, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                completeHandler.run();
            }
        });
        this.appendOnlyDataStoreService.readFromResources(postFix, () -> appendOnlyDataStoreServiceReady.set(true));
        this.protectedDataStoreService.readFromResources(postFix, () -> {
            Map<ByteArray, ProtectedStorageEntry> map = this.map;
            synchronized (map) {
                this.map.putAll(this.protectedDataStoreService.getMap());
                protectedDataStoreServiceReady.set(true);
            }
        });
        this.resourceDataStoreService.readFromResources(postFix, () -> resourceDataStoreServiceReady.set(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void readFromResourcesSync(String postFix) {
        Map<ByteArray, ProtectedStorageEntry> map = this.map;
        synchronized (map) {
            this.appendOnlyDataStoreService.readFromResourcesSync(postFix);
            this.protectedDataStoreService.readFromResourcesSync(postFix);
            this.resourceDataStoreService.readFromResourcesSync(postFix);
            this.map.putAll(this.protectedDataStoreService.getMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProtectedMailboxStorageEntryToMap(ProtectedStorageEntry protectedStorageEntry) {
        Map<ByteArray, ProtectedStorageEntry> map = this.map;
        synchronized (map) {
            ProtectedStoragePayload protectedStoragePayload = protectedStorageEntry.getProtectedStoragePayload();
            ByteArray hashOfPayload = P2PDataStorage.get32ByteHashAsByteArray(protectedStoragePayload);
            this.map.put(hashOfPayload, protectedStorageEntry);
        }
    }

    public PreliminaryGetDataRequest buildPreliminaryGetDataRequest(int nonce) {
        return new PreliminaryGetDataRequest(nonce, this.getKnownPayloadHashes());
    }

    public GetUpdatedDataRequest buildGetUpdatedDataRequest(NodeAddress senderNodeAddress, int nonce) {
        return new GetUpdatedDataRequest(senderNodeAddress, nonce, this.getKnownPayloadHashes());
    }

    private Set<byte[]> getKnownPayloadHashes() {
        Map<ByteArray, PersistableNetworkPayload> mapForDataRequest = this.getMapForDataRequest();
        Set<byte[]> excludedKeys = this.getKeysAsByteSet(mapForDataRequest);
        Set<byte[]> excludedKeysFromProtectedStorageEntryMap = this.getKeysAsByteSet(this.map);
        excludedKeys.addAll(excludedKeysFromProtectedStorageEntryMap);
        return excludedKeys;
    }

    public GetDataResponse buildGetDataResponse(GetDataRequest getDataRequest, int maxEntriesPerType, AtomicBoolean wasPersistableNetworkPayloadsTruncated, AtomicBoolean wasProtectedStorageEntriesTruncated, Capabilities peerCapabilities) {
        Set<ByteArray> excludedKeysAsByteArray = ByteArray.convertBytesSetToByteArraySet(getDataRequest.getExcludedKeys());
        Map<ByteArray, PersistableNetworkPayload> mapForDataResponse = this.getMapForDataResponse(getDataRequest.getVersion());
        double maxSize = (double)Connection.getMaxPermittedMessageSize() * 0.6;
        long limit = Math.round(maxSize * 0.25);
        Set<PersistableNetworkPayload> filteredPersistableNetworkPayloads = P2PDataStorage.filterKnownHashes(mapForDataResponse, Function.identity(), excludedKeysAsByteArray, peerCapabilities, maxEntriesPerType, limit, wasPersistableNetworkPayloadsTruncated, true);
        log.info("{} PersistableNetworkPayload entries remained after filtered by excluded keys. Original map had {} entries.", (Object)filteredPersistableNetworkPayloads.size(), (Object)mapForDataResponse.size());
        log.trace("## buildGetDataResponse filteredPersistableNetworkPayloadHashes={}", filteredPersistableNetworkPayloads.stream().map(e -> Utilities.encodeToHex(e.getHash())).toArray());
        limit = Math.round(maxSize * 0.75);
        Set<ProtectedStorageEntry> filteredProtectedStorageEntries = P2PDataStorage.filterKnownHashes(this.map, ProtectedStorageEntry::getProtectedStoragePayload, excludedKeysAsByteArray, peerCapabilities, maxEntriesPerType, limit, wasProtectedStorageEntriesTruncated, false);
        log.info("{} ProtectedStorageEntry entries remained after filtered by excluded keys. Original map had {} entries.", (Object)filteredProtectedStorageEntries.size(), (Object)this.map.size());
        log.trace("## buildGetDataResponse filteredProtectedStorageEntryHashes={}", filteredProtectedStorageEntries.stream().map(e -> P2PDataStorage.get32ByteHashAsByteArray(e.getProtectedStoragePayload())).toArray());
        boolean wasTruncated = wasPersistableNetworkPayloadsTruncated.get() || wasProtectedStorageEntriesTruncated.get();
        return new GetDataResponse(filteredProtectedStorageEntries, filteredPersistableNetworkPayloads, getDataRequest.getNonce(), getDataRequest instanceof GetUpdatedDataRequest, wasTruncated);
    }

    private Map<ByteArray, PersistableNetworkPayload> getMapForDataRequest() {
        HashMap<ByteArray, PersistableNetworkPayload> map = new HashMap<ByteArray, PersistableNetworkPayload>();
        this.appendOnlyDataStoreService.getServices().forEach(service -> {
            Map<ByteArray, Object> serviceMap;
            if (service instanceof HistoricalDataStoreService) {
                HistoricalDataStoreService historicalDataStoreService = (HistoricalDataStoreService)service;
                serviceMap = historicalDataStoreService.getMapOfLiveData();
            } else {
                serviceMap = service.getMap();
            }
            map.putAll(serviceMap);
            log.debug("We added {} entries from {} to the excluded key set of our request", (Object)serviceMap.size(), (Object)service.getClass().getSimpleName());
        });
        return map;
    }

    public Map<ByteArray, PersistableNetworkPayload> getMapForDataResponse(String requestersVersion) {
        HashMap<ByteArray, PersistableNetworkPayload> map = new HashMap<ByteArray, PersistableNetworkPayload>();
        this.appendOnlyDataStoreService.getServices().forEach(service -> {
            Map<ByteArray, Object> serviceMap;
            if (service instanceof HistoricalDataStoreService) {
                HistoricalDataStoreService historicalDataStoreService = (HistoricalDataStoreService)service;
                serviceMap = historicalDataStoreService.getMapSinceVersion(requestersVersion);
            } else {
                serviceMap = service.getMap();
            }
            map.putAll(serviceMap);
            log.info("We added {} entries from {} to be filtered by excluded keys", (Object)serviceMap.size(), (Object)service.getClass().getSimpleName());
        });
        return map;
    }

    private static <T extends NetworkPayload> Set<T> filterKnownHashes(Map<ByteArray, T> toFilter, Function<T, ? extends NetworkPayload> asPayload, Set<ByteArray> knownHashes, Capabilities peerCapabilities, int maxEntries, long limit, AtomicBoolean outTruncated, boolean isPersistableNetworkPayload) {
        log.info("Filter {} data based on {} knownHashes", (Object)(isPersistableNetworkPayload ? "PersistableNetworkPayload" : "ProtectedStorageEntry"), (Object)knownHashes.size());
        AtomicLong totalSize = new AtomicLong();
        AtomicBoolean exceededSizeLimit = new AtomicBoolean();
        Set<Map.Entry<ByteArray, Map.Entry>> entries = toFilter.entrySet();
        HashMap numItemsByClassName = new HashMap();
        entries.forEach(entry -> {
            String name = ((NetworkPayload)asPayload.apply((NetworkPayload)entry.getValue())).getClass().getSimpleName();
            numItemsByClassName.putIfAbsent(name, new AtomicInteger());
            ((AtomicInteger)numItemsByClassName.get(name)).incrementAndGet();
        });
        log.info("numItemsByClassName: {}", (Object)numItemsByClassName);
        List filteredItems = entries.stream().filter(entry -> !knownHashes.contains(entry.getKey())).map(Map.Entry::getValue).filter(item -> P2PDataStorage.shouldTransmitPayloadToPeer(peerCapabilities, (NetworkPayload)asPayload.apply((NetworkPayload)item))).collect(Collectors.toList());
        List resultItems = new ArrayList();
        List midPrioItems = filteredItems.stream().filter(item -> item.getGetDataResponsePriority() == GetDataResponsePriority.MID).collect(Collectors.toList());
        resultItems.addAll(midPrioItems);
        log.info("Number of items with GetDataResponsePriority.MID: {}", (Object)midPrioItems.size());
        List lowPrioItems = filteredItems.stream().filter(item -> item.getGetDataResponsePriority() == GetDataResponsePriority.LOW).filter(item -> !(asPayload.apply((NetworkPayload)item) instanceof DateSortedTruncatablePayload)).filter(item -> {
            if (exceededSizeLimit.get()) {
                return false;
            }
            if (totalSize.addAndGet(item.toProtoMessage().getSerializedSize()) > limit) {
                exceededSizeLimit.set(true);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        resultItems.addAll(lowPrioItems);
        log.info("Number of items with GetDataResponsePriority.LOW and !DateSortedTruncatablePayload: {}. Exceeded size limit: {}", (Object)lowPrioItems.size(), (Object)exceededSizeLimit.get());
        if (!exceededSizeLimit.get()) {
            List dateSortedItems = filteredItems.stream().filter(item -> item.getGetDataResponsePriority() == GetDataResponsePriority.LOW).filter(item -> asPayload.apply((NetworkPayload)item) instanceof DateSortedTruncatablePayload).filter(item -> {
                if (exceededSizeLimit.get()) {
                    return false;
                }
                if (totalSize.addAndGet(item.toProtoMessage().getSerializedSize()) > limit) {
                    exceededSizeLimit.set(true);
                    return false;
                }
                return true;
            }).sorted(Comparator.comparing(item -> ((DateSortedTruncatablePayload)asPayload.apply((NetworkPayload)item)).getDate())).collect(Collectors.toList());
            if (!dateSortedItems.isEmpty()) {
                int maxItems = ((DateSortedTruncatablePayload)asPayload.apply((NetworkPayload)dateSortedItems.get(0))).maxItems();
                int size = dateSortedItems.size();
                if (size > maxItems) {
                    int fromIndex = size - maxItems;
                    dateSortedItems = dateSortedItems.subList(fromIndex, size);
                    outTruncated.set(true);
                    log.info("Num truncated dateSortedItems {}", (Object)size);
                    log.info("Removed oldest {} dateSortedItems as we exceeded {}", (Object)fromIndex, (Object)maxItems);
                }
            }
            log.info("Number of items with GetDataResponsePriority.LOW and DateSortedTruncatablePayload: {}. Was truncated: {}", (Object)dateSortedItems.size(), (Object)outTruncated.get());
            Comparator<NetworkPayload> comparator = Comparator.comparing(item -> ((DateSortedTruncatablePayload)asPayload.apply((NetworkPayload)item)).getDate());
            dateSortedItems.sort(comparator.reversed());
            resultItems.addAll(dateSortedItems);
        } else {
            log.info("No dateSortedItems added as we exceeded already the exceededSizeLimit of {}", (Object)limit);
        }
        int size = resultItems.size();
        if (size > maxEntries) {
            resultItems = resultItems.subList(0, maxEntries);
            outTruncated.set(true);
            log.info("Removed last {} items as we exceeded {}", (Object)(size - maxEntries), (Object)maxEntries);
        }
        outTruncated.set(outTruncated.get() || exceededSizeLimit.get());
        List highPrioItems = filteredItems.stream().filter(item -> item.getGetDataResponsePriority() == GetDataResponsePriority.HIGH).collect(Collectors.toList());
        resultItems.addAll(highPrioItems);
        log.info("Number of items with GetDataResponsePriority.HIGH: {}", (Object)highPrioItems.size());
        log.info("Number of result items we send to requester: {}", (Object)resultItems.size());
        return new HashSet(resultItems);
    }

    public Collection<PersistableNetworkPayload> getPersistableNetworkPayloadCollection() {
        return this.getMapForDataRequest().values();
    }

    private Set<byte[]> getKeysAsByteSet(Map<ByteArray, ? extends PersistablePayload> map) {
        return map.keySet().stream().map(e -> e.bytes).collect(Collectors.toSet());
    }

    private static boolean shouldTransmitPayloadToPeer(Capabilities peerCapabilities, NetworkPayload payload) {
        if (!(payload instanceof ProtectedStoragePayload) && !(payload instanceof PersistableNetworkPayload)) {
            return false;
        }
        if (!(payload instanceof CapabilityRequiringPayload)) {
            return true;
        }
        boolean shouldTransmit = peerCapabilities.containsAll(((CapabilityRequiringPayload)payload).getRequiredCapabilities());
        if (!shouldTransmit) {
            log.debug("We do not send the message to the peer because they do not support the required capability for that message type.\nstoragePayload is: " + Utilities.toTruncatedString(payload));
        }
        return shouldTransmit;
    }

    public void processGetDataResponse(GetDataResponse getDataResponse, NodeAddress sender) {
        Set<ProtectedStorageEntry> protectedStorageEntries = getDataResponse.getDataSet();
        Set<PersistableNetworkPayload> persistableNetworkPayloadSet = getDataResponse.getPersistableNetworkPayloadSet();
        long ts = System.currentTimeMillis();
        protectedStorageEntries.forEach(protectedStorageEntry -> {
            if (protectedStorageEntry.getProtectedStoragePayload().getGetDataResponsePriority() == GetDataResponsePriority.HIGH) {
                UserThread.runAfter(() -> {
                    log.info("Rebroadcast {}", (Object)protectedStorageEntry.getProtectedStoragePayload().getClass().getSimpleName());
                    this.broadcaster.broadcast(new AddDataMessage((ProtectedStorageEntry)protectedStorageEntry), sender, null);
                }, 60L);
            }
            this.addProtectedStorageEntry((ProtectedStorageEntry)protectedStorageEntry, sender, null, false);
        });
        log.info("Processing {} protectedStorageEntries took {} ms.", (Object)protectedStorageEntries.size(), (Object)(this.clock.millis() - ts));
        ts = this.clock.millis();
        persistableNetworkPayloadSet.forEach(e -> {
            if (e instanceof ProcessOncePersistableNetworkPayload) {
                if (!this.initialRequestApplied || getDataResponse.isWasTruncated()) {
                    this.addPersistableNetworkPayloadFromInitialRequest((PersistableNetworkPayload)e);
                }
            } else {
                this.addPersistableNetworkPayload((PersistableNetworkPayload)e, sender, false, false, false);
            }
        });
        log.info("Processing {} persistableNetworkPayloads took {} ms.", (Object)persistableNetworkPayloadSet.size(), (Object)(this.clock.millis() - ts));
        this.initialRequestApplied = true;
    }

    public void shutDown() {
        if (this.removeExpiredEntriesTimer != null) {
            this.removeExpiredEntriesTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void removeExpiredEntries() {
        Map<ByteArray, ProtectedStorageEntry> map = this.map;
        synchronized (map) {
            ArrayList toRemoveList = this.map.entrySet().stream().filter(entry -> ((ProtectedStorageEntry)entry.getValue()).isExpired(this.clock)).collect(Collectors.toCollection(ArrayList::new));
            if (log.isDebugEnabled()) {
                toRemoveList.forEach(toRemoveItem -> log.debug("We found an expired data entry. We remove the protectedData:\n\t{}", (Object)Utilities.toTruncatedString(toRemoveItem.getValue())));
            }
            this.removeFromMapAndDataStore(toRemoveList);
            Map<ByteArray, MapValue> map2 = this.sequenceNumberMap.getMap();
            synchronized (map2) {
                if (this.sequenceNumberMap.size() > this.maxSequenceNumberMapSizeBeforePurge) {
                    this.sequenceNumberMap.setMap(this.getPurgedSequenceNumberMap(this.sequenceNumberMap.getMap()));
                    this.requestPersistence();
                }
            }
        }
    }

    public void onBootstrapped() {
        this.removeExpiredEntriesTimer = UserThread.runPeriodically(this::removeExpiredEntries, 60L);
    }

    @Override
    public void onMessage(NetworkEnvelope networkEnvelope, Connection connection) {
        if (networkEnvelope instanceof BroadcastMessage) {
            connection.getPeersNodeAddressOptional().ifPresent(peersNodeAddress -> {
                if (networkEnvelope instanceof AddDataMessage) {
                    this.addProtectedStorageEntry(((AddDataMessage)networkEnvelope).getProtectedStorageEntry(), (NodeAddress)peersNodeAddress, null, true);
                } else if (networkEnvelope instanceof RemoveDataMessage) {
                    this.remove(((RemoveDataMessage)networkEnvelope).getProtectedStorageEntry(), (NodeAddress)peersNodeAddress);
                } else if (networkEnvelope instanceof RemoveMailboxDataMessage) {
                    this.remove(((RemoveMailboxDataMessage)networkEnvelope).getProtectedMailboxStorageEntry(), (NodeAddress)peersNodeAddress);
                } else if (networkEnvelope instanceof RefreshOfferMessage) {
                    this.refreshTTL((RefreshOfferMessage)networkEnvelope, (NodeAddress)peersNodeAddress);
                } else if (networkEnvelope instanceof AddPersistableNetworkPayloadMessage) {
                    this.addPersistableNetworkPayload(((AddPersistableNetworkPayloadMessage)networkEnvelope).getPersistableNetworkPayload(), (NodeAddress)peersNodeAddress, true, false, true);
                }
            });
        }
    }

    @Override
    public void onConnection(Connection connection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnect(CloseConnectionReason closeConnectionReason, Connection connection) {
        if (closeConnectionReason.isIntended) {
            return;
        }
        if (!connection.getPeersNodeAddressOptional().isPresent()) {
            return;
        }
        NodeAddress peersNodeAddress = connection.getPeersNodeAddressOptional().get();
        Map<ByteArray, ProtectedStorageEntry> map = this.map;
        synchronized (map) {
            this.map.values().stream().filter(protectedStorageEntry -> protectedStorageEntry.getProtectedStoragePayload() instanceof RequiresOwnerIsOnlinePayload).filter(protectedStorageEntry -> ((RequiresOwnerIsOnlinePayload)((Object)protectedStorageEntry.getProtectedStoragePayload())).getOwnerNodeAddress().equals(peersNodeAddress)).forEach(protectedStorageEntry -> {
                log.debug("Backdating {} due to closeConnectionReason={}", protectedStorageEntry, (Object)closeConnectionReason);
                protectedStorageEntry.backDate();
            });
        }
    }

    public boolean addPersistableNetworkPayload(PersistableNetworkPayload payload, @Nullable NodeAddress sender, boolean allowReBroadcast) {
        return this.addPersistableNetworkPayload(payload, sender, true, allowReBroadcast, false);
    }

    private boolean addPersistableNetworkPayload(PersistableNetworkPayload payload, @Nullable NodeAddress sender, boolean allowBroadcast, boolean reBroadcast, boolean checkDate) {
        log.debug("addPersistableNetworkPayload payload={}", (Object)payload);
        if (!payload.verifyHashSize()) {
            log.warn("addPersistableNetworkPayload failed due to unexpected hash size");
            return false;
        }
        ByteArray hashAsByteArray = new ByteArray(payload.getHash());
        boolean payloadHashAlreadyInStore = this.appendOnlyDataStoreService.getMap(payload).containsKey(hashAsByteArray);
        if (payloadHashAlreadyInStore && !reBroadcast) {
            log.debug("addPersistableNetworkPayload failed due to duplicate payload");
            return false;
        }
        if (checkDate && payload instanceof DateTolerantPayload && !((DateTolerantPayload)payload).isDateInTolerance(this.clock)) {
            log.warn("addPersistableNetworkPayload failed due to payload time outside tolerance.\nPayload={}; now={}", (Object)payload.toString(), (Object)new Date());
            return false;
        }
        boolean wasAdded = false;
        if (!payloadHashAlreadyInStore && (wasAdded = this.appendOnlyDataStoreService.put(hashAsByteArray, payload))) {
            this.appendOnlyDataStoreListeners.forEach(e -> e.onAdded(payload));
        }
        if (allowBroadcast && wasAdded) {
            this.broadcaster.broadcast(new AddPersistableNetworkPayloadMessage(payload), sender);
        }
        return true;
    }

    private void addPersistableNetworkPayloadFromInitialRequest(PersistableNetworkPayload payload) {
        byte[] hash = payload.getHash();
        if (payload.verifyHashSize()) {
            ByteArray hashAsByteArray = new ByteArray(hash);
            this.appendOnlyDataStoreService.put(hashAsByteArray, payload);
        } else {
            log.warn("We got a hash exceeding our permitted size");
        }
    }

    public boolean addProtectedStorageEntry(ProtectedStorageEntry protectedStorageEntry, @Nullable NodeAddress sender, @Nullable BroadcastHandler.Listener listener) {
        return this.addProtectedStorageEntry(protectedStorageEntry, sender, listener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addProtectedStorageEntry(ProtectedStorageEntry protectedStorageEntry, @Nullable NodeAddress sender, @Nullable BroadcastHandler.Listener listener, boolean allowBroadcast) {
        Map<ByteArray, ProtectedStorageEntry> map = this.map;
        synchronized (map) {
            ProtectedStoragePayload protectedStoragePayload = protectedStorageEntry.getProtectedStoragePayload();
            ByteArray hashOfPayload = P2PDataStorage.get32ByteHashAsByteArray(protectedStoragePayload);
            ProtectedStorageEntry storedEntry = this.map.get(hashOfPayload);
            if (storedEntry != null && !this.hasSequenceNrIncreased(protectedStorageEntry.getSequenceNumber(), hashOfPayload)) {
                log.trace("## hasSequenceNrIncreased is false. hash={}", (Object)hashOfPayload);
                return false;
            }
            if (this.hasAlreadyRemovedAddOncePayload(protectedStoragePayload, hashOfPayload)) {
                log.trace("## We have already removed that AddOncePayload by a previous removeDataMessage. We ignore that message. ProtectedStoragePayload: {}", (Object)protectedStoragePayload.toString());
                return false;
            }
            if (protectedStorageEntry.isExpired(this.clock)) {
                String peer = sender != null ? sender.getFullAddress() : "sender is null";
                log.trace("## We received an expired protectedStorageEntry from peer {}. ProtectedStoragePayload={}", (Object)peer, (Object)protectedStorageEntry.getProtectedStoragePayload().getClass().getSimpleName());
                return false;
            }
            MapValue sequenceNumberMapValue = this.sequenceNumberMap.get(hashOfPayload);
            if (sequenceNumberMapValue != null && protectedStorageEntry.getSequenceNumber() < sequenceNumberMapValue.sequenceNr) {
                log.trace("## sequenceNr too low hash={}", (Object)hashOfPayload);
                return false;
            }
            if (!protectedStorageEntry.isValidForAddOperation()) {
                log.trace("## !isValidForAddOperation hash={}", (Object)hashOfPayload);
                return false;
            }
            if (storedEntry != null && !protectedStorageEntry.matchesRelevantPubKey(storedEntry)) {
                log.trace("## !matchesRelevantPubKey hash={}", (Object)hashOfPayload);
                return false;
            }
            if (this.filterPredicate != null && !this.filterPredicate.test(protectedStorageEntry.getProtectedStoragePayload())) {
                log.debug("filterPredicate test failed. hashOfPayload={}", (Object)hashOfPayload);
                return false;
            }
            this.map.put(hashOfPayload, protectedStorageEntry);
            this.hashMapChangedListeners.forEach(e -> e.onAdded(Collections.singletonList(protectedStorageEntry)));
            this.sequenceNumberMap.put(hashOfPayload, new MapValue(protectedStorageEntry.getSequenceNumber(), this.clock.millis()));
            this.requestPersistence();
            if (allowBroadcast) {
                this.broadcaster.broadcast(new AddDataMessage(protectedStorageEntry), sender, listener);
                log.trace("## broadcasted ProtectedStorageEntry. hash={}", (Object)hashOfPayload);
            }
            if (protectedStoragePayload instanceof PersistablePayload) {
                this.protectedDataStoreService.put(hashOfPayload, protectedStorageEntry);
            }
            return true;
        }
    }

    public void republishExistingProtectedMailboxStorageEntry(ProtectedMailboxStorageEntry protectedMailboxStorageEntry, @Nullable NodeAddress sender, @Nullable BroadcastHandler.Listener listener) {
        ByteArray hashOfPayload;
        ProtectedStoragePayload protectedStoragePayload = protectedMailboxStorageEntry.getProtectedStoragePayload();
        if (this.hasAlreadyRemovedAddOncePayload(protectedStoragePayload, hashOfPayload = P2PDataStorage.get32ByteHashAsByteArray(protectedStoragePayload))) {
            log.trace("## We have already removed that AddOncePayload by a previous removeDataMessage. We ignore that message. ProtectedStoragePayload: {}", (Object)protectedStoragePayload.toString());
            return;
        }
        this.broadcaster.broadcast(new AddDataMessage(protectedMailboxStorageEntry), sender, listener);
        log.trace("## broadcasted ProtectedStorageEntry. hash={}", (Object)hashOfPayload);
    }

    public boolean hasAlreadyRemovedAddOncePayload(ProtectedStoragePayload protectedStoragePayload, ByteArray hashOfPayload) {
        return protectedStoragePayload instanceof AddOncePayload && this.removedPayloadsService.wasRemoved(hashOfPayload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshTTL(RefreshOfferMessage refreshTTLMessage, @Nullable NodeAddress sender) {
        Map<ByteArray, ProtectedStorageEntry> map = this.map;
        synchronized (map) {
            try {
                ByteArray hashOfPayload = new ByteArray(refreshTTLMessage.getHashOfPayload());
                ProtectedStorageEntry storedData = this.map.get(hashOfPayload);
                if (storedData == null) {
                    log.debug("We don't have data for that refresh message in our map. That is expected if we missed the data publishing.");
                    return false;
                }
                ProtectedStorageEntry storedEntry = this.map.get(hashOfPayload);
                ProtectedStorageEntry updatedEntry = new ProtectedStorageEntry(storedEntry.getProtectedStoragePayload(), storedEntry.getOwnerPubKey(), refreshTTLMessage.getSequenceNumber(), refreshTTLMessage.getSignature(), this.clock);
                if (!this.hasSequenceNrIncreased(updatedEntry.getSequenceNumber(), hashOfPayload)) {
                    return false;
                }
                if (!updatedEntry.isValidForAddOperation()) {
                    return false;
                }
                this.map.put(hashOfPayload, updatedEntry);
                this.sequenceNumberMap.put(hashOfPayload, new MapValue(updatedEntry.getSequenceNumber(), this.clock.millis()));
                this.requestPersistence();
                this.broadcaster.broadcast(refreshTTLMessage, sender);
            }
            catch (IllegalArgumentException e) {
                log.error("refreshTTL failed, missing data: {}\n", (Object)e.toString(), (Object)e);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ProtectedStorageEntry protectedStorageEntry, @Nullable NodeAddress sender) {
        Map<ByteArray, ProtectedStorageEntry> map = this.map;
        synchronized (map) {
            ProtectedStoragePayload protectedStoragePayload = protectedStorageEntry.getProtectedStoragePayload();
            ByteArray hashOfPayload = P2PDataStorage.get32ByteHashAsByteArray(protectedStoragePayload);
            if (!this.hasSequenceNrIncreased(protectedStorageEntry.getSequenceNumber(), hashOfPayload)) {
                return false;
            }
            if (!protectedStorageEntry.isValidForRemoveOperation()) {
                return false;
            }
            ProtectedStorageEntry storedEntry = this.map.get(hashOfPayload);
            if (storedEntry != null && !protectedStorageEntry.matchesRelevantPubKey(storedEntry)) {
                return false;
            }
            this.sequenceNumberMap.put(hashOfPayload, new MapValue(protectedStorageEntry.getSequenceNumber(), this.clock.millis()));
            this.requestPersistence();
            if (protectedStoragePayload instanceof AddOncePayload) {
                this.removedPayloadsService.addHash(hashOfPayload);
            }
            if (storedEntry != null) {
                this.removeFromMapAndDataStore(protectedStorageEntry, hashOfPayload);
            }
            this.printData("after remove");
            if (protectedStorageEntry instanceof ProtectedMailboxStorageEntry) {
                this.broadcaster.broadcast(new RemoveMailboxDataMessage((ProtectedMailboxStorageEntry)protectedStorageEntry), sender);
            } else {
                this.broadcaster.broadcast(new RemoveDataMessage(protectedStorageEntry), sender);
            }
            return true;
        }
    }

    public ProtectedStorageEntry getProtectedStorageEntry(ProtectedStoragePayload protectedStoragePayload, KeyPair ownerStoragePubKey) throws CryptoException {
        ByteArray hashOfData = P2PDataStorage.get32ByteHashAsByteArray(protectedStoragePayload);
        int sequenceNumber = this.sequenceNumberMap.containsKey(hashOfData) ? this.sequenceNumberMap.get((ByteArray)hashOfData).sequenceNr + 1 : 1;
        byte[] hashOfDataAndSeqNr = P2PDataStorage.get32ByteHash(new DataAndSeqNrPair(protectedStoragePayload, sequenceNumber));
        byte[] signature = Sig.sign(ownerStoragePubKey.getPrivate(), hashOfDataAndSeqNr);
        return new ProtectedStorageEntry(protectedStoragePayload, ownerStoragePubKey.getPublic(), sequenceNumber, signature, this.clock);
    }

    public RefreshOfferMessage getRefreshTTLMessage(ProtectedStoragePayload protectedStoragePayload, KeyPair ownerStoragePubKey) throws CryptoException {
        ByteArray hashOfPayload = P2PDataStorage.get32ByteHashAsByteArray(protectedStoragePayload);
        int sequenceNumber = this.sequenceNumberMap.containsKey(hashOfPayload) ? this.sequenceNumberMap.get((ByteArray)hashOfPayload).sequenceNr + 1 : 1;
        byte[] hashOfDataAndSeqNr = P2PDataStorage.get32ByteHash(new DataAndSeqNrPair(protectedStoragePayload, sequenceNumber));
        byte[] signature = Sig.sign(ownerStoragePubKey.getPrivate(), hashOfDataAndSeqNr);
        return new RefreshOfferMessage(hashOfDataAndSeqNr, signature, hashOfPayload.bytes, sequenceNumber);
    }

    public ProtectedMailboxStorageEntry getMailboxDataWithSignedSeqNr(MailboxStoragePayload expirableMailboxStoragePayload, KeyPair storageSignaturePubKey, PublicKey receiversPublicKey) throws CryptoException {
        ByteArray hashOfData = P2PDataStorage.get32ByteHashAsByteArray(expirableMailboxStoragePayload);
        int sequenceNumber = this.sequenceNumberMap.containsKey(hashOfData) ? this.sequenceNumberMap.get((ByteArray)hashOfData).sequenceNr + 1 : 1;
        byte[] hashOfDataAndSeqNr = P2PDataStorage.get32ByteHash(new DataAndSeqNrPair(expirableMailboxStoragePayload, sequenceNumber));
        byte[] signature = Sig.sign(storageSignaturePubKey.getPrivate(), hashOfDataAndSeqNr);
        return new ProtectedMailboxStorageEntry(expirableMailboxStoragePayload, storageSignaturePubKey.getPublic(), sequenceNumber, signature, receiversPublicKey, this.clock);
    }

    public void addHashMapChangedListener(HashMapChangedListener hashMapChangedListener) {
        this.hashMapChangedListeners.add(hashMapChangedListener);
    }

    public void removeHashMapChangedListener(HashMapChangedListener hashMapChangedListener) {
        this.hashMapChangedListeners.remove(hashMapChangedListener);
    }

    public void addAppendOnlyDataStoreListener(AppendOnlyDataStoreListener listener) {
        this.appendOnlyDataStoreListeners.add(listener);
    }

    public void removeAppendOnlyDataStoreListener(AppendOnlyDataStoreListener listener) {
        this.appendOnlyDataStoreListeners.remove(listener);
    }

    private void removeFromMapAndDataStore(ProtectedStorageEntry protectedStorageEntry, ByteArray hashOfPayload) {
        this.removeFromMapAndDataStore(Collections.singletonList(Maps.immutableEntry(hashOfPayload, protectedStorageEntry)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMapAndDataStore(Collection<Map.Entry<ByteArray, ProtectedStorageEntry>> entriesToRemove) {
        Map<ByteArray, ProtectedStorageEntry> map = this.map;
        synchronized (map) {
            if (entriesToRemove.isEmpty()) {
                return;
            }
            ArrayList removedProtectedStorageEntries = new ArrayList(entriesToRemove.size());
            entriesToRemove.forEach(entry -> {
                ProtectedStorageEntry previous;
                ByteArray hashOfPayload = (ByteArray)entry.getKey();
                ProtectedStorageEntry protectedStorageEntry = (ProtectedStorageEntry)entry.getValue();
                this.map.remove(hashOfPayload);
                removedProtectedStorageEntries.add(protectedStorageEntry);
                ProtectedStoragePayload protectedStoragePayload = protectedStorageEntry.getProtectedStoragePayload();
                if (protectedStoragePayload instanceof PersistablePayload && (previous = this.protectedDataStoreService.remove(hashOfPayload, protectedStorageEntry)) == null) {
                    log.warn("We cannot remove the protectedStorageEntry from the protectedDataStoreService as it does not exist.");
                }
            });
            this.hashMapChangedListeners.forEach(e -> e.onRemoved(removedProtectedStorageEntries));
        }
    }

    private boolean hasSequenceNrIncreased(int newSequenceNumber, ByteArray hashOfData) {
        if (this.sequenceNumberMap.containsKey(hashOfData)) {
            int storedSequenceNumber = this.sequenceNumberMap.get((ByteArray)hashOfData).sequenceNr;
            if (newSequenceNumber > storedSequenceNumber) {
                return true;
            }
            if (newSequenceNumber == storedSequenceNumber) {
                if (newSequenceNumber == 0) {
                    log.debug("Sequence number is equal to the stored one and both are 0.That is expected for network_messages which never got updated (mailbox msg).");
                } else {
                    log.debug("Sequence number is equal to the stored one. sequenceNumber = {} / storedSequenceNumber={}", (Object)newSequenceNumber, (Object)storedSequenceNumber);
                }
                return false;
            }
            log.debug("Sequence number is invalid. sequenceNumber = {} / storedSequenceNumber={} That can happen if the data owner gets an old delayed data storage message.", (Object)newSequenceNumber, (Object)storedSequenceNumber);
            return false;
        }
        return true;
    }

    private void requestPersistence() {
        this.persistenceManager.requestPersistence();
    }

    public static ByteArray get32ByteHashAsByteArray(NetworkPayload data) {
        return new ByteArray(P2PDataStorage.get32ByteHash(data));
    }

    private Map<ByteArray, MapValue> getPurgedSequenceNumberMap(Map<ByteArray, MapValue> persisted) {
        HashMap<ByteArray, MapValue> purged = new HashMap<ByteArray, MapValue>();
        long maxAgeTs = this.clock.millis() - TimeUnit.DAYS.toMillis(10L);
        persisted.forEach((key, value) -> {
            if (value.timeStamp > maxAgeTs) {
                purged.put((ByteArray)key, (MapValue)value);
            }
        });
        return purged;
    }

    private void printData(String info) {
        if (log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("\n\n------------------------------------------------------------\n");
            sb.append("Data set ").append(info).append(" operation");
            List<Tuple2> tempList = this.map.values().stream().map(e -> new Tuple2<String, ProtectedStorageEntry>(Utils.HEX.encode(P2PDataStorage.get32ByteHashAsByteArray((NetworkPayload)e.getProtectedStoragePayload()).bytes), (ProtectedStorageEntry)e)).sorted(Comparator.comparing(o -> (String)o.first)).collect(Collectors.toList());
            tempList.forEach(e -> {
                ProtectedStorageEntry storageEntry = (ProtectedStorageEntry)e.second;
                ProtectedStoragePayload protectedStoragePayload = storageEntry.getProtectedStoragePayload();
                MapValue mapValue = this.sequenceNumberMap.get(P2PDataStorage.get32ByteHashAsByteArray(protectedStoragePayload));
                sb.append("\n").append("Hash=").append((String)e.first).append("; Class=").append(protectedStoragePayload.getClass().getSimpleName()).append("; SequenceNumbers (Object/Stored)=").append(storageEntry.getSequenceNumber()).append(" / ").append(mapValue != null ? Integer.valueOf(mapValue.sequenceNr) : "null").append("; TimeStamp (Object/Stored)=").append(storageEntry.getCreationTimeStamp()).append(" / ").append(mapValue != null ? Long.valueOf(mapValue.timeStamp) : "null").append("; Payload=").append(Utilities.toTruncatedString(protectedStoragePayload));
            });
            sb.append("\n------------------------------------------------------------\n");
            log.debug(sb.toString());
        }
    }

    private String printMap() {
        return Arrays.toString(this.map.entrySet().stream().map(e -> Hex.encode(((ByteArray)e.getKey()).bytes) + ": " + ((ProtectedStorageEntry)e.getValue()).getProtectedStoragePayload().getClass().getSimpleName()).toArray());
    }

    private String printPersistableNetworkPayloadMap(Map<ByteArray, PersistableNetworkPayload> map) {
        return Arrays.toString(map.entrySet().stream().map(e -> Hex.encode(((ByteArray)e.getKey()).bytes) + ": " + ((PersistableNetworkPayload)e.getValue()).getClass().getSimpleName()).toArray());
    }

    public static byte[] get32ByteHash(NetworkPayload data) {
        return Hash.getSha256Hash(data.toProtoMessage().toByteArray());
    }

    public Map<ByteArray, ProtectedStorageEntry> getMap() {
        return this.map;
    }

    public void setFilterPredicate(Predicate<ProtectedStoragePayload> filterPredicate) {
        this.filterPredicate = filterPredicate;
    }

    public static final class ByteArray
    implements PersistablePayload {
        public final byte[] bytes;

        public ByteArray(byte[] bytes) {
            this.bytes = bytes;
            this.verifyBytesNotEmpty();
        }

        public void verifyBytesNotEmpty() {
            if (this.bytes == null) {
                throw new IllegalArgumentException("Cannot create P2PDataStorage.ByteArray with null byte[] array argument.");
            }
            if (this.bytes.length == 0) {
                throw new IllegalArgumentException("Cannot create P2PDataStorage.ByteArray with empty byte[] array argument.");
            }
        }

        public String toString() {
            return "ByteArray{bytes as Hex=" + Hex.encode(this.bytes) + "}";
        }

        @Override
        public protobuf.ByteArray toProtoMessage() {
            return protobuf.ByteArray.newBuilder().setBytes(ByteString.copyFrom(this.bytes)).build();
        }

        public static ByteArray fromProto(protobuf.ByteArray proto) {
            return new ByteArray(proto.getBytes().toByteArray());
        }

        public String getHex() {
            return Utilities.encodeToHex(this.bytes);
        }

        public static Set<ByteArray> convertBytesSetToByteArraySet(Set<byte[]> set) {
            return set != null ? set.stream().map(ByteArray::new).collect(Collectors.toSet()) : new HashSet<ByteArray>();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ByteArray)) {
                return false;
            }
            ByteArray other = (ByteArray)o;
            return Arrays.equals(this.bytes, other.bytes);
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.bytes);
            return result;
        }
    }

    public static final class MapValue
    implements PersistablePayload {
        public final int sequenceNr;
        public final long timeStamp;

        MapValue(int sequenceNr, long timeStamp) {
            this.sequenceNr = sequenceNr;
            this.timeStamp = timeStamp;
        }

        @Override
        public protobuf.MapValue toProtoMessage() {
            return protobuf.MapValue.newBuilder().setSequenceNr(this.sequenceNr).setTimeStamp(this.timeStamp).build();
        }

        public static MapValue fromProto(protobuf.MapValue proto) {
            return new MapValue(proto.getSequenceNr(), proto.getTimeStamp());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapValue)) {
                return false;
            }
            MapValue other = (MapValue)o;
            if (this.sequenceNr != other.sequenceNr) {
                return false;
            }
            return this.timeStamp == other.timeStamp;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.sequenceNr;
            long $timeStamp = this.timeStamp;
            result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
            return result;
        }

        public String toString() {
            return "P2PDataStorage.MapValue(sequenceNr=" + this.sequenceNr + ", timeStamp=" + this.timeStamp + ")";
        }
    }

    public static final class DataAndSeqNrPair
    implements NetworkPayload {
        private final ProtectedStoragePayload protectedStoragePayload;
        private final int sequenceNumber;

        public DataAndSeqNrPair(ProtectedStoragePayload protectedStoragePayload, int sequenceNumber) {
            this.protectedStoragePayload = protectedStoragePayload;
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public Message toProtoMessage() {
            return protobuf.DataAndSeqNrPair.newBuilder().setPayload((StoragePayload)this.protectedStoragePayload.toProtoMessage()).setSequenceNumber(this.sequenceNumber).build();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataAndSeqNrPair)) {
                return false;
            }
            DataAndSeqNrPair other = (DataAndSeqNrPair)o;
            if (this.sequenceNumber != other.sequenceNumber) {
                return false;
            }
            ProtectedStoragePayload this$protectedStoragePayload = this.protectedStoragePayload;
            ProtectedStoragePayload other$protectedStoragePayload = other.protectedStoragePayload;
            return !(this$protectedStoragePayload == null ? other$protectedStoragePayload != null : !this$protectedStoragePayload.equals(other$protectedStoragePayload));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.sequenceNumber;
            ProtectedStoragePayload $protectedStoragePayload = this.protectedStoragePayload;
            result = result * 59 + ($protectedStoragePayload == null ? 43 : $protectedStoragePayload.hashCode());
            return result;
        }

        public String toString() {
            return "P2PDataStorage.DataAndSeqNrPair(protectedStoragePayload=" + String.valueOf(this.protectedStoragePayload) + ", sequenceNumber=" + this.sequenceNumber + ")";
        }
    }
}

