/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.storage.payload;

import com.google.protobuf.ByteString;
import haveno.common.crypto.Sig;
import haveno.common.util.CollectionUtils;
import haveno.common.util.ExtraDataMapValidator;
import haveno.network.p2p.PrefixedSealedAndSignedMessage;
import haveno.network.p2p.storage.messages.AddOncePayload;
import haveno.network.p2p.storage.payload.ExpirablePayload;
import haveno.network.p2p.storage.payload.ProtectedStoragePayload;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.MailboxStoragePayload;
import protobuf.StoragePayload;

public final class MailboxStoragePayload
implements ProtectedStoragePayload,
ExpirablePayload,
AddOncePayload {
    private static final Logger log = LoggerFactory.getLogger(MailboxStoragePayload.class);
    public static final long TTL = TimeUnit.DAYS.toMillis(15L);
    public static final String EXTRA_MAP_KEY_TTL = "ttl";
    private final PrefixedSealedAndSignedMessage prefixedSealedAndSignedMessage;
    private PublicKey senderPubKeyForAddOperation;
    private final byte[] senderPubKeyForAddOperationBytes;
    private PublicKey ownerPubKey;
    private final byte[] ownerPubKeyBytes;
    @Nullable
    private Map<String, String> extraDataMap;

    public MailboxStoragePayload(PrefixedSealedAndSignedMessage prefixedSealedAndSignedMessage, @NotNull PublicKey senderPubKeyForAddOperation, PublicKey ownerPubKey, long ttl) {
        this.prefixedSealedAndSignedMessage = prefixedSealedAndSignedMessage;
        this.senderPubKeyForAddOperation = senderPubKeyForAddOperation;
        this.ownerPubKey = ownerPubKey;
        this.senderPubKeyForAddOperationBytes = Sig.getPublicKeyBytes(senderPubKeyForAddOperation);
        this.ownerPubKeyBytes = Sig.getPublicKeyBytes(ownerPubKey);
        if (ttl < TTL) {
            this.extraDataMap = new HashMap<String, String>();
            this.extraDataMap.put(EXTRA_MAP_KEY_TTL, String.valueOf(ttl));
        }
    }

    private MailboxStoragePayload(PrefixedSealedAndSignedMessage prefixedSealedAndSignedMessage, byte[] senderPubKeyForAddOperationBytes, byte[] ownerPubKeyBytes, @Nullable Map<String, String> extraDataMap) {
        this.prefixedSealedAndSignedMessage = prefixedSealedAndSignedMessage;
        this.senderPubKeyForAddOperationBytes = senderPubKeyForAddOperationBytes;
        this.ownerPubKeyBytes = ownerPubKeyBytes;
        this.extraDataMap = ExtraDataMapValidator.getValidatedExtraDataMap(extraDataMap);
        this.senderPubKeyForAddOperation = Sig.getPublicKeyFromBytes(senderPubKeyForAddOperationBytes);
        this.ownerPubKey = Sig.getPublicKeyFromBytes(ownerPubKeyBytes);
    }

    @Override
    public StoragePayload toProtoMessage() {
        MailboxStoragePayload.Builder builder = protobuf.MailboxStoragePayload.newBuilder().setPrefixedSealedAndSignedMessage(this.prefixedSealedAndSignedMessage.toProtoNetworkEnvelope().getPrefixedSealedAndSignedMessage()).setSenderPubKeyForAddOperationBytes(ByteString.copyFrom(this.senderPubKeyForAddOperationBytes)).setOwnerPubKeyBytes(ByteString.copyFrom(this.ownerPubKeyBytes));
        Optional.ofNullable(this.extraDataMap).ifPresent(builder::putAllExtraData);
        return StoragePayload.newBuilder().setMailboxStoragePayload(builder).build();
    }

    public static MailboxStoragePayload fromProto(protobuf.MailboxStoragePayload proto) {
        return new MailboxStoragePayload(PrefixedSealedAndSignedMessage.fromPayloadProto(proto.getPrefixedSealedAndSignedMessage()), proto.getSenderPubKeyForAddOperationBytes().toByteArray(), proto.getOwnerPubKeyBytes().toByteArray(), CollectionUtils.isEmpty(proto.getExtraDataMap()) ? null : proto.getExtraDataMap());
    }

    @Override
    public long getTTL() {
        if (this.extraDataMap != null && this.extraDataMap.containsKey(EXTRA_MAP_KEY_TTL)) {
            try {
                long ttl = Long.parseLong(this.extraDataMap.get(EXTRA_MAP_KEY_TTL));
                if (ttl < TTL) {
                    return ttl;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return TTL;
    }

    public PrefixedSealedAndSignedMessage getPrefixedSealedAndSignedMessage() {
        return this.prefixedSealedAndSignedMessage;
    }

    public PublicKey getSenderPubKeyForAddOperation() {
        return this.senderPubKeyForAddOperation;
    }

    public byte[] getSenderPubKeyForAddOperationBytes() {
        return this.senderPubKeyForAddOperationBytes;
    }

    @Override
    public PublicKey getOwnerPubKey() {
        return this.ownerPubKey;
    }

    public byte[] getOwnerPubKeyBytes() {
        return this.ownerPubKeyBytes;
    }

    @Override
    @Nullable
    public Map<String, String> getExtraDataMap() {
        return this.extraDataMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MailboxStoragePayload)) {
            return false;
        }
        MailboxStoragePayload other = (MailboxStoragePayload)o;
        PrefixedSealedAndSignedMessage this$prefixedSealedAndSignedMessage = this.getPrefixedSealedAndSignedMessage();
        PrefixedSealedAndSignedMessage other$prefixedSealedAndSignedMessage = other.getPrefixedSealedAndSignedMessage();
        if (this$prefixedSealedAndSignedMessage == null ? other$prefixedSealedAndSignedMessage != null : !((Object)this$prefixedSealedAndSignedMessage).equals(other$prefixedSealedAndSignedMessage)) {
            return false;
        }
        PublicKey this$senderPubKeyForAddOperation = this.getSenderPubKeyForAddOperation();
        PublicKey other$senderPubKeyForAddOperation = other.getSenderPubKeyForAddOperation();
        if (this$senderPubKeyForAddOperation == null ? other$senderPubKeyForAddOperation != null : !this$senderPubKeyForAddOperation.equals(other$senderPubKeyForAddOperation)) {
            return false;
        }
        if (!Arrays.equals(this.getSenderPubKeyForAddOperationBytes(), other.getSenderPubKeyForAddOperationBytes())) {
            return false;
        }
        PublicKey this$ownerPubKey = this.getOwnerPubKey();
        PublicKey other$ownerPubKey = other.getOwnerPubKey();
        if (this$ownerPubKey == null ? other$ownerPubKey != null : !this$ownerPubKey.equals(other$ownerPubKey)) {
            return false;
        }
        if (!Arrays.equals(this.getOwnerPubKeyBytes(), other.getOwnerPubKeyBytes())) {
            return false;
        }
        Map<String, String> this$extraDataMap = this.getExtraDataMap();
        Map<String, String> other$extraDataMap = other.getExtraDataMap();
        return !(this$extraDataMap == null ? other$extraDataMap != null : !((Object)this$extraDataMap).equals(other$extraDataMap));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PrefixedSealedAndSignedMessage $prefixedSealedAndSignedMessage = this.getPrefixedSealedAndSignedMessage();
        result = result * 59 + ($prefixedSealedAndSignedMessage == null ? 43 : ((Object)$prefixedSealedAndSignedMessage).hashCode());
        PublicKey $senderPubKeyForAddOperation = this.getSenderPubKeyForAddOperation();
        result = result * 59 + ($senderPubKeyForAddOperation == null ? 43 : $senderPubKeyForAddOperation.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSenderPubKeyForAddOperationBytes());
        PublicKey $ownerPubKey = this.getOwnerPubKey();
        result = result * 59 + ($ownerPubKey == null ? 43 : $ownerPubKey.hashCode());
        result = result * 59 + Arrays.hashCode(this.getOwnerPubKeyBytes());
        Map<String, String> $extraDataMap = this.getExtraDataMap();
        result = result * 59 + ($extraDataMap == null ? 43 : ((Object)$extraDataMap).hashCode());
        return result;
    }
}

