/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.storage.persistence;

import com.google.common.collect.ImmutableMap;
import haveno.common.app.DevEnv;
import haveno.common.app.Version;
import haveno.common.persistence.PersistenceManager;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.payload.PersistableNetworkPayload;
import haveno.network.p2p.storage.persistence.MapStoreService;
import haveno.network.p2p.storage.persistence.PersistableNetworkPayloadStore;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HistoricalDataStoreService<T extends PersistableNetworkPayloadStore<? extends PersistableNetworkPayload>>
extends MapStoreService<T, PersistableNetworkPayload> {
    private static final Logger log = LoggerFactory.getLogger(HistoricalDataStoreService.class);
    private ImmutableMap<String, PersistableNetworkPayloadStore<? extends PersistableNetworkPayload>> storesByVersion;
    private ImmutableMap<P2PDataStorage.ByteArray, PersistableNetworkPayload> allHistoricalPayloads;

    public HistoricalDataStoreService(File storageDir, PersistenceManager<T> persistenceManager) {
        super(storageDir, persistenceManager);
    }

    public Map<P2PDataStorage.ByteArray, PersistableNetworkPayload> getMapSinceVersion(String requestersVersion) {
        HashMap<P2PDataStorage.ByteArray, PersistableNetworkPayload> result = new HashMap<P2PDataStorage.ByteArray, PersistableNetworkPayload>(((PersistableNetworkPayloadStore)this.store).getMap());
        this.storesByVersion.entrySet().stream().filter(entry -> {
            if (requestersVersion == null) {
                log.info("The requester did not send a version. This is expected for not updated nodes.");
                return true;
            }
            String storeVersion = (String)entry.getKey();
            boolean newVersion = Version.isNewVersion(storeVersion, requestersVersion);
            String details = newVersion ? "As our historical store is a newer version we add the data to our result map." : "As the requester version is not older as our historical store we do not add the data to the result map.";
            log.trace("The requester had version {}. Our historical data store has version {}.\n{}", requestersVersion, storeVersion, details);
            return newVersion;
        }).map(e -> ((PersistableNetworkPayloadStore)e.getValue()).getMap()).forEach(result::putAll);
        log.info("We found {} entries since requesters version {}", (Object)result.size(), (Object)requestersVersion);
        return result;
    }

    public Map<P2PDataStorage.ByteArray, PersistableNetworkPayload> getMapOfLiveData() {
        return ((PersistableNetworkPayloadStore)this.store).getMap();
    }

    public Map<P2PDataStorage.ByteArray, PersistableNetworkPayload> getMapOfAllData() {
        HashMap<P2PDataStorage.ByteArray, PersistableNetworkPayload> result = new HashMap<P2PDataStorage.ByteArray, PersistableNetworkPayload>(this.getMapOfLiveData());
        result.putAll(this.allHistoricalPayloads);
        return result;
    }

    @Override
    public Map<P2PDataStorage.ByteArray, PersistableNetworkPayload> getMap() {
        DevEnv.logErrorAndThrowIfDevMode("HistoricalDataStoreService.getMap should not be used by domain clients but rather the custom methods getMapOfAllData, getMapOfLiveData or getMapSinceVersion");
        return this.getMapOfAllData();
    }

    @Override
    protected void put(P2PDataStorage.ByteArray hash, PersistableNetworkPayload payload) {
        if (this.anyMapContainsKey(hash)) {
            return;
        }
        this.getMapOfLiveData().put(hash, payload);
        this.requestPersistence();
    }

    @Override
    protected PersistableNetworkPayload putIfAbsent(P2PDataStorage.ByteArray hash, PersistableNetworkPayload payload) {
        if (this.anyMapContainsKey(hash)) {
            return null;
        }
        this.getMapOfLiveData().put(hash, payload);
        this.requestPersistence();
        return null;
    }

    @Override
    protected void readFromResources(String postFix, Runnable completeHandler) {
        this.readStore(persisted -> {
            log.debug("We have created the {} store for the live data and filled it with {} entries from the persisted data.", (Object)this.getFileName(), (Object)this.getMapOfLiveData().size());
            HashMap allHistoricalPayloads = new HashMap();
            HashMap storesByVersion = new HashMap();
            AtomicInteger numFiles = new AtomicInteger(Version.HISTORICAL_RESOURCE_FILE_VERSION_TAGS.size());
            Version.HISTORICAL_RESOURCE_FILE_VERSION_TAGS.forEach(version -> this.readHistoricalStoreFromResources((String)version, postFix, allHistoricalPayloads, storesByVersion, () -> {
                if (numFiles.decrementAndGet() == 0) {
                    this.allHistoricalPayloads = ImmutableMap.copyOf(allHistoricalPayloads);
                    this.storesByVersion = ImmutableMap.copyOf(storesByVersion);
                    completeHandler.run();
                }
            }));
        });
    }

    private void readHistoricalStoreFromResources(String version, String postFix, Map<P2PDataStorage.ByteArray, PersistableNetworkPayload> allHistoricalPayloads, Map<String, PersistableNetworkPayloadStore<? extends PersistableNetworkPayload>> storesByVersion, Runnable completeHandler) {
        String fileName = this.getFileName() + "_" + version;
        boolean wasCreatedFromResources = this.makeFileFromResourceFile(fileName, postFix);
        this.persistenceManager.readPersisted(fileName, persisted -> {
            storesByVersion.put(version, (PersistableNetworkPayloadStore<? extends PersistableNetworkPayload>)persisted);
            allHistoricalPayloads.putAll(persisted.getMap());
            log.debug("We have read from {} {} historical items.", (Object)fileName, (Object)persisted.getMap().size());
            this.pruneStore((PersistableNetworkPayloadStore<? extends PersistableNetworkPayload>)persisted, version);
            completeHandler.run();
        }, completeHandler::run);
    }

    private void pruneStore(PersistableNetworkPayloadStore<? extends PersistableNetworkPayload> historicalStore, String version) {
        Map<P2PDataStorage.ByteArray, PersistableNetworkPayload> mapOfLiveData = this.getMapOfLiveData();
        int preLive = mapOfLiveData.size();
        mapOfLiveData.keySet().removeAll(historicalStore.getMap().keySet());
        int postLive = mapOfLiveData.size();
        if (preLive > postLive) {
            log.debug("We pruned data from our live data store which are already contained in the historical data store with version {}. The live map had {} entries before pruning and has {} entries afterwards.", version, preLive, postLive);
        } else {
            log.debug("No pruning from historical data store with version {} was applied", (Object)version);
        }
        this.requestPersistence();
    }

    private boolean anyMapContainsKey(P2PDataStorage.ByteArray hash) {
        return this.getMapOfLiveData().containsKey(hash) || this.allHistoricalPayloads.containsKey(hash);
    }
}

