/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.storage.persistence;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.payload.ProtectedStorageEntry;
import haveno.network.p2p.storage.persistence.MapStoreService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedDataStoreService {
    private static final Logger log = LoggerFactory.getLogger(ProtectedDataStoreService.class);
    private final List<MapStoreService<? extends PersistableEnvelope, ProtectedStorageEntry>> services = new ArrayList<MapStoreService<? extends PersistableEnvelope, ProtectedStorageEntry>>();

    @Inject
    public ProtectedDataStoreService() {
    }

    public void addService(MapStoreService<? extends PersistableEnvelope, ProtectedStorageEntry> service) {
        this.services.add(service);
    }

    public void readFromResources(String postFix, Runnable completeHandler) {
        if (this.services.isEmpty()) {
            completeHandler.run();
            return;
        }
        AtomicInteger remaining = new AtomicInteger(this.services.size());
        this.services.forEach(service -> service.readFromResources(postFix, () -> {
            if (remaining.decrementAndGet() == 0) {
                completeHandler.run();
            }
        }));
    }

    @VisibleForTesting
    public void readFromResourcesSync(String postFix) {
        this.services.forEach(service -> service.readFromResourcesSync(postFix));
    }

    public Map<P2PDataStorage.ByteArray, ProtectedStorageEntry> getMap() {
        return this.services.stream().flatMap(service -> service.getMap().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void put(P2PDataStorage.ByteArray hash, ProtectedStorageEntry entry) {
        this.services.stream().filter(service -> service.canHandle(entry)).forEach(service -> service.put(hash, entry));
    }

    public ProtectedStorageEntry remove(P2PDataStorage.ByteArray hash, ProtectedStorageEntry protectedStorageEntry) {
        AtomicReference result = new AtomicReference();
        this.services.stream().filter(service -> service.canHandle(protectedStorageEntry)).forEach(service -> result.set((ProtectedStorageEntry)service.remove(hash)));
        return (ProtectedStorageEntry)result.get();
    }
}

