/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.p2p.storage.persistence;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.payload.MailboxStoragePayload;
import haveno.network.p2p.storage.persistence.RemovedPayloadsMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RemovedPayloadsService
implements PersistedDataHost {
    private static final Logger log = LoggerFactory.getLogger(RemovedPayloadsService.class);
    private final PersistenceManager<RemovedPayloadsMap> persistenceManager;
    private final RemovedPayloadsMap removedPayloadsMap = new RemovedPayloadsMap();

    @Inject
    public RemovedPayloadsService(PersistenceManager<RemovedPayloadsMap> persistenceManager) {
        this.persistenceManager = persistenceManager;
        this.persistenceManager.initialize(this.removedPayloadsMap, PersistenceManager.Source.PRIVATE_LOW_PRIO);
    }

    @Override
    public void readPersisted(Runnable completeHandler) {
        long cutOffDate = System.currentTimeMillis() - MailboxStoragePayload.TTL;
        this.persistenceManager.readPersisted(persisted -> {
            persisted.getDateByHashes().entrySet().stream().filter(e -> (Long)e.getValue() > cutOffDate).forEach(e -> this.removedPayloadsMap.getDateByHashes().put((P2PDataStorage.ByteArray)e.getKey(), (Long)e.getValue()));
            log.trace("## readPersisted: removedPayloadsMap size={}", (Object)this.removedPayloadsMap.getDateByHashes().size());
            this.persistenceManager.requestPersistence();
            completeHandler.run();
        }, completeHandler);
    }

    public boolean wasRemoved(P2PDataStorage.ByteArray hashOfPayload) {
        log.trace("## called wasRemoved: hashOfPayload={}, removedPayloadsMap={}", (Object)hashOfPayload.toString(), (Object)this.removedPayloadsMap);
        return this.removedPayloadsMap.getDateByHashes().containsKey(hashOfPayload);
    }

    public void addHash(P2PDataStorage.ByteArray hashOfPayload) {
        log.trace("## called addHash: hashOfPayload={}, removedPayloadsMap={}", (Object)hashOfPayload.toString(), (Object)this.removedPayloadsMap);
        this.removedPayloadsMap.getDateByHashes().putIfAbsent(hashOfPayload, System.currentTimeMillis());
        this.persistenceManager.requestPersistence();
    }
}

