/*
 * Decompiled with CFR 0.152.
 */
package haveno.network.utils;

import haveno.common.app.Capabilities;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.storage.payload.CapabilityRequiringPayload;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilityUtils {
    private static final Logger log = LoggerFactory.getLogger(CapabilityUtils.class);

    public static boolean capabilityRequiredAndCapabilityNotSupported(NodeAddress peersNodeAddress, NetworkEnvelope message, PeerManager peerManager) {
        if (!(message instanceof CapabilityRequiringPayload)) {
            return false;
        }
        Optional<Capabilities> optionalCapabilities = peerManager.findPeersCapabilities(peersNodeAddress);
        if (optionalCapabilities.isPresent()) {
            boolean result = optionalCapabilities.get().containsAll(((CapabilityRequiringPayload)((Object)message)).getRequiredCapabilities());
            if (!result) {
                log.warn("We don't send the message because the peer does not support the required capability. peersNodeAddress={}", (Object)peersNodeAddress);
            }
            return !result;
        }
        log.warn("We don't have the peer in our persisted peers so we don't know their capabilities. We decide to not sent the msg. peersNodeAddress={}", (Object)peersNodeAddress);
        return true;
    }
}

