/*
 * Decompiled with CFR 0.152.
 */
package monero.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import monero.common.MoneroConnectionManagerListener;
import monero.common.MoneroError;
import monero.common.MoneroRpcConnection;
import monero.common.TaskLooper;

public class MoneroConnectionManager {
    private static final long DEFAULT_TIMEOUT = 5000L;
    private static final long DEFAULT_POLL_PERIOD = 20000L;
    private static final boolean DEFAULT_AUTO_SWITCH = true;
    private static final int MIN_BETTER_RESPONSES = 3;
    private static ConnectionPriorityComparator priorityComparator = new ConnectionPriorityComparator();
    private MoneroRpcConnection currentConnection;
    private List<MoneroRpcConnection> connections = new ArrayList<MoneroRpcConnection>();
    private List<MoneroConnectionManagerListener> listeners = new ArrayList<MoneroConnectionManagerListener>();
    private ConnectionComparator connectionComparator = new ConnectionComparator();
    private boolean autoSwitch = true;
    private long timeoutMs = 5000L;
    private TaskLooper poller;
    private Map<MoneroRpcConnection, List<Long>> responseTimes = new HashMap<MoneroRpcConnection, List<Long>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroConnectionManager addListener(MoneroConnectionManagerListener listener) {
        List<MoneroConnectionManagerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroConnectionManager removeListener(MoneroConnectionManagerListener listener) {
        List<MoneroConnectionManagerListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.remove(listener)) {
                throw new MoneroError("Monero connection manager does not contain listener to remove");
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroConnectionManager removeListeners() {
        List<MoneroConnectionManagerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.clear();
            return this;
        }
    }

    public List<MoneroConnectionManagerListener> getListeners() {
        return this.listeners;
    }

    public MoneroConnectionManager addConnection(String uri) {
        return this.addConnection(new MoneroRpcConnection(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroConnectionManager addConnection(MoneroRpcConnection connection) {
        List<MoneroRpcConnection> list = this.connections;
        synchronized (list) {
            for (MoneroRpcConnection aConnection : this.connections) {
                if (!aConnection.getUri().equals(connection.getUri())) continue;
                throw new MoneroError("Connection URI already exists with connection manager: " + connection.getUri());
            }
            this.connections.add(connection);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroConnectionManager removeConnection(String uri) {
        List<MoneroRpcConnection> list = this.connections;
        synchronized (list) {
            MoneroRpcConnection connection = this.getConnectionByUri(uri);
            if (connection == null) {
                throw new MoneroError("No connection exists with URI: " + uri);
            }
            this.connections.remove(connection);
            this.responseTimes.remove(connection);
            if (connection == this.currentConnection) {
                this.currentConnection = null;
                this.onConnectionChanged(this.currentConnection);
            }
            return this;
        }
    }

    public MoneroConnectionManager setConnection(String uri) {
        if (uri == null || "".equals(uri)) {
            return this.setConnection((MoneroRpcConnection)null);
        }
        MoneroRpcConnection connection = this.getConnectionByUri(uri);
        return this.setConnection(connection == null ? new MoneroRpcConnection(uri) : connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroConnectionManager setConnection(MoneroRpcConnection connection) {
        if (this.currentConnection == connection) {
            return this;
        }
        if (connection == null) {
            this.currentConnection = null;
            this.onConnectionChanged(null);
            return this;
        }
        if (connection.getUri() == null || "".equals(connection.getUri())) {
            throw new MoneroError("Connection is missing URI");
        }
        List<MoneroRpcConnection> list = this.connections;
        synchronized (list) {
            MoneroRpcConnection prevConnection = this.getConnectionByUri(connection.getUri());
            if (prevConnection != null) {
                this.connections.remove(prevConnection);
            }
            this.addConnection(connection);
            this.currentConnection = connection;
            this.onConnectionChanged(this.currentConnection);
            return this;
        }
    }

    public MoneroRpcConnection getConnection() {
        return this.currentConnection;
    }

    public boolean hasConnection(String uri) {
        return this.getConnectionByUri(uri) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroRpcConnection getConnectionByUri(String uri) {
        List<MoneroRpcConnection> list = this.connections;
        synchronized (list) {
            for (MoneroRpcConnection connection : this.connections) {
                if (!connection.getUri().equals(uri)) continue;
                return connection;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MoneroRpcConnection> getConnections() {
        List<MoneroRpcConnection> list = this.connections;
        synchronized (list) {
            ArrayList<MoneroRpcConnection> sortedConnections = new ArrayList<MoneroRpcConnection>(this.connections);
            Collections.sort(sortedConnections, this.connectionComparator);
            return sortedConnections;
        }
    }

    public Boolean isConnected() {
        if (this.currentConnection == null) {
            return false;
        }
        return this.currentConnection.isConnected();
    }

    public void startPolling() {
        this.startPolling(null, null, null, null, null);
    }

    public void startPolling(Long periodMs) {
        this.startPolling(periodMs, null, null, null, null);
    }

    public MoneroConnectionManager startPolling(Long periodMs, Boolean autoSwitch, Long timeoutMs, PollType pollType, Collection<MoneroRpcConnection> excludedConnections) {
        if (periodMs == null) {
            periodMs = 20000L;
        }
        if (autoSwitch != null) {
            this.setAutoSwitch(autoSwitch);
        }
        if (timeoutMs != null) {
            this.setTimeout(timeoutMs);
        }
        if (pollType == null) {
            pollType = PollType.PRIORITIZED;
        }
        this.stopPolling();
        switch (pollType.ordinal()) {
            case 1: {
                this.startPollingConnection(periodMs);
                break;
            }
            case 2: {
                this.startPollingConnections(periodMs);
                break;
            }
            default: {
                this.startPollingPrioritizedConnections(periodMs, excludedConnections);
            }
        }
        return this;
    }

    public MoneroConnectionManager stopPolling() {
        if (this.poller != null) {
            this.poller.stop();
        }
        this.poller = null;
        return this;
    }

    public MoneroConnectionManager checkConnection() {
        MoneroRpcConnection bestConnection;
        boolean connectionChanged = false;
        MoneroRpcConnection connection = this.getConnection();
        if (connection != null) {
            if (connection.checkConnection(this.timeoutMs)) {
                connectionChanged = true;
            }
            this.processResponses(Arrays.asList(connection));
        }
        if (this.autoSwitch && !this.isConnected().booleanValue() && (bestConnection = this.getBestAvailableConnection(connection)) != null) {
            this.setConnection(bestConnection);
            return this;
        }
        if (connectionChanged) {
            this.onConnectionChanged(connection);
        }
        return this;
    }

    public MoneroConnectionManager checkConnections() {
        this.checkConnections(this.getConnections(), null);
        return this;
    }

    public MoneroRpcConnection getBestAvailableConnection(MoneroRpcConnection ... excludedConnections) {
        for (List<MoneroRpcConnection> prioritizedConnections : this.getConnectionsInAscendingPriority()) {
            try {
                int numTasks = 0;
                ExecutorService pool = Executors.newFixedThreadPool(prioritizedConnections.size());
                ExecutorCompletionService<MoneroRpcConnection> completionService = new ExecutorCompletionService<MoneroRpcConnection>(pool);
                for (MoneroRpcConnection connection : prioritizedConnections) {
                    if (Arrays.asList(excludedConnections).contains(connection)) continue;
                    ++numTasks;
                    completionService.submit(() -> {
                        connection.checkConnection(this.timeoutMs);
                        return connection;
                    });
                }
                pool.shutdown();
                for (int i = 0; i < numTasks; ++i) {
                    MoneroRpcConnection connection;
                    connection = (MoneroRpcConnection)completionService.take().get();
                    if (!connection.isConnected().booleanValue()) continue;
                    return connection;
                }
            }
            catch (Exception e) {
                throw new MoneroError(e);
            }
        }
        return null;
    }

    public MoneroConnectionManager setAutoSwitch(boolean autoSwitch) {
        this.autoSwitch = autoSwitch;
        return this;
    }

    public boolean getAutoSwitch() {
        return this.autoSwitch;
    }

    public MoneroConnectionManager setTimeout(long timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    public long getTimeout() {
        return this.timeoutMs;
    }

    public List<MoneroRpcConnection> getPeerConnections() {
        throw new RuntimeException("Not implemented");
    }

    public MoneroConnectionManager disconnect() {
        this.setConnection((String)null);
        return this;
    }

    public MoneroConnectionManager clear() {
        this.connections.clear();
        if (this.currentConnection != null) {
            this.currentConnection = null;
            this.onConnectionChanged(null);
        }
        return this;
    }

    public MoneroConnectionManager reset() {
        this.removeListeners();
        this.stopPolling();
        this.clear();
        this.timeoutMs = 5000L;
        this.autoSwitch = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectionChanged(MoneroRpcConnection connection) {
        List<MoneroConnectionManagerListener> list = this.listeners;
        synchronized (list) {
            for (MoneroConnectionManagerListener listener : this.listeners) {
                listener.onConnectionChanged(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<MoneroRpcConnection>> getConnectionsInAscendingPriority() {
        List<MoneroRpcConnection> list = this.connections;
        synchronized (list) {
            TreeMap connectionPriorities = new TreeMap();
            for (MoneroRpcConnection connection : this.connections) {
                if (!connectionPriorities.containsKey(connection.getPriority())) {
                    connectionPriorities.put(connection.getPriority(), new ArrayList());
                }
                ((List)connectionPriorities.get(connection.getPriority())).add(connection);
            }
            ArrayList<List<MoneroRpcConnection>> prioritizedConnections = new ArrayList<List<MoneroRpcConnection>>();
            for (List priorityConnections : connectionPriorities.values()) {
                prioritizedConnections.add(priorityConnections);
            }
            if (connectionPriorities.containsKey(0)) {
                prioritizedConnections.add((List)prioritizedConnections.remove(0));
            }
            return prioritizedConnections;
        }
    }

    private void startPollingConnection(long periodMs) {
        this.poller = new TaskLooper(() -> {
            try {
                this.checkConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.poller.start(periodMs);
    }

    private void startPollingConnections(long periodMs) {
        this.poller = new TaskLooper(() -> {
            try {
                this.checkConnections();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.poller.start(periodMs);
    }

    private void startPollingPrioritizedConnections(long periodMs, Collection<MoneroRpcConnection> excludedConnections) {
        this.poller = new TaskLooper(() -> {
            try {
                this.checkPrioritizedConnections(excludedConnections);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.poller.start(periodMs);
    }

    private void checkPrioritizedConnections(Collection<MoneroRpcConnection> excludedConnections) {
        for (List<MoneroRpcConnection> prioritizedConnections : this.getConnectionsInAscendingPriority()) {
            boolean hasConnection = this.checkConnections(prioritizedConnections, excludedConnections);
            if (!hasConnection) continue;
            return;
        }
    }

    private boolean checkConnections(Collection<MoneroRpcConnection> connections, Collection<MoneroRpcConnection> excludedConnections) {
        Collection<MoneroRpcConnection> collection = connections;
        synchronized (collection) {
            try {
                int numTasks = 0;
                ExecutorService pool = Executors.newFixedThreadPool(connections.size());
                ExecutorCompletionService<MoneroRpcConnection> completionService = new ExecutorCompletionService<MoneroRpcConnection>(pool);
                for (MoneroRpcConnection connection : connections) {
                    if (excludedConnections != null && excludedConnections.contains(connection)) continue;
                    ++numTasks;
                    completionService.submit(() -> {
                        boolean change = connection.checkConnection(this.timeoutMs);
                        if (change && connection == this.getConnection()) {
                            this.onConnectionChanged(connection);
                        }
                        return connection;
                    });
                }
                pool.shutdown();
                boolean hasConnection = false;
                for (int i = 0; i < numTasks; ++i) {
                    MoneroRpcConnection connection = (MoneroRpcConnection)completionService.take().get();
                    if (!Boolean.TRUE.equals(connection.isConnected()) || hasConnection) continue;
                    hasConnection = true;
                    if (Boolean.TRUE.equals(this.isConnected()) || !this.autoSwitch) continue;
                    this.setConnection(connection);
                }
                this.processResponses(connections);
                return hasConnection;
            }
            catch (Exception e) {
                throw new MoneroError(e);
            }
        }
    }

    private MoneroRpcConnection processResponses(Collection<MoneroRpcConnection> responses) {
        for (MoneroRpcConnection moneroRpcConnection : responses) {
            if (this.responseTimes.containsKey(moneroRpcConnection)) continue;
            this.responseTimes.put(moneroRpcConnection, new ArrayList());
        }
        for (Map.Entry entry : this.responseTimes.entrySet()) {
            ((List)entry.getValue()).add(0, responses.contains(entry.getKey()) ? ((MoneroRpcConnection)entry.getKey()).getResponseTime() : null);
            if (((List)entry.getValue()).size() <= 3) continue;
            ((List)entry.getValue()).remove(((List)entry.getValue()).size() - 1);
        }
        return this.updateBestConnectionInPriority();
    }

    private MoneroRpcConnection updateBestConnectionInPriority() {
        if (!this.autoSwitch) {
            return null;
        }
        for (List<MoneroRpcConnection> prioritizedConnections : this.getConnectionsInAscendingPriority()) {
            MoneroRpcConnection bestConnectionFromResponses = this.getBestConnectionFromPrioritizedResponses(prioritizedConnections);
            if (bestConnectionFromResponses == null) continue;
            this.setConnection(bestConnectionFromResponses);
            return bestConnectionFromResponses;
        }
        return null;
    }

    private MoneroRpcConnection getBestConnectionFromPrioritizedResponses(Collection<MoneroRpcConnection> responses) {
        MoneroRpcConnection bestResponse = null;
        for (MoneroRpcConnection connection : responses) {
            if (!Boolean.TRUE.equals(connection.isConnected()) || bestResponse != null && connection.getResponseTime() >= bestResponse.getResponseTime()) continue;
            bestResponse = connection;
        }
        if (bestResponse == null) {
            return null;
        }
        MoneroRpcConnection bestConnection = this.getConnection();
        if (bestConnection == null || !Boolean.TRUE.equals(bestConnection.isConnected())) {
            return bestResponse;
        }
        if (priorityComparator.compare(bestResponse.getPriority(), bestConnection.getPriority()) != 0) {
            return bestResponse;
        }
        if (!this.responseTimes.containsKey(bestConnection)) {
            return bestConnection;
        }
        for (MoneroRpcConnection connection : responses) {
            if (connection == bestConnection || !this.responseTimes.containsKey(connection) || this.responseTimes.get(connection).size() < 3) continue;
            boolean better = true;
            for (int i = 0; i < 3; ++i) {
                if (this.responseTimes.get(connection).get(i) != null && this.responseTimes.get(bestConnection).get(i) != null && this.responseTimes.get(connection).get(i) <= this.responseTimes.get(bestConnection).get(i)) continue;
                better = false;
                break;
            }
            if (!better) continue;
            bestConnection = connection;
        }
        return bestConnection;
    }

    private static class ConnectionPriorityComparator
    implements Comparator<Integer> {
        private ConnectionPriorityComparator() {
        }

        @Override
        public int compare(Integer p1, Integer p2) {
            if (p1 == p2) {
                return 0;
            }
            if (p1 == 0) {
                return -1;
            }
            if (p2 == 0) {
                return 1;
            }
            return p2 - p1;
        }
    }

    private class ConnectionComparator
    implements Comparator<MoneroRpcConnection> {
        private ConnectionComparator() {
        }

        @Override
        public int compare(MoneroRpcConnection c1, MoneroRpcConnection c2) {
            if (c1 == MoneroConnectionManager.this.currentConnection) {
                return -1;
            }
            if (c2 == MoneroConnectionManager.this.currentConnection) {
                return 1;
            }
            if (c1.isOnline() == c2.isOnline()) {
                if (c1.getPriority() == c2.getPriority()) {
                    return c1.getUri().compareTo(c2.getUri());
                }
                return priorityComparator.compare(c1.getPriority(), c2.getPriority()) * -1;
            }
            if (Boolean.TRUE.equals(c1.isOnline())) {
                return -1;
            }
            if (Boolean.TRUE.equals(c2.isOnline())) {
                return 1;
            }
            if (c1.isOnline() == null) {
                return -1;
            }
            return 1;
        }
    }

    public static enum PollType {
        PRIORITIZED,
        CURRENT,
        ALL;

    }
}

