/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import monero.common.MoneroConnectionManager;
import monero.common.MoneroRpcConnection;
import monero.daemon.model.MoneroKeyImage;
import monero.daemon.model.MoneroVersion;
import monero.wallet.model.MoneroAccount;
import monero.wallet.model.MoneroAccountTag;
import monero.wallet.model.MoneroAddressBookEntry;
import monero.wallet.model.MoneroCheckReserve;
import monero.wallet.model.MoneroCheckTx;
import monero.wallet.model.MoneroIncomingTransfer;
import monero.wallet.model.MoneroIntegratedAddress;
import monero.wallet.model.MoneroKeyImageImportResult;
import monero.wallet.model.MoneroMessageSignatureResult;
import monero.wallet.model.MoneroMessageSignatureType;
import monero.wallet.model.MoneroMultisigInfo;
import monero.wallet.model.MoneroMultisigInitResult;
import monero.wallet.model.MoneroMultisigSignResult;
import monero.wallet.model.MoneroOutgoingTransfer;
import monero.wallet.model.MoneroOutputQuery;
import monero.wallet.model.MoneroOutputWallet;
import monero.wallet.model.MoneroSubaddress;
import monero.wallet.model.MoneroSyncResult;
import monero.wallet.model.MoneroTransfer;
import monero.wallet.model.MoneroTransferQuery;
import monero.wallet.model.MoneroTxConfig;
import monero.wallet.model.MoneroTxPriority;
import monero.wallet.model.MoneroTxQuery;
import monero.wallet.model.MoneroTxSet;
import monero.wallet.model.MoneroTxWallet;
import monero.wallet.model.MoneroWalletListenerI;

public interface MoneroWallet {
    public static final String DEFAULT_LANGUAGE = "English";

    public void addListener(MoneroWalletListenerI var1);

    public void removeListener(MoneroWalletListenerI var1);

    public Set<MoneroWalletListenerI> getListeners();

    public boolean isViewOnly();

    public void setDaemonConnection(String var1);

    public void setDaemonConnection(String var1, String var2, String var3);

    public void setDaemonConnection(MoneroRpcConnection var1);

    public MoneroRpcConnection getDaemonConnection();

    public void setConnectionManager(MoneroConnectionManager var1);

    public MoneroConnectionManager getConnectionManager();

    public void setProxyUri(String var1);

    public boolean isConnectedToDaemon();

    public MoneroVersion getVersion();

    public String getPath();

    public String getSeed();

    public String getSeedLanguage();

    public String getPrivateViewKey();

    public String getPrivateSpendKey();

    public String getPublicViewKey();

    public String getPublicSpendKey();

    public String getPrimaryAddress();

    public String getAddress(int var1, int var2);

    public MoneroSubaddress getAddressIndex(String var1);

    public MoneroIntegratedAddress getIntegratedAddress();

    public MoneroIntegratedAddress getIntegratedAddress(String var1, String var2);

    public MoneroIntegratedAddress decodeIntegratedAddress(String var1);

    public long getHeight();

    public long getDaemonHeight();

    public long getHeightByDate(int var1, int var2, int var3);

    public MoneroSyncResult sync();

    public MoneroSyncResult sync(MoneroWalletListenerI var1);

    public MoneroSyncResult sync(Long var1);

    public MoneroSyncResult sync(Long var1, MoneroWalletListenerI var2);

    public void startSyncing();

    public void startSyncing(Long var1);

    public void stopSyncing();

    public void scanTxs(Collection<String> var1);

    public void rescanSpent();

    public void rescanBlockchain();

    public BigInteger getBalance();

    public BigInteger getBalance(Integer var1);

    public BigInteger getBalance(Integer var1, Integer var2);

    public BigInteger getUnlockedBalance();

    public BigInteger getUnlockedBalance(Integer var1);

    public BigInteger getUnlockedBalance(Integer var1, Integer var2);

    public List<MoneroAccount> getAccounts();

    public List<MoneroAccount> getAccounts(boolean var1);

    public List<MoneroAccount> getAccounts(String var1);

    public List<MoneroAccount> getAccounts(boolean var1, String var2);

    public MoneroAccount getAccount(int var1);

    public MoneroAccount getAccount(int var1, boolean var2);

    public MoneroAccount createAccount();

    public MoneroAccount createAccount(String var1);

    public void setAccountLabel(int var1, String var2);

    public List<MoneroSubaddress> getSubaddresses(int var1);

    public List<MoneroSubaddress> getSubaddresses(int var1, List<Integer> var2);

    public MoneroSubaddress getSubaddress(int var1, int var2);

    public MoneroSubaddress createSubaddress(int var1);

    public MoneroSubaddress createSubaddress(int var1, String var2);

    public void setSubaddressLabel(int var1, int var2, String var3);

    public MoneroTxWallet getTx(String var1);

    public List<MoneroTxWallet> getTxs();

    public List<MoneroTxWallet> getTxs(String ... var1);

    public List<MoneroTxWallet> getTxs(List<String> var1);

    public List<MoneroTxWallet> getTxs(MoneroTxQuery var1);

    public List<MoneroTransfer> getTransfers();

    public List<MoneroTransfer> getTransfers(int var1);

    public List<MoneroTransfer> getTransfers(int var1, int var2);

    public List<MoneroTransfer> getTransfers(MoneroTransferQuery var1);

    public List<MoneroIncomingTransfer> getIncomingTransfers();

    public List<MoneroIncomingTransfer> getIncomingTransfers(MoneroTransferQuery var1);

    public List<MoneroOutgoingTransfer> getOutgoingTransfers();

    public List<MoneroOutgoingTransfer> getOutgoingTransfers(MoneroTransferQuery var1);

    public List<MoneroOutputWallet> getOutputs();

    public List<MoneroOutputWallet> getOutputs(MoneroOutputQuery var1);

    public String exportOutputs();

    public String exportOutputs(boolean var1);

    public int importOutputs(String var1);

    public List<MoneroKeyImage> exportKeyImages();

    public List<MoneroKeyImage> exportKeyImages(boolean var1);

    public MoneroKeyImageImportResult importKeyImages(List<MoneroKeyImage> var1);

    public List<MoneroKeyImage> getNewKeyImagesFromLastImport();

    public void freezeOutput(String var1);

    public void thawOutput(String var1);

    public boolean isOutputFrozen(String var1);

    public MoneroTxPriority getDefaultFeePriority();

    public MoneroTxWallet createTx(MoneroTxConfig var1);

    public List<MoneroTxWallet> createTxs(MoneroTxConfig var1);

    public MoneroTxWallet sweepOutput(MoneroTxConfig var1);

    public List<MoneroTxWallet> sweepUnlocked(MoneroTxConfig var1);

    public List<MoneroTxWallet> sweepDust(boolean var1);

    public String relayTx(String var1);

    public String relayTx(MoneroTxWallet var1);

    public List<String> relayTxs(Collection<String> var1);

    public List<String> relayTxs(List<MoneroTxWallet> var1);

    public MoneroTxSet describeUnsignedTxSet(String var1);

    public MoneroTxSet describeMultisigTxSet(String var1);

    public MoneroTxSet describeTxSet(MoneroTxSet var1);

    public MoneroTxSet signTxs(String var1);

    public List<String> submitTxs(String var1);

    public String signMessage(String var1);

    public String signMessage(String var1, MoneroMessageSignatureType var2, int var3, int var4);

    public MoneroMessageSignatureResult verifyMessage(String var1, String var2, String var3);

    public String getTxKey(String var1);

    public MoneroCheckTx checkTxKey(String var1, String var2, String var3);

    public String getTxProof(String var1, String var2);

    public String getTxProof(String var1, String var2, String var3);

    public MoneroCheckTx checkTxProof(String var1, String var2, String var3, String var4);

    public String getSpendProof(String var1);

    public String getSpendProof(String var1, String var2);

    public boolean checkSpendProof(String var1, String var2, String var3);

    public String getReserveProofWallet(String var1);

    public String getReserveProofAccount(int var1, BigInteger var2, String var3);

    public MoneroCheckReserve checkReserveProof(String var1, String var2, String var3);

    public String getTxNote(String var1);

    public List<String> getTxNotes(List<String> var1);

    public void setTxNote(String var1, String var2);

    public void setTxNotes(List<String> var1, List<String> var2);

    public List<MoneroAddressBookEntry> getAddressBookEntries();

    public List<MoneroAddressBookEntry> getAddressBookEntries(List<Integer> var1);

    public int addAddressBookEntry(String var1, String var2);

    public void editAddressBookEntry(int var1, boolean var2, String var3, boolean var4, String var5);

    public void deleteAddressBookEntry(int var1);

    public void tagAccounts(String var1, Collection<Integer> var2);

    public void untagAccounts(Collection<Integer> var1);

    public List<MoneroAccountTag> getAccountTags();

    public void setAccountTagLabel(String var1, String var2);

    public String getPaymentUri(MoneroTxConfig var1);

    public MoneroTxConfig parsePaymentUri(String var1);

    public String getAttribute(String var1);

    public void setAttribute(String var1, String var2);

    public void startMining(Long var1, Boolean var2, Boolean var3);

    public void stopMining();

    public boolean isMultisigImportNeeded();

    public boolean isMultisig();

    public MoneroMultisigInfo getMultisigInfo();

    public String prepareMultisig();

    public String makeMultisig(List<String> var1, int var2, String var3);

    public MoneroMultisigInitResult exchangeMultisigKeys(List<String> var1, String var2);

    public String exportMultisigHex();

    public int importMultisigHex(String ... var1);

    public int importMultisigHex(List<String> var1);

    public MoneroMultisigSignResult signMultisigTxHex(String var1);

    public List<String> submitMultisigTxHex(String var1);

    public void changePassword(String var1, String var2);

    public void save();

    public void close();

    public void close(boolean var1);

    public boolean isClosed();
}

