/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet.model;

import common.utils.GenUtils;
import java.math.BigInteger;
import java.util.List;
import monero.wallet.model.MoneroSubaddress;

public class MoneroAccount {
    private Integer index;
    private String primaryAddress;
    private BigInteger balance;
    private BigInteger unlockedBalance;
    private String tag;
    private List<MoneroSubaddress> subaddresses;

    public MoneroAccount() {
    }

    public MoneroAccount(int index, String primaryAddress, BigInteger balance, BigInteger unlockedBalance, List<MoneroSubaddress> subaddresses) {
        this.index = index;
        this.primaryAddress = primaryAddress;
        this.balance = balance;
        this.unlockedBalance = unlockedBalance;
        this.subaddresses = subaddresses;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public String getPrimaryAddress() {
        return this.primaryAddress;
    }

    public void setPrimaryAddress(String primaryAddress) {
        this.primaryAddress = primaryAddress;
    }

    public BigInteger getBalance() {
        return this.balance;
    }

    public void setBalance(BigInteger balance) {
        this.balance = balance;
    }

    public BigInteger getUnlockedBalance() {
        return this.unlockedBalance;
    }

    public void setUnlockedBalance(BigInteger unlockedBalance) {
        this.unlockedBalance = unlockedBalance;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public List<MoneroSubaddress> getSubaddresses() {
        return this.subaddresses;
    }

    public void setSubaddresses(List<MoneroSubaddress> subaddresses) {
        this.subaddresses = subaddresses;
        if (subaddresses != null) {
            for (MoneroSubaddress subaddress : subaddresses) {
                subaddress.setAccountIndex(this.index);
            }
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(GenUtils.kvLine("Index", this.getIndex(), indent));
        sb.append(GenUtils.kvLine("Primary address", this.getPrimaryAddress(), indent));
        sb.append(GenUtils.kvLine("Balance", this.getBalance(), indent));
        sb.append(GenUtils.kvLine("Unlocked balance", this.getUnlockedBalance(), indent));
        sb.append(GenUtils.kvLine("Tag", this.getTag(), indent));
        if (this.getSubaddresses() != null) {
            sb.append(GenUtils.kvLine("Subaddresses", "", indent));
            for (int i = 0; i < this.getSubaddresses().size(); ++i) {
                sb.append(GenUtils.kvLine(i + 1, "", indent + 1));
                sb.append(this.getSubaddresses().get(i).toString(indent + 2) + "\n");
            }
        }
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.balance == null ? 0 : this.balance.hashCode());
        result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
        result = 31 * result + (this.primaryAddress == null ? 0 : this.primaryAddress.hashCode());
        result = 31 * result + (this.subaddresses == null ? 0 : this.subaddresses.hashCode());
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        result = 31 * result + (this.unlockedBalance == null ? 0 : this.unlockedBalance.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroAccount other = (MoneroAccount)obj;
        if (this.balance == null ? other.balance != null : !this.balance.equals(other.balance)) {
            return false;
        }
        if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
            return false;
        }
        if (this.primaryAddress == null ? other.primaryAddress != null : !this.primaryAddress.equals(other.primaryAddress)) {
            return false;
        }
        if (this.subaddresses == null ? other.subaddresses != null : !this.subaddresses.equals(other.subaddresses)) {
            return false;
        }
        if (this.tag == null ? other.tag != null : !this.tag.equals(other.tag)) {
            return false;
        }
        return !(this.unlockedBalance == null ? other.unlockedBalance != null : !this.unlockedBalance.equals(other.unlockedBalance));
    }
}

