/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import common.utils.GenUtils;
import java.math.BigInteger;

public class MoneroSubaddress {
    private Integer accountIndex;
    private Integer index;
    private String address;
    private String label;
    private BigInteger balance;
    private BigInteger unlockedBalance;
    private Long numUnspentOutputs;
    private Boolean isUsed;
    private Long numBlocksToUnlock;

    public MoneroSubaddress() {
    }

    public MoneroSubaddress(String address) {
        this.address = address;
    }

    public MoneroSubaddress(int accountIndex, int index) {
        this.accountIndex = accountIndex;
        this.index = index;
    }

    public Integer getAccountIndex() {
        return this.accountIndex;
    }

    public MoneroSubaddress setAccountIndex(Integer accountIndex) {
        this.accountIndex = accountIndex;
        return this;
    }

    public Integer getIndex() {
        return this.index;
    }

    public MoneroSubaddress setIndex(Integer index) {
        this.index = index;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public MoneroSubaddress setAddress(String address) {
        this.address = address;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public MoneroSubaddress setLabel(String label) {
        this.label = label;
        return this;
    }

    public BigInteger getBalance() {
        return this.balance;
    }

    public MoneroSubaddress setBalance(BigInteger balance) {
        this.balance = balance;
        return this;
    }

    public BigInteger getUnlockedBalance() {
        return this.unlockedBalance;
    }

    public MoneroSubaddress setUnlockedBalance(BigInteger unlockedBalance) {
        this.unlockedBalance = unlockedBalance;
        return this;
    }

    public Long getNumUnspentOutputs() {
        return this.numUnspentOutputs;
    }

    public MoneroSubaddress setNumUnspentOutputs(Long numUnspentOutputs) {
        this.numUnspentOutputs = numUnspentOutputs;
        return this;
    }

    @JsonProperty(value="isUsed")
    public Boolean isUsed() {
        return this.isUsed;
    }

    public MoneroSubaddress setIsUsed(Boolean isUsed) {
        this.isUsed = isUsed;
        return this;
    }

    public Long getNumBlocksToUnlock() {
        return this.numBlocksToUnlock;
    }

    public MoneroSubaddress setNumBlocksToUnlock(Long numBlocksToUnlock) {
        this.numBlocksToUnlock = numBlocksToUnlock;
        return this;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(GenUtils.kvLine("Account index", this.getAccountIndex(), indent));
        sb.append(GenUtils.kvLine("Subaddress index", this.getIndex(), indent));
        sb.append(GenUtils.kvLine("Address", this.getAddress(), indent));
        sb.append(GenUtils.kvLine("Label", this.getLabel(), indent));
        sb.append(GenUtils.kvLine("Balance", this.getBalance(), indent));
        sb.append(GenUtils.kvLine("Unlocked balance", this.getUnlockedBalance(), indent));
        sb.append(GenUtils.kvLine("Num unspent outputs", this.getNumUnspentOutputs(), indent));
        sb.append(GenUtils.kvLine("Is used", this.isUsed(), indent));
        sb.append(GenUtils.kvLine("Num blocks to unlock", this.getNumBlocksToUnlock(), indent));
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountIndex == null ? 0 : this.accountIndex.hashCode());
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.balance == null ? 0 : this.balance.hashCode());
        result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
        result = 31 * result + (this.isUsed == null ? 0 : this.isUsed.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.numBlocksToUnlock == null ? 0 : this.numBlocksToUnlock.hashCode());
        result = 31 * result + (this.numUnspentOutputs == null ? 0 : this.numUnspentOutputs.hashCode());
        result = 31 * result + (this.unlockedBalance == null ? 0 : this.unlockedBalance.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroSubaddress other = (MoneroSubaddress)obj;
        if (this.accountIndex == null ? other.accountIndex != null : !this.accountIndex.equals(other.accountIndex)) {
            return false;
        }
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.balance == null ? other.balance != null : !this.balance.equals(other.balance)) {
            return false;
        }
        if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
            return false;
        }
        if (this.isUsed == null ? other.isUsed != null : !this.isUsed.equals(other.isUsed)) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (this.numBlocksToUnlock == null ? other.numBlocksToUnlock != null : !this.numBlocksToUnlock.equals(other.numBlocksToUnlock)) {
            return false;
        }
        if (this.numUnspentOutputs == null ? other.numUnspentOutputs != null : !this.numUnspentOutputs.equals(other.numUnspentOutputs)) {
            return false;
        }
        return !(this.unlockedBalance == null ? other.unlockedBalance != null : !this.unlockedBalance.equals(other.unlockedBalance));
    }
}

