/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import common.utils.GenUtils;
import java.util.List;
import monero.common.MoneroUtils;
import monero.daemon.model.MoneroTx;
import monero.wallet.model.MoneroTxWallet;

public class MoneroTxSet {
    private List<MoneroTxWallet> txs;
    private String multisigTxHex;
    private String unsignedTxHex;
    private String signedTxHex;

    @JsonManagedReference(value="tx_set")
    public List<MoneroTxWallet> getTxs() {
        return this.txs;
    }

    @JsonProperty(value="txs")
    public MoneroTxSet setTxs(List<MoneroTxWallet> txs) {
        this.txs = txs;
        return this;
    }

    @JsonIgnore
    public MoneroTxSet setTxs(MoneroTxWallet ... txs) {
        this.txs = GenUtils.arrayToList(txs);
        return this;
    }

    public String getMultisigTxHex() {
        return this.multisigTxHex;
    }

    public MoneroTxSet setMultisigTxHex(String multisigTxHex) {
        this.multisigTxHex = multisigTxHex;
        return this;
    }

    public String getUnsignedTxHex() {
        return this.unsignedTxHex;
    }

    public MoneroTxSet setUnsignedTxHex(String unsignedTxHex) {
        this.unsignedTxHex = unsignedTxHex;
        return this;
    }

    public String getSignedTxHex() {
        return this.signedTxHex;
    }

    public MoneroTxSet setSignedTxHex(String signedTxHex) {
        this.signedTxHex = signedTxHex;
        return this;
    }

    public MoneroTxSet merge(MoneroTxSet txSet) {
        GenUtils.assertNotNull(txSet);
        if (this == txSet) {
            return this;
        }
        this.setMultisigTxHex(GenUtils.reconcile(this.getMultisigTxHex(), txSet.getMultisigTxHex()));
        this.setUnsignedTxHex(GenUtils.reconcile(this.getUnsignedTxHex(), txSet.getUnsignedTxHex()));
        this.setSignedTxHex(GenUtils.reconcile(this.getSignedTxHex(), txSet.getSignedTxHex()));
        if (txSet.getTxs() != null) {
            for (MoneroTxWallet tx : txSet.getTxs()) {
                tx.setTxSet(this);
                MoneroUtils.mergeTx(this.txs, tx);
            }
        }
        return this;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(GenUtils.kvLine("Multisig tx hex: ", this.getMultisigTxHex(), indent));
        sb.append(GenUtils.kvLine("Unsigned tx hex: ", this.getUnsignedTxHex(), indent));
        sb.append(GenUtils.kvLine("Signed tx hex: ", this.getSignedTxHex(), indent));
        if (this.getTxs() != null) {
            sb.append(GenUtils.kvLine("Txs", "", indent));
            for (MoneroTx moneroTx : this.getTxs()) {
                sb.append(moneroTx.toString(indent + 1) + "\n");
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.multisigTxHex == null ? 0 : this.multisigTxHex.hashCode());
        result = 31 * result + (this.signedTxHex == null ? 0 : this.signedTxHex.hashCode());
        result = 31 * result + (this.unsignedTxHex == null ? 0 : this.unsignedTxHex.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroTxSet other = (MoneroTxSet)obj;
        if (this.multisigTxHex == null ? other.multisigTxHex != null : !this.multisigTxHex.equals(other.multisigTxHex)) {
            return false;
        }
        if (this.signedTxHex == null ? other.signedTxHex != null : !this.signedTxHex.equals(other.signedTxHex)) {
            return false;
        }
        return !(this.unsignedTxHex == null ? other.unsignedTxHex != null : !this.unsignedTxHex.equals(other.unsignedTxHex));
    }
}

