/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import common.utils.JsonUtils;
import monero.common.MoneroConnectionManager;
import monero.common.MoneroRpcConnection;
import monero.daemon.model.MoneroNetworkType;

public class MoneroWalletConfig {
    private String path;
    private String password;
    private MoneroNetworkType networkType;
    private MoneroRpcConnection server;
    private String serverUsername;
    private String serverPassword;
    private MoneroConnectionManager connectionManager;
    private String seed;
    private String seedOffset;
    private String primaryAddress;
    private String privateViewKey;
    private String privateSpendKey;
    private Long restoreHeight;
    private String language;
    private Boolean saveCurrent;
    private Integer accountLookahead;
    private Integer subaddressLookahead;
    private byte[] keysData;
    private byte[] cacheData;
    private Boolean isMultisig;

    public MoneroWalletConfig() {
    }

    public MoneroWalletConfig(MoneroWalletConfig config) {
        this.path = config.getPath();
        this.password = config.getPassword();
        this.networkType = config.getNetworkType();
        this.server = config.getServer();
        this.connectionManager = config.getConnectionManager();
        this.seed = config.getSeed();
        this.seedOffset = config.getSeedOffset();
        this.primaryAddress = config.getPrimaryAddress();
        this.privateViewKey = config.getPrivateViewKey();
        this.privateSpendKey = config.getPrivateSpendKey();
        this.restoreHeight = config.getRestoreHeight();
        this.language = config.getLanguage();
        this.saveCurrent = config.getSaveCurrent();
        this.accountLookahead = config.getAccountLookahead();
        this.subaddressLookahead = config.getSubaddressLookahead();
        this.keysData = config.getKeysData();
        this.cacheData = config.getCacheData();
        this.isMultisig = config.isMultisig();
    }

    public MoneroWalletConfig copy() {
        return new MoneroWalletConfig(this);
    }

    public String getPath() {
        return this.path;
    }

    public MoneroWalletConfig setPath(String path) {
        this.path = path;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public MoneroWalletConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public MoneroNetworkType getNetworkType() {
        return this.networkType;
    }

    public MoneroWalletConfig setNetworkType(MoneroNetworkType networkType) {
        this.networkType = networkType;
        return this;
    }

    public MoneroWalletConfig setNetworkType(String networkTypeStr) {
        return this.setNetworkType(MoneroNetworkType.parse(networkTypeStr));
    }

    public MoneroRpcConnection getServer() {
        return this.server;
    }

    public MoneroWalletConfig setServer(MoneroRpcConnection server) {
        this.server = server;
        this.serverUsername = server == null ? null : server.getUsername();
        this.serverPassword = server == null ? null : server.getPassword();
        return this;
    }

    public String getServerUri() {
        return this.server == null ? null : this.server.getUri();
    }

    public MoneroWalletConfig setServerUri(String serverUri) {
        if (serverUri == null || serverUri.isEmpty()) {
            this.server = null;
            return this;
        }
        if (this.server == null) {
            this.server = new MoneroRpcConnection(serverUri);
        } else {
            this.server.setUri(serverUri);
        }
        if (this.serverUsername != null && this.serverPassword != null) {
            this.server.setCredentials(this.serverUsername, this.serverPassword);
        }
        return this;
    }

    public String getServerUsername() {
        return this.server == null ? null : this.server.getUsername();
    }

    public MoneroWalletConfig setServerUsername(String serverUsername) {
        this.serverUsername = serverUsername;
        if (this.server != null && serverUsername != null && this.serverPassword != null) {
            this.server.setCredentials(serverUsername, this.serverPassword);
        }
        return this;
    }

    public String getServerPassword() {
        return this.server == null ? null : this.server.getPassword();
    }

    public MoneroWalletConfig setServerPassword(String serverPassword) {
        this.serverPassword = serverPassword;
        if (this.server != null && this.serverUsername != null && serverPassword != null) {
            this.server.setCredentials(this.serverUsername, serverPassword);
        }
        return this;
    }

    @JsonIgnore
    public MoneroConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public MoneroWalletConfig setConnectionManager(MoneroConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        return this;
    }

    public String getSeed() {
        return this.seed;
    }

    public MoneroWalletConfig setSeed(String seed) {
        this.seed = seed;
        return this;
    }

    public String getSeedOffset() {
        return this.seedOffset;
    }

    public MoneroWalletConfig setSeedOffset(String seedOffset) {
        this.seedOffset = seedOffset;
        return this;
    }

    public String getPrimaryAddress() {
        return this.primaryAddress;
    }

    public MoneroWalletConfig setPrimaryAddress(String primaryAddress) {
        this.primaryAddress = primaryAddress;
        return this;
    }

    public String getPrivateViewKey() {
        return this.privateViewKey;
    }

    public MoneroWalletConfig setPrivateViewKey(String privateViewKey) {
        this.privateViewKey = privateViewKey;
        return this;
    }

    public String getPrivateSpendKey() {
        return this.privateSpendKey;
    }

    public MoneroWalletConfig setPrivateSpendKey(String privateSpendKey) {
        this.privateSpendKey = privateSpendKey;
        return this;
    }

    public Long getRestoreHeight() {
        return this.restoreHeight;
    }

    public MoneroWalletConfig setRestoreHeight(Long restoreHeight) {
        this.restoreHeight = restoreHeight;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public MoneroWalletConfig setLanguage(String language) {
        this.language = language;
        return this;
    }

    public Boolean getSaveCurrent() {
        return this.saveCurrent;
    }

    public MoneroWalletConfig setSaveCurrent(Boolean saveCurrent) {
        this.saveCurrent = saveCurrent;
        return this;
    }

    public MoneroWalletConfig setAccountLookahead(Integer accountLookahead) {
        this.accountLookahead = accountLookahead;
        return this;
    }

    public Integer getAccountLookahead() {
        return this.accountLookahead;
    }

    public MoneroWalletConfig setSubaddressLookahead(Integer subaddressLookahead) {
        this.subaddressLookahead = subaddressLookahead;
        return this;
    }

    public Integer getSubaddressLookahead() {
        return this.subaddressLookahead;
    }

    public byte[] getKeysData() {
        return this.keysData;
    }

    public MoneroWalletConfig setKeysData(byte[] keysData) {
        this.keysData = keysData;
        return this;
    }

    public byte[] getCacheData() {
        return this.cacheData;
    }

    public MoneroWalletConfig setCacheData(byte[] cacheData) {
        this.cacheData = cacheData;
        return this;
    }

    @JsonProperty(value="isMultisig")
    public Boolean isMultisig() {
        return this.isMultisig;
    }

    public MoneroWalletConfig setIsMultisig(Boolean isMultisig) {
        this.isMultisig = isMultisig;
        return this;
    }

    public String toString() {
        return JsonUtils.serialize(this);
    }
}

