/*
 * Decompiled with CFR 0.152.
 */
package net.freehaven.tor.control;

import java.util.Arrays;
import java.util.List;

final class Bytes {
    private static final char[] NYBBLES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void setU16(byte[] ba, int pos, short s2) {
        ba[pos] = (byte)(s2 >> 8 & 0xFF);
        ba[pos + 1] = (byte)(s2 & 0xFF);
    }

    public static void setU32(byte[] ba, int pos, int i) {
        ba[pos] = (byte)(i >> 24 & 0xFF);
        ba[pos + 1] = (byte)(i >> 16 & 0xFF);
        ba[pos + 2] = (byte)(i >> 8 & 0xFF);
        ba[pos + 3] = (byte)(i & 0xFF);
    }

    public static int getU32(byte[] ba, int pos) {
        return (ba[pos] & 0xFF) << 24 | (ba[pos + 1] & 0xFF) << 16 | (ba[pos + 2] & 0xFF) << 8 | ba[pos + 3] & 0xFF;
    }

    public static String getU32S(byte[] ba, int pos) {
        return String.valueOf((long)Bytes.getU32(ba, pos) & 0xFFFFFFFFL);
    }

    public static int getU16(byte[] ba, int pos) {
        return (ba[pos] & 0xFF) << 8 | ba[pos + 1] & 0xFF;
    }

    public static String getNulTerminatedStr(byte[] ba, int pos) {
        int len;
        int maxlen = ba.length - pos;
        for (len = 0; len < maxlen && ba[pos + len] != 0; ++len) {
        }
        return new String(ba, pos, len);
    }

    public static void splitStr(List<String> lst, byte[] ba, int pos, byte split) {
        while (pos < ba.length && ba[pos] != 0) {
            int len = 0;
            while (pos + len < ba.length && ba[pos + len] != 0 && ba[pos + len] != split) {
                ++len;
            }
            if (len > 0) {
                lst.add(new String(ba, pos, len));
            }
            if (ba[pos += len] != split) continue;
            ++pos;
        }
    }

    public static List<String> splitStr(List<String> lst, String str) {
        String[] tokenArray = str.split(" ", -1);
        if (lst == null) {
            lst = Arrays.asList(tokenArray);
        } else {
            lst.addAll(Arrays.asList(tokenArray));
        }
        return lst;
    }

    public static final String hex(byte[] ba) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < ba.length; ++i) {
            int b = ba[i] & 0xFF;
            buf.append(NYBBLES[b >> 4]);
            buf.append(NYBBLES[b & 0xF]);
        }
        return buf.toString();
    }

    private Bytes() {
    }
}

