/*
 * Decompiled with CFR 0.152.
 */
package net.freehaven.tor.control.examples;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.freehaven.tor.control.ConfigEntry;
import net.freehaven.tor.control.PasswordDigest;
import net.freehaven.tor.control.TorControlCommands;
import net.freehaven.tor.control.TorControlConnection;
import net.freehaven.tor.control.TorControlError;
import net.freehaven.tor.control.examples.DebuggingEventHandler;

public class Main
implements TorControlCommands {
    public static void main(String[] args2) {
        if (args2.length < 1) {
            System.err.println("No command given.");
            return;
        }
        try {
            if (args2[0].equals("set-config")) {
                Main.setConfig(args2);
            } else if (args2[0].equals("get-config")) {
                Main.getConfig(args2);
            } else if (args2[0].equals("get-info")) {
                Main.getInfo(args2);
            } else if (args2[0].equals("listen")) {
                Main.listenForEvents(args2);
            } else if (args2[0].equals("signal")) {
                Main.signal(args2);
            } else if (args2[0].equals("auth")) {
                Main.authDemo(args2);
            } else if (args2[0].equals("hs")) {
                Main.hsDemo(args2);
            } else {
                System.err.println("Unrecognized command: " + args2[0]);
            }
        }
        catch (EOFException ex) {
            System.out.println("Control socket closed by Tor.");
        }
        catch (TorControlError ex) {
            System.err.println("Error from Tor process: " + ex + " [" + ex.getErrorMsg() + "]");
        }
        catch (IOException ex) {
            System.err.println("IO exception when talking to Tor process: " + ex);
            ex.printStackTrace(System.err);
        }
    }

    private static TorControlConnection getConnection(String[] args2, boolean daemon) throws IOException {
        Socket s2 = new Socket("127.0.0.1", 9100);
        TorControlConnection conn = new TorControlConnection(s2);
        conn.launchThread(daemon);
        conn.authenticate(new byte[0]);
        return conn;
    }

    private static TorControlConnection getConnection(String[] args2) throws IOException {
        return Main.getConnection(args2, true);
    }

    private static void hsDemo(String[] args2) throws IOException {
        Socket s2 = new Socket("127.0.0.1", 9151);
        TorControlConnection conn = new TorControlConnection(s2);
        conn.launchThread(true);
        conn.authenticate(new byte[0]);
        conn.setEventHandler(new DebuggingEventHandler(new PrintWriter(System.out, true)));
        conn.setEvents(Arrays.asList("EXTENDED", "CIRC", "ORCONN", "INFO", "NOTICE", "WARN", "ERR", "HS_DESC", "HS_DESC_CONTENT"));
        TorControlConnection.CreateHiddenServiceResult result = conn.createHiddenService(10026);
        conn.destroyHiddenService(result.serviceID);
        conn.createHiddenService((Integer)10026, result.privateKey);
    }

    public static void setConfig(String[] args2) throws IOException {
        TorControlConnection conn = Main.getConnection(args2);
        ArrayList<String> lst = new ArrayList<String>();
        int i = 1;
        boolean save = false;
        if (args2[i].equals("-save")) {
            save = true;
            ++i;
        }
        while (i < args2.length) {
            lst.add(args2[i] + " " + args2[i + 1]);
            i += 2;
        }
        conn.setConf(lst);
        if (save) {
            conn.saveConf();
        }
    }

    public static void getConfig(String[] args2) throws IOException {
        TorControlConnection conn = Main.getConnection(args2);
        List<ConfigEntry> lst = conn.getConf(Arrays.asList(args2).subList(1, args2.length));
        for (ConfigEntry e : lst) {
            System.out.println("KEY: " + e.key);
            System.out.println("VAL: " + e.value);
        }
    }

    public static void getInfo(String[] args2) throws IOException {
        TorControlConnection conn = Main.getConnection(args2);
        Map<String, String> m4 = conn.getInfo(Arrays.asList(args2).subList(1, args2.length));
        for (Map.Entry<String, String> e : m4.entrySet()) {
            System.out.println("KEY: " + e.getKey());
            System.out.println("VAL: " + e.getValue());
        }
    }

    public static void listenForEvents(String[] args2) throws IOException {
        TorControlConnection conn = Main.getConnection(args2, false);
        ArrayList<String> lst = new ArrayList<String>();
        for (int i = 1; i < args2.length; ++i) {
            lst.add(args2[i]);
        }
        conn.setEventHandler(new DebuggingEventHandler(new PrintWriter(System.out, true)));
        conn.setEvents(lst);
    }

    public static void signal(String[] args2) throws IOException {
        TorControlConnection conn = Main.getConnection(args2, false);
        if ("SHUTDOWN".equalsIgnoreCase(args2[1]) || "HALT".equalsIgnoreCase(args2[1])) {
            conn.shutdownTor(args2[1].toUpperCase());
        } else {
            conn.signal(args2[1].toUpperCase());
        }
    }

    public static void authDemo(String[] args2) throws IOException {
        PasswordDigest pwd = PasswordDigest.generateDigest();
        Socket s2 = new Socket("127.0.0.1", 9100);
        TorControlConnection conn = new TorControlConnection(s2);
        conn.launchThread(true);
        conn.authenticate(new byte[0]);
        conn.setConf("HashedControlPassword", pwd.getHashedPassword());
        s2 = new Socket("127.0.0.1", 9100);
        conn = new TorControlConnection(s2);
        conn.launchThread(true);
        conn.authenticate(pwd.getSecret());
    }
}

