/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import java.io.Closeable;
import java.net.Socket;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import net.freehaven.tor.control.TorControlConnection;
import org.berndpruenster.netlayer.tor.TorKt;
import org.berndpruenster.netlayer.tor.TraceStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/berndpruenster/netlayer/tor/TorController;", "Lnet/freehaven/tor/control/TorControlConnection;", "socket", "Ljava/net/Socket;", "(Ljava/net/Socket;)V", "bootstrapped", "", "getBootstrapped", "()Z", "enableNetwork", "", "shutdown", "tor"})
public final class TorController
extends TorControlConnection {
    private final Socket socket;

    public final boolean getBootstrapped() {
        String string = this.getInfo("status/bootstrap-phase");
        return string != null ? StringsKt.contains$default((CharSequence)string, "PROGRESS=100", false, 2, null) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        Closeable closeable = this.socket;
        boolean bl = false;
        Throwable throwable = null;
        try {
            Socket it = (Socket)closeable;
            boolean bl2 = false;
            KLogger kLogger = TorKt.getLogger();
            if (kLogger != null) {
                kLogger.debug("Stopping Tor");
            }
            this.setConf("DisableNetwork", "1");
            this.shutdownTor("TERM");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public final void enableNetwork() {
        this.setConf("DisableNetwork", "0");
    }

    public TorController(@NotNull Socket socket) {
        Intrinsics.checkParameterIsNotNull(socket, "socket");
        super(socket);
        this.socket = socket;
        if (TorKt.getLogger() != null) {
            super.setDebugging(new TraceStream(TorKt.getLogger()));
        }
    }
}

