/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PrefixedChecksummedBytes;
import org.bitcoinj.params.Networks;

public class DumpedPrivateKey
extends PrefixedChecksummedBytes {
    public static DumpedPrivateKey fromBase58(@Nullable NetworkParameters params, String base58) throws AddressFormatException, AddressFormatException.WrongNetwork {
        byte[] versionAndDataBytes = Base58.decodeChecked(base58);
        int version = versionAndDataBytes[0] & 0xFF;
        byte[] bytes = Arrays.copyOfRange(versionAndDataBytes, 1, versionAndDataBytes.length);
        if (params == null) {
            for (NetworkParameters networkParameters : Networks.get()) {
                if (version != networkParameters.getDumpedPrivateKeyHeader()) continue;
                return new DumpedPrivateKey(networkParameters, bytes);
            }
            throw new AddressFormatException.InvalidPrefix("No network found for version " + version);
        }
        if (version == params.getDumpedPrivateKeyHeader()) {
            return new DumpedPrivateKey(params, bytes);
        }
        throw new AddressFormatException.WrongNetwork(version);
    }

    private DumpedPrivateKey(NetworkParameters params, byte[] bytes) {
        super(params, bytes);
        if (bytes.length != 32 && bytes.length != 33) {
            throw new AddressFormatException.InvalidDataLength("Wrong number of bytes for a private key (32 or 33): " + bytes.length);
        }
    }

    DumpedPrivateKey(NetworkParameters params, byte[] keyBytes, boolean compressed) {
        this(params, DumpedPrivateKey.encode(keyBytes, compressed));
    }

    public String toBase58() {
        return Base58.encodeChecked(this.params.getDumpedPrivateKeyHeader(), this.bytes);
    }

    private static byte[] encode(byte[] keyBytes, boolean compressed) {
        Preconditions.checkArgument(keyBytes.length == 32, "Private keys must be 32 bytes");
        if (!compressed) {
            return keyBytes;
        }
        byte[] bytes = new byte[33];
        System.arraycopy(keyBytes, 0, bytes, 0, 32);
        bytes[32] = 1;
        return bytes;
    }

    public ECKey getKey() {
        return ECKey.fromPrivate(Arrays.copyOf(this.bytes, 32), this.isPubKeyCompressed());
    }

    public boolean isPubKeyCompressed() {
        return this.bytes.length == 33 && this.bytes[32] == 1;
    }

    public String toString() {
        return this.toBase58();
    }
}

