/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.params.Networks;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptPattern;

public class LegacyAddress
extends Address {
    public static final int LENGTH = 20;
    public final boolean p2sh;

    private LegacyAddress(NetworkParameters params, boolean p2sh, byte[] hash160) throws AddressFormatException {
        super(params, hash160);
        if (hash160.length != 20) {
            throw new AddressFormatException.InvalidDataLength("Legacy addresses are 20 byte (160 bit) hashes, but got: " + hash160.length);
        }
        this.p2sh = p2sh;
    }

    public static LegacyAddress fromPubKeyHash(NetworkParameters params, byte[] hash160) throws AddressFormatException {
        return new LegacyAddress(params, false, hash160);
    }

    public static LegacyAddress fromKey(NetworkParameters params, ECKey key) {
        return LegacyAddress.fromPubKeyHash(params, key.getPubKeyHash());
    }

    public static LegacyAddress fromScriptHash(NetworkParameters params, byte[] hash160) throws AddressFormatException {
        return new LegacyAddress(params, true, hash160);
    }

    @Deprecated
    public static LegacyAddress fromP2SHHash(NetworkParameters params, byte[] hash160) {
        return LegacyAddress.fromScriptHash(params, hash160);
    }

    @Deprecated
    public static LegacyAddress fromP2SHScript(NetworkParameters params, Script scriptPubKey) {
        Preconditions.checkArgument(ScriptPattern.isP2SH(scriptPubKey), "Not a P2SH script");
        return LegacyAddress.fromScriptHash(params, ScriptPattern.extractHashFromP2SH(scriptPubKey));
    }

    public static LegacyAddress fromBase58(@Nullable NetworkParameters params, String base58) throws AddressFormatException, AddressFormatException.WrongNetwork {
        byte[] versionAndDataBytes = Base58.decodeChecked(base58);
        int version = versionAndDataBytes[0] & 0xFF;
        byte[] bytes = Arrays.copyOfRange(versionAndDataBytes, 1, versionAndDataBytes.length);
        if (params == null) {
            for (NetworkParameters networkParameters : Networks.get()) {
                if (version == networkParameters.getAddressHeader()) {
                    return new LegacyAddress(networkParameters, false, bytes);
                }
                if (version != networkParameters.getP2SHHeader()) continue;
                return new LegacyAddress(networkParameters, true, bytes);
            }
            throw new AddressFormatException.InvalidPrefix("No network found for " + base58);
        }
        if (version == params.getAddressHeader()) {
            return new LegacyAddress(params, false, bytes);
        }
        if (version == params.getP2SHHeader()) {
            return new LegacyAddress(params, true, bytes);
        }
        throw new AddressFormatException.WrongNetwork(version);
    }

    @Deprecated
    public LegacyAddress(NetworkParameters params, byte[] hash160) throws AddressFormatException {
        this(params, false, hash160);
    }

    public int getVersion() {
        return this.p2sh ? this.params.getP2SHHeader() : this.params.getAddressHeader();
    }

    public String toBase58() {
        return Base58.encodeChecked(this.getVersion(), this.bytes);
    }

    @Deprecated
    public byte[] getHash160() {
        return this.getHash();
    }

    @Override
    public byte[] getHash() {
        return this.bytes;
    }

    @Override
    public Script.ScriptType getOutputScriptType() {
        return this.p2sh ? Script.ScriptType.P2SH : Script.ScriptType.P2PKH;
    }

    @Deprecated
    public boolean isP2SHAddress() {
        return this.p2sh;
    }

    public static NetworkParameters getParametersFromAddress(String address) throws AddressFormatException {
        return LegacyAddress.fromBase58(null, address).getParameters();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacyAddress other = (LegacyAddress)o;
        return super.equals(other) && this.p2sh == other.p2sh;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.p2sh);
    }

    public String toString() {
        return this.toBase58();
    }

    @Override
    public LegacyAddress clone() throws CloneNotSupportedException {
        return (LegacyAddress)super.clone();
    }
}

