/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.AddressMessage;
import org.bitcoinj.core.AlertMessage;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.BlockLocator;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.FilteredBlock;
import org.bitcoinj.core.GetAddrMessage;
import org.bitcoinj.core.GetBlocksMessage;
import org.bitcoinj.core.GetDataMessage;
import org.bitcoinj.core.GetHeadersMessage;
import org.bitcoinj.core.GetUTXOsMessage;
import org.bitcoinj.core.HeadersMessage;
import org.bitcoinj.core.InventoryItem;
import org.bitcoinj.core.InventoryMessage;
import org.bitcoinj.core.MemoryPoolMessage;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.NotFoundMessage;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.PeerSocketHandler;
import org.bitcoinj.core.Ping;
import org.bitcoinj.core.Pong;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.PrunedException;
import org.bitcoinj.core.RejectMessage;
import org.bitcoinj.core.SendHeadersMessage;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.UTXOsMessage;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.VersionAck;
import org.bitcoinj.core.VersionMessage;
import org.bitcoinj.core.listeners.BlocksDownloadedEventListener;
import org.bitcoinj.core.listeners.ChainDownloadStartedEventListener;
import org.bitcoinj.core.listeners.GetDataEventListener;
import org.bitcoinj.core.listeners.OnTransactionBroadcastListener;
import org.bitcoinj.core.listeners.PeerConnectedEventListener;
import org.bitcoinj.core.listeners.PeerDisconnectedEventListener;
import org.bitcoinj.core.listeners.PreMessageReceivedEventListener;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.utils.ListenerRegistration;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.Wallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer
extends PeerSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(Peer.class);
    protected final ReentrantLock lock = Threading.lock("peer");
    private final NetworkParameters params;
    private final AbstractBlockChain blockChain;
    private final long requiredServices;
    private final Context context;
    private final CopyOnWriteArrayList<ListenerRegistration<BlocksDownloadedEventListener>> blocksDownloadedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<ChainDownloadStartedEventListener>> chainDownloadStartedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<PeerConnectedEventListener>> connectedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<PeerDisconnectedEventListener>> disconnectedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<GetDataEventListener>> getDataEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<PreMessageReceivedEventListener>> preMessageReceivedEventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<OnTransactionBroadcastListener>> onTransactionEventListeners = new CopyOnWriteArrayList();
    private volatile boolean vDownloadData;
    private final VersionMessage versionMessage;
    private volatile int vDownloadTxDependencyDepth;
    private final AtomicInteger blocksAnnounced = new AtomicInteger();
    private final CopyOnWriteArrayList<Wallet> wallets;
    @GuardedBy(value="lock")
    private long fastCatchupTimeSecs;
    @GuardedBy(value="lock")
    private boolean downloadBlockBodies = true;
    @GuardedBy(value="lock")
    private boolean useFilteredBlocks = false;
    private volatile BloomFilter vBloomFilter;
    private FilteredBlock currentFilteredBlock = null;
    @GuardedBy(value="lock")
    @Nullable
    private List<Sha256Hash> awaitingFreshFilter;
    private final HashSet<Sha256Hash> pendingBlockDownloads = new HashSet();
    private final HashSet<TransactionConfidence> pendingTxDownloads = new HashSet();
    private static final int PENDING_TX_DOWNLOADS_LIMIT = 100;
    private volatile int vMinProtocolVersion;
    private final CopyOnWriteArrayList<GetDataRequest> getDataFutures;
    @GuardedBy(value="getAddrFutures")
    private final LinkedList<SettableFuture<AddressMessage>> getAddrFutures;
    @Nullable
    @GuardedBy(value="lock")
    private LinkedList<SettableFuture<UTXOsMessage>> getutxoFutures;
    private final ReentrantLock lastPingTimesLock = new ReentrantLock();
    @GuardedBy(value="lastPingTimesLock")
    private long[] lastPingTimes = null;
    private final CopyOnWriteArrayList<PendingPing> pendingPings;
    private static final int PENDING_PINGS_LIMIT = 50;
    private static final int PING_MOVING_AVERAGE_WINDOW = 20;
    private volatile VersionMessage vPeerVersionMessage;
    private final SettableFuture<Peer> connectionOpenFuture = SettableFuture.create();
    private final SettableFuture<Peer> outgoingVersionHandshakeFuture = SettableFuture.create();
    private final SettableFuture<Peer> incomingVersionHandshakeFuture = SettableFuture.create();
    private final ListenableFuture<Peer> versionHandshakeFuture = Futures.transform(Futures.allAsList(this.outgoingVersionHandshakeFuture, this.incomingVersionHandshakeFuture), new Function<List<Peer>, Peer>(){

        @Override
        @Nullable
        public Peer apply(@Nullable List<Peer> peers) {
            Preconditions.checkNotNull(peers);
            Preconditions.checkState(peers.size() == 2 && peers.get(0) == peers.get(1));
            return peers.get(0);
        }
    }, MoreExecutors.directExecutor());
    @GuardedBy(value="lock")
    private Sha256Hash lastGetBlocksBegin;
    @GuardedBy(value="lock")
    private Sha256Hash lastGetBlocksEnd;

    public Peer(NetworkParameters params, VersionMessage ver, @Nullable AbstractBlockChain chain, PeerAddress remoteAddress) {
        this(params, ver, remoteAddress, chain);
    }

    public Peer(NetworkParameters params, VersionMessage ver, PeerAddress remoteAddress, @Nullable AbstractBlockChain chain) {
        this(params, ver, remoteAddress, chain, 0L, Integer.MAX_VALUE);
    }

    public Peer(NetworkParameters params, VersionMessage ver, PeerAddress remoteAddress, @Nullable AbstractBlockChain chain, long requiredServices, int downloadTxDependencyDepth) {
        super(params, remoteAddress);
        this.params = Preconditions.checkNotNull(params);
        this.versionMessage = Preconditions.checkNotNull(ver);
        this.vDownloadTxDependencyDepth = chain != null ? downloadTxDependencyDepth : 0;
        this.blockChain = chain;
        this.requiredServices = requiredServices;
        this.vDownloadData = chain != null;
        this.getDataFutures = new CopyOnWriteArrayList();
        this.getAddrFutures = new LinkedList();
        this.fastCatchupTimeSecs = params.getGenesisBlock().getTimeSeconds();
        this.pendingPings = new CopyOnWriteArrayList();
        this.vMinProtocolVersion = params.getProtocolVersionNum(NetworkParameters.ProtocolVersion.PONG);
        this.wallets = new CopyOnWriteArrayList();
        this.context = Context.get();
        this.versionHandshakeFuture.addListener(new Runnable(){

            @Override
            public void run() {
                Peer.this.versionHandshakeComplete();
            }
        }, Threading.SAME_THREAD);
    }

    public Peer(NetworkParameters params, AbstractBlockChain blockChain, PeerAddress peerAddress, String thisSoftwareName, String thisSoftwareVersion) {
        this(params, new VersionMessage(params, blockChain.getBestChainHeight()), blockChain, peerAddress);
        this.versionMessage.appendToSubVer(thisSoftwareName, thisSoftwareVersion, null);
    }

    public void addBlocksDownloadedEventListener(BlocksDownloadedEventListener listener) {
        this.addBlocksDownloadedEventListener(Threading.USER_THREAD, listener);
    }

    public void addBlocksDownloadedEventListener(Executor executor, BlocksDownloadedEventListener listener) {
        this.blocksDownloadedEventListeners.add(new ListenerRegistration<BlocksDownloadedEventListener>(listener, executor));
    }

    public void addChainDownloadStartedEventListener(ChainDownloadStartedEventListener listener) {
        this.addChainDownloadStartedEventListener(Threading.USER_THREAD, listener);
    }

    public void addChainDownloadStartedEventListener(Executor executor, ChainDownloadStartedEventListener listener) {
        this.chainDownloadStartedEventListeners.add(new ListenerRegistration<ChainDownloadStartedEventListener>(listener, executor));
    }

    public void addConnectedEventListener(PeerConnectedEventListener listener) {
        this.addConnectedEventListener(Threading.USER_THREAD, listener);
    }

    public void addConnectedEventListener(Executor executor, PeerConnectedEventListener listener) {
        this.connectedEventListeners.add(new ListenerRegistration<PeerConnectedEventListener>(listener, executor));
    }

    public void addDisconnectedEventListener(PeerDisconnectedEventListener listener) {
        this.addDisconnectedEventListener(Threading.USER_THREAD, listener);
    }

    public void addDisconnectedEventListener(Executor executor, PeerDisconnectedEventListener listener) {
        this.disconnectedEventListeners.add(new ListenerRegistration<PeerDisconnectedEventListener>(listener, executor));
    }

    public void addGetDataEventListener(GetDataEventListener listener) {
        this.addGetDataEventListener(Threading.USER_THREAD, listener);
    }

    public void addGetDataEventListener(Executor executor, GetDataEventListener listener) {
        this.getDataEventListeners.add(new ListenerRegistration<GetDataEventListener>(listener, executor));
    }

    public void addOnTransactionBroadcastListener(OnTransactionBroadcastListener listener) {
        this.addOnTransactionBroadcastListener(Threading.USER_THREAD, listener);
    }

    public void addOnTransactionBroadcastListener(Executor executor, OnTransactionBroadcastListener listener) {
        this.onTransactionEventListeners.add(new ListenerRegistration<OnTransactionBroadcastListener>(listener, executor));
    }

    public void addPreMessageReceivedEventListener(PreMessageReceivedEventListener listener) {
        this.addPreMessageReceivedEventListener(Threading.USER_THREAD, listener);
    }

    public void addPreMessageReceivedEventListener(Executor executor, PreMessageReceivedEventListener listener) {
        this.preMessageReceivedEventListeners.add(new ListenerRegistration<PreMessageReceivedEventListener>(listener, executor));
    }

    public boolean removeBlocksDownloadedEventListener(BlocksDownloadedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.blocksDownloadedEventListeners);
    }

    public boolean removeChainDownloadStartedEventListener(ChainDownloadStartedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.chainDownloadStartedEventListeners);
    }

    public boolean removeConnectedEventListener(PeerConnectedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.connectedEventListeners);
    }

    public boolean removeDisconnectedEventListener(PeerDisconnectedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.disconnectedEventListeners);
    }

    public boolean removeGetDataEventListener(GetDataEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.getDataEventListeners);
    }

    public boolean removeOnTransactionBroadcastListener(OnTransactionBroadcastListener listener) {
        return ListenerRegistration.removeFromList(listener, this.onTransactionEventListeners);
    }

    public boolean removePreMessageReceivedEventListener(PreMessageReceivedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.preMessageReceivedEventListeners);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this).omitNullValues();
        helper.addValue(this.getAddress());
        helper.add("version", this.vPeerVersionMessage.clientVersion);
        helper.add("subVer", this.vPeerVersionMessage.subVer);
        String servicesStr = Strings.emptyToNull(VersionMessage.toStringServices(this.vPeerVersionMessage.localServices));
        helper.add("services", this.vPeerVersionMessage.localServices + (servicesStr != null ? " (" + servicesStr + ")" : ""));
        long peerTime = this.vPeerVersionMessage.time * 1000L;
        helper.add("time", String.format(Locale.US, "%tF %tT", peerTime, peerTime));
        helper.add("height", this.vPeerVersionMessage.bestHeight);
        return helper.toString();
    }

    @Deprecated
    public String toStringServices(long services) {
        return VersionMessage.toStringServices(services);
    }

    @Override
    protected void timeoutOccurred() {
        super.timeoutOccurred();
        if (!this.connectionOpenFuture.isDone()) {
            this.connectionClosed();
        }
    }

    @Override
    public void connectionClosed() {
        for (final ListenerRegistration<PeerDisconnectedEventListener> registration : this.disconnectedEventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((PeerDisconnectedEventListener)registration.listener).onPeerDisconnected(Peer.this, 0);
                }
            });
        }
    }

    @Override
    public void connectionOpened() {
        PeerAddress address = this.getAddress();
        log.info("Announcing to {} as: {}", address == null ? "Peer" : address.toSocketAddress(), (Object)this.versionMessage.subVer);
        this.sendMessage(this.versionMessage);
        this.connectionOpenFuture.set(this);
    }

    public ListenableFuture<Peer> getConnectionOpenFuture() {
        return this.connectionOpenFuture;
    }

    public ListenableFuture<Peer> getVersionHandshakeFuture() {
        return this.versionHandshakeFuture;
    }

    @Override
    protected void processMessage(Message m4) throws Exception {
        for (ListenerRegistration<PreMessageReceivedEventListener> registration : this.preMessageReceivedEventListeners) {
            if (registration.executor != Threading.SAME_THREAD || (m4 = ((PreMessageReceivedEventListener)registration.listener).onPreMessageReceived(this, m4)) != null) continue;
            break;
        }
        if (m4 == null) {
            return;
        }
        if (this.currentFilteredBlock != null && !(m4 instanceof Transaction)) {
            this.endFilteredBlock(this.currentFilteredBlock);
            this.currentFilteredBlock = null;
        }
        if (!(m4 instanceof VersionMessage || m4 instanceof VersionAck || this.versionHandshakeFuture.isDone() && !this.versionHandshakeFuture.isCancelled())) {
            throw new ProtocolException("Received " + m4.getClass().getSimpleName() + " before version handshake is complete.");
        }
        if (m4 instanceof Ping) {
            this.processPing((Ping)m4);
        } else if (m4 instanceof Pong) {
            this.processPong((Pong)m4);
        } else if (m4 instanceof NotFoundMessage) {
            this.processNotFoundMessage((NotFoundMessage)m4);
        } else if (m4 instanceof InventoryMessage) {
            this.processInv((InventoryMessage)m4);
        } else if (m4 instanceof Block) {
            this.processBlock((Block)m4);
        } else if (m4 instanceof FilteredBlock) {
            this.startFilteredBlock((FilteredBlock)m4);
        } else if (m4 instanceof Transaction) {
            this.processTransaction((Transaction)m4);
        } else if (m4 instanceof GetDataMessage) {
            this.processGetData((GetDataMessage)m4);
        } else if (m4 instanceof AddressMessage) {
            this.processAddressMessage((AddressMessage)m4);
        } else if (m4 instanceof HeadersMessage) {
            this.processHeaders((HeadersMessage)m4);
        } else if (m4 instanceof AlertMessage) {
            this.processAlert((AlertMessage)m4);
        } else if (m4 instanceof VersionMessage) {
            this.processVersionMessage((VersionMessage)m4);
        } else if (m4 instanceof VersionAck) {
            this.processVersionAck((VersionAck)m4);
        } else if (m4 instanceof UTXOsMessage) {
            this.processUTXOMessage((UTXOsMessage)m4);
        } else if (m4 instanceof RejectMessage) {
            log.error("{} {}: Received {}", this, this.getPeerVersionMessage().subVer, m4);
        } else if (!(m4 instanceof SendHeadersMessage)) {
            log.warn("{}: Received unhandled message: {}", (Object)this, (Object)m4);
        }
    }

    protected void processUTXOMessage(UTXOsMessage m4) {
        SettableFuture<UTXOsMessage> future = null;
        this.lock.lock();
        try {
            if (this.getutxoFutures != null) {
                future = this.getutxoFutures.pollFirst();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (future != null) {
            future.set(m4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAddressMessage(AddressMessage m4) {
        SettableFuture<AddressMessage> future;
        LinkedList<SettableFuture<AddressMessage>> linkedList = this.getAddrFutures;
        synchronized (linkedList) {
            future = this.getAddrFutures.poll();
            if (future == null) {
                return;
            }
        }
        future.set(m4);
    }

    private void processVersionMessage(VersionMessage peerVersionMessage) throws ProtocolException {
        if (this.vPeerVersionMessage != null) {
            throw new ProtocolException("Got two version messages from peer");
        }
        this.vPeerVersionMessage = peerVersionMessage;
        log.info(this.toString());
        if (!peerVersionMessage.hasLimitedBlockChain() || !this.params.allowEmptyPeerChain() && peerVersionMessage.bestHeight == 0L) {
            log.info("{}: Peer does not have at least a recent part of the block chain.", (Object)this);
            this.close();
            return;
        }
        if ((peerVersionMessage.localServices & this.requiredServices) != this.requiredServices) {
            log.info("{}: Peer doesn't support these required services: {}", (Object)this, (Object)VersionMessage.toStringServices(this.requiredServices & (peerVersionMessage.localServices ^ 0xFFFFFFFFFFFFFFFFL)));
            this.close();
            return;
        }
        if ((peerVersionMessage.localServices & 0x20L) == 32L) {
            log.info("{}: Peer follows an incompatible block chain.", (Object)this);
            this.close();
            return;
        }
        if (peerVersionMessage.bestHeight < 0L) {
            throw new ProtocolException("Peer reports invalid best height: " + peerVersionMessage.bestHeight);
        }
        this.sendMessage(new VersionAck());
        if (log.isDebugEnabled()) {
            log.debug("{}: Incoming version handshake complete.", (Object)this);
        }
        this.incomingVersionHandshakeFuture.set(this);
    }

    private void processVersionAck(VersionAck m4) throws ProtocolException {
        if (this.vPeerVersionMessage == null) {
            throw new ProtocolException("got a version ack before version");
        }
        if (this.outgoingVersionHandshakeFuture.isDone()) {
            throw new ProtocolException("got more than one version ack");
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: Outgoing version handshake complete.", (Object)this);
        }
        this.outgoingVersionHandshakeFuture.set(this);
    }

    private void versionHandshakeComplete() {
        if (log.isDebugEnabled()) {
            log.debug("{}: Handshake complete.", (Object)this);
        }
        this.setTimeoutEnabled(false);
        for (final ListenerRegistration<PeerConnectedEventListener> registration : this.connectedEventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((PeerConnectedEventListener)registration.listener).onPeerConnected(Peer.this, 1);
                }
            });
        }
        int version = this.vMinProtocolVersion;
        if (this.vPeerVersionMessage.clientVersion < version) {
            log.warn("Connected to a peer speaking protocol version {} but need {}, closing", (Object)this.vPeerVersionMessage.clientVersion, (Object)version);
            this.close();
        }
    }

    protected void startFilteredBlock(FilteredBlock m4) {
        this.currentFilteredBlock = m4;
    }

    protected void processNotFoundMessage(NotFoundMessage m4) {
        block0: for (GetDataRequest req : this.getDataFutures) {
            for (InventoryItem item : m4.getItems()) {
                if (!item.hash.equals(req.hash)) continue;
                log.info("{}: Bottomed out dep tree at {}", (Object)this, (Object)req.hash);
                req.future.cancel(true);
                this.getDataFutures.remove(req);
                continue block0;
            }
        }
    }

    protected void processAlert(AlertMessage m4) {
        try {
            if (log.isDebugEnabled()) {
                if (m4.isSignatureValid()) {
                    log.debug("Received alert from peer {}: {}", (Object)this, (Object)m4.getStatusBar());
                } else {
                    log.debug("Received alert with invalid signature from peer {}: {}", (Object)this, (Object)m4.getStatusBar());
                }
            }
        }
        catch (Throwable t2) {
            log.error("Failed to check signature: bug in platform libraries?", t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processHeaders(HeadersMessage m4) throws ProtocolException {
        block21: {
            boolean downloadBlockBodies;
            long fastCatchupTimeSecs;
            this.lock.lock();
            try {
                if (this.blockChain == null) {
                    log.warn("Received headers when Peer is not configured with a chain.");
                    return;
                }
                fastCatchupTimeSecs = this.fastCatchupTimeSecs;
                downloadBlockBodies = this.downloadBlockBodies;
            }
            finally {
                this.lock.unlock();
            }
            try {
                Preconditions.checkState(!downloadBlockBodies, this.toString());
                for (int i = 0; i < m4.getBlockHeaders().size(); ++i) {
                    boolean reachedTop;
                    Block header = m4.getBlockHeaders().get(i);
                    boolean passedTime = header.getTimeSeconds() >= fastCatchupTimeSecs;
                    boolean bl = reachedTop = (long)this.blockChain.getBestChainHeight() >= this.vPeerVersionMessage.bestHeight;
                    if (!passedTime && !reachedTop) {
                        if (!this.vDownloadData) {
                            log.info("Lost download peer status, throwing away downloaded headers.");
                            return;
                        }
                        if (!this.blockChain.add(header)) {
                            throw new ProtocolException("Got unconnected header from peer: " + header.getHashAsString());
                        }
                    } else {
                        this.lock.lock();
                        try {
                            log.info("Passed the fast catchup time ({}) at height {}, discarding {} headers and requesting full blocks", Utils.dateTimeFormat(fastCatchupTimeSecs * 1000L), this.blockChain.getBestChainHeight() + 1, m4.getBlockHeaders().size() - i);
                            this.downloadBlockBodies = true;
                            this.lastGetBlocksBegin = Sha256Hash.ZERO_HASH;
                            this.blockChainDownloadLocked(Sha256Hash.ZERO_HASH);
                        }
                        finally {
                            this.lock.unlock();
                        }
                        return;
                    }
                    this.invokeOnBlocksDownloaded(header, null);
                }
                if (m4.getBlockHeaders().size() < 2000) break block21;
                this.lock.lock();
                try {
                    this.blockChainDownloadLocked(Sha256Hash.ZERO_HASH);
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (VerificationException e) {
                log.warn("Block header verification failed", e);
            }
            catch (PrunedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void processGetData(GetDataMessage getdata) {
        log.info("{}: Received getdata message: {}", (Object)this.getAddress(), (Object)getdata.toString());
        ArrayList<Message> items = new ArrayList<Message>();
        for (ListenerRegistration<GetDataEventListener> registration : this.getDataEventListeners) {
            List<Message> listenerItems;
            if (registration.executor != Threading.SAME_THREAD || (listenerItems = ((GetDataEventListener)registration.listener).getData(this, getdata)) == null) continue;
            items.addAll(listenerItems);
        }
        if (items.isEmpty()) {
            return;
        }
        log.info("{}: Sending {} items gathered from listeners to peer", (Object)this.getAddress(), (Object)items.size());
        for (Message item : items) {
            this.sendMessage(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTransaction(final Transaction tx) throws VerificationException {
        tx.verify();
        this.lock.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug("{}: Received tx {}", (Object)this.getAddress(), (Object)tx.getTxId());
            }
            TransactionConfidence confidence = tx.getConfidence();
            confidence.setSource(TransactionConfidence.Source.NETWORK);
            this.pendingTxDownloads.remove(confidence);
            if (this.maybeHandleRequestedData(tx)) {
                return;
            }
            if (this.currentFilteredBlock != null) {
                if (!this.currentFilteredBlock.provideTransaction(tx)) {
                    this.endFilteredBlock(this.currentFilteredBlock);
                    this.currentFilteredBlock = null;
                }
                return;
            }
            for (final Wallet wallet : this.wallets) {
                try {
                    if (!wallet.isPendingTransactionRelevant(tx)) continue;
                    if (this.vDownloadTxDependencyDepth > 0) {
                        Futures.addCallback(this.downloadDependencies(tx), new FutureCallback<List<Transaction>>(){

                            @Override
                            public void onSuccess(List<Transaction> dependencies) {
                                try {
                                    log.info("{}: Dependency download complete!", (Object)Peer.this.getAddress());
                                    wallet.receivePending(tx, dependencies);
                                }
                                catch (VerificationException e) {
                                    log.error("{}: Wallet failed to process pending transaction {}", (Object)Peer.this.getAddress(), (Object)tx.getTxId());
                                    log.error("Error was: ", e);
                                }
                            }

                            @Override
                            public void onFailure(Throwable throwable) {
                                log.error("Could not download dependencies of tx {}", (Object)tx.getTxId());
                                log.error("Error was: ", throwable);
                            }
                        }, MoreExecutors.directExecutor());
                        continue;
                    }
                    wallet.receivePending(tx, null);
                }
                catch (VerificationException e) {
                    log.error("Wallet failed to verify tx", e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        for (final ListenerRegistration<OnTransactionBroadcastListener> registration : this.onTransactionEventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((OnTransactionBroadcastListener)registration.listener).onTransaction(Peer.this, tx);
                }
            });
        }
    }

    public ListenableFuture<List<Transaction>> downloadDependencies(Transaction tx) {
        TransactionConfidence.ConfidenceType txConfidence = tx.getConfidence().getConfidenceType();
        Preconditions.checkArgument(txConfidence != TransactionConfidence.ConfidenceType.BUILDING);
        log.info("{}: Downloading dependencies of {}", (Object)this.getAddress(), (Object)tx.getTxId());
        final LinkedList<Transaction> results = new LinkedList<Transaction>();
        ListenableFuture<Object> future = this.downloadDependenciesInternal(this.vDownloadTxDependencyDepth, 0, tx, new Object(), results);
        final SettableFuture<List<Transaction>> resultFuture = SettableFuture.create();
        Futures.addCallback(future, new FutureCallback<Object>(){

            @Override
            public void onSuccess(Object ignored) {
                resultFuture.set(results);
            }

            @Override
            public void onFailure(Throwable throwable) {
                resultFuture.setException(throwable);
            }
        }, MoreExecutors.directExecutor());
        return resultFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListenableFuture<Object> downloadDependenciesInternal(final int maxDepth, final int depth, Transaction tx, final Object marker, final List<Transaction> results) {
        final SettableFuture<Object> resultFuture = SettableFuture.create();
        final Sha256Hash rootTxHash = tx.getTxId();
        CopyOnWriteArraySet<Sha256Hash> needToRequest = new CopyOnWriteArraySet<Sha256Hash>();
        for (TransactionInput input : tx.getInputs()) {
            needToRequest.add(input.getOutpoint().getHash());
        }
        this.lock.lock();
        try {
            ArrayList<SettableFuture> futures = Lists.newArrayList();
            GetDataMessage getdata = new GetDataMessage(this.params);
            if (needToRequest.size() > 1) {
                log.info("{}: Requesting {} transactions for depth {} dep resolution", this.getAddress(), needToRequest.size(), depth + 1);
            }
            for (Sha256Hash hash : needToRequest) {
                getdata.addTransaction(hash, this.vPeerVersionMessage.isWitnessSupported());
                GetDataRequest req = new GetDataRequest(hash, SettableFuture.create());
                futures.add(req.future);
                this.getDataFutures.add(req);
            }
            ListenableFuture successful = Futures.successfulAsList(futures);
            Futures.addCallback(successful, new FutureCallback<List<Transaction>>(){

                @Override
                public void onSuccess(List<Transaction> transactions) {
                    LinkedList<ListenableFuture<Object>> childFutures = Lists.newLinkedList();
                    for (Transaction tx : transactions) {
                        if (tx == null) continue;
                        log.info("{}: Downloaded dependency of {}: {}", Peer.this.getAddress(), rootTxHash, tx.getTxId());
                        results.add(tx);
                        if (depth + 1 >= maxDepth) continue;
                        childFutures.add(Peer.this.downloadDependenciesInternal(maxDepth, depth + 1, tx, marker, results));
                    }
                    if (childFutures.size() == 0) {
                        resultFuture.set(marker);
                    } else {
                        Futures.addCallback(Futures.successfulAsList(childFutures), new FutureCallback<List<Object>>(){

                            @Override
                            public void onSuccess(List<Object> objects) {
                                resultFuture.set(marker);
                            }

                            @Override
                            public void onFailure(Throwable throwable) {
                                resultFuture.setException(throwable);
                            }
                        }, MoreExecutors.directExecutor());
                    }
                }

                @Override
                public void onFailure(Throwable throwable) {
                    resultFuture.setException(throwable);
                }
            }, MoreExecutors.directExecutor());
            this.sendMessage(getdata);
        }
        catch (Exception e) {
            log.error("{}: Couldn't send getdata in downloadDependencies({})", this, tx.getTxId(), e);
            resultFuture.setException(e);
            SettableFuture<Object> settableFuture = resultFuture;
            return settableFuture;
        }
        finally {
            this.lock.unlock();
        }
        return resultFuture;
    }

    protected void processBlock(Block m4) {
        block15: {
            if (log.isDebugEnabled()) {
                log.debug("{}: Received broadcast block {}", (Object)this.getAddress(), (Object)m4.getHashAsString());
            }
            if (this.maybeHandleRequestedData(m4)) {
                return;
            }
            if (this.blockChain == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Received block but was not configured with an AbstractBlockChain");
                }
                return;
            }
            if (!this.vDownloadData) {
                if (log.isDebugEnabled()) {
                    log.debug("{}: Received block we did not ask for: {}", (Object)this.getAddress(), (Object)m4.getHashAsString());
                }
                return;
            }
            this.pendingBlockDownloads.remove(m4.getHash());
            try {
                if (this.blockChain.add(m4)) {
                    this.invokeOnBlocksDownloaded(m4, null);
                    break block15;
                }
                this.lock.lock();
                try {
                    if (this.downloadBlockBodies) {
                        Block orphanRoot = Preconditions.checkNotNull(this.blockChain.getOrphanRoot(m4.getHash()));
                        this.blockChainDownloadLocked(orphanRoot.getHash());
                    } else {
                        log.info("Did not start chain download on solved block due to in-flight header download.");
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (VerificationException e) {
                log.warn("{}: Block verification failed", (Object)this.getAddress(), (Object)e);
            }
            catch (PrunedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void endFilteredBlock(FilteredBlock m4) {
        block19: {
            if (log.isDebugEnabled()) {
                log.debug("{}: Received broadcast filtered block {}", (Object)this.getAddress(), (Object)m4.getHash().toString());
            }
            if (!this.vDownloadData) {
                if (log.isDebugEnabled()) {
                    log.debug("{}: Received block we did not ask for: {}", (Object)this.getAddress(), (Object)m4.getHash().toString());
                }
                return;
            }
            if (this.blockChain == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Received filtered block but was not configured with an AbstractBlockChain");
                }
                return;
            }
            this.pendingBlockDownloads.remove(m4.getBlockHeader().getHash());
            try {
                this.lock.lock();
                try {
                    if (this.awaitingFreshFilter != null) {
                        log.info("Discarding block {} because we're still waiting for a fresh filter", (Object)m4.getHash());
                        this.awaitingFreshFilter.add(m4.getHash());
                        return;
                    }
                    if (this.checkForFilterExhaustion(m4)) {
                        log.info("Bloom filter exhausted whilst processing block {}, discarding", (Object)m4.getHash());
                        this.awaitingFreshFilter = new LinkedList<Sha256Hash>();
                        this.awaitingFreshFilter.add(m4.getHash());
                        this.awaitingFreshFilter.addAll(this.blockChain.drainOrphanBlocks());
                        return;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                if (this.blockChain.add(m4)) {
                    this.invokeOnBlocksDownloaded(m4.getBlockHeader(), m4);
                    break block19;
                }
                this.lock.lock();
                try {
                    Block orphanRoot = Preconditions.checkNotNull(this.blockChain.getOrphanRoot(m4.getHash()));
                    this.blockChainDownloadLocked(orphanRoot.getHash());
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (VerificationException e) {
                log.warn("{}: FilteredBlock verification failed", (Object)this.getAddress(), (Object)e);
            }
            catch (PrunedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean checkForFilterExhaustion(FilteredBlock m4) {
        boolean exhausted = false;
        for (Wallet wallet : this.wallets) {
            exhausted |= wallet.checkForFilterExhaustion(m4);
        }
        return exhausted;
    }

    private boolean maybeHandleRequestedData(Message m4) {
        boolean found = false;
        Sha256Hash hash = m4.getHash();
        for (GetDataRequest req : this.getDataFutures) {
            if (!hash.equals(req.hash)) continue;
            req.future.set(m4);
            this.getDataFutures.remove(req);
            found = true;
        }
        return found;
    }

    private void invokeOnBlocksDownloaded(final Block block, final @Nullable FilteredBlock fb) {
        final int blocksLeft = Math.max(0, (int)this.vPeerVersionMessage.bestHeight - Preconditions.checkNotNull(this.blockChain).getBestChainHeight());
        for (final ListenerRegistration<BlocksDownloadedEventListener> registration : this.blocksDownloadedEventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((BlocksDownloadedEventListener)registration.listener).onBlocksDownloaded(Peer.this, block, fb, blocksLeft);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInv(InventoryMessage inv) {
        List<InventoryItem> items = inv.getItems();
        LinkedList<InventoryItem> transactions = new LinkedList<InventoryItem>();
        LinkedList<InventoryItem> blocks = new LinkedList<InventoryItem>();
        block7: for (InventoryItem item : items) {
            switch (item.type) {
                case TRANSACTION: {
                    transactions.add(item);
                    continue block7;
                }
                case BLOCK: {
                    blocks.add(item);
                    continue block7;
                }
            }
            throw new IllegalStateException("Not implemented: " + (Object)((Object)item.type));
        }
        boolean downloadData = this.vDownloadData;
        if (transactions.size() == 0 && blocks.size() == 1) {
            if (downloadData && this.blockChain != null) {
                if (!this.blockChain.isOrphan(((InventoryItem)blocks.get((int)0)).hash)) {
                    this.blocksAnnounced.incrementAndGet();
                }
            } else {
                this.blocksAnnounced.incrementAndGet();
            }
        }
        GetDataMessage getdata = new GetDataMessage(this.params);
        Iterator it = transactions.iterator();
        while (it.hasNext()) {
            InventoryItem item = (InventoryItem)it.next();
            TransactionConfidence conf = this.context.getConfidenceTable().seen(item.hash, this.getAddress());
            if (conf.numBroadcastPeers() > 1) {
                it.remove();
                continue;
            }
            if (conf.getSource().equals((Object)TransactionConfidence.Source.SELF)) {
                it.remove();
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("{}: getdata on tx {}", (Object)this.getAddress(), (Object)item.hash);
            }
            getdata.addTransaction(item.hash, this.vPeerVersionMessage.isWitnessSupported());
            if (this.pendingTxDownloads.size() > 100) {
                log.info("{}: Too many pending transactions, disconnecting", (Object)this);
                this.close();
                return;
            }
            this.pendingTxDownloads.add(conf);
        }
        boolean pingAfterGetData = false;
        this.lock.lock();
        try {
            if (blocks.size() > 0 && downloadData && this.blockChain != null) {
                for (InventoryItem item : blocks) {
                    if (this.blockChain.isOrphan(item.hash) && this.downloadBlockBodies) {
                        Block orphanRoot = Preconditions.checkNotNull(this.blockChain.getOrphanRoot(item.hash));
                        this.blockChainDownloadLocked(orphanRoot.getHash());
                        continue;
                    }
                    if (this.pendingBlockDownloads.contains(item.hash)) continue;
                    if (this.vPeerVersionMessage.isBloomFilteringSupported() && this.useFilteredBlocks) {
                        getdata.addFilteredBlock(item.hash);
                        pingAfterGetData = true;
                    } else {
                        getdata.addBlock(item.hash, this.vPeerVersionMessage.isWitnessSupported());
                    }
                    this.pendingBlockDownloads.add(item.hash);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!getdata.getItems().isEmpty()) {
            this.sendMessage(getdata);
        }
        if (pingAfterGetData) {
            this.sendMessage(new Ping((long)(Math.random() * 9.223372036854776E18)));
        }
    }

    public ListenableFuture<Block> getBlock(Sha256Hash blockHash) {
        log.info("Request to fetch block {}", (Object)blockHash);
        GetDataMessage getdata = new GetDataMessage(this.params);
        getdata.addBlock(blockHash, true);
        return this.sendSingleGetData(getdata);
    }

    public ListenableFuture<Transaction> getPeerMempoolTransaction(Sha256Hash hash) {
        log.info("Request to fetch peer mempool tx  {}", (Object)hash);
        GetDataMessage getdata = new GetDataMessage(this.params);
        getdata.addTransaction(hash, this.vPeerVersionMessage.isWitnessSupported());
        return this.sendSingleGetData(getdata);
    }

    private ListenableFuture sendSingleGetData(GetDataMessage getdata) {
        Preconditions.checkArgument(getdata.getItems().size() == 1);
        GetDataRequest req = new GetDataRequest(getdata.getItems().get((int)0).hash, SettableFuture.create());
        this.getDataFutures.add(req);
        this.sendMessage(getdata);
        return req.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<AddressMessage> getAddr() {
        SettableFuture<AddressMessage> future = SettableFuture.create();
        LinkedList<SettableFuture<AddressMessage>> linkedList = this.getAddrFutures;
        synchronized (linkedList) {
            this.getAddrFutures.add(future);
        }
        this.sendMessage(new GetAddrMessage(this.params));
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDownloadParameters(long secondsSinceEpoch, boolean useFilteredBlocks) {
        this.lock.lock();
        try {
            if (secondsSinceEpoch == 0L) {
                this.fastCatchupTimeSecs = this.params.getGenesisBlock().getTimeSeconds();
                this.downloadBlockBodies = true;
            } else {
                this.fastCatchupTimeSecs = secondsSinceEpoch;
                if (this.blockChain != null && this.fastCatchupTimeSecs > this.blockChain.getChainHead().getHeader().getTimeSeconds()) {
                    this.downloadBlockBodies = false;
                }
            }
            this.useFilteredBlocks = useFilteredBlocks;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addWallet(Wallet wallet) {
        this.wallets.add(wallet);
    }

    public void removeWallet(Wallet wallet) {
        this.wallets.remove(wallet);
    }

    @GuardedBy(value="lock")
    private void blockChainDownloadLocked(Sha256Hash toHash) {
        Preconditions.checkState(this.lock.isHeldByCurrentThread());
        BlockLocator blockLocator = new BlockLocator();
        BlockStore store = Preconditions.checkNotNull(this.blockChain).getBlockStore();
        StoredBlock chainHead = this.blockChain.getChainHead();
        Sha256Hash chainHeadHash = chainHead.getHeader().getHash();
        if (Objects.equal(this.lastGetBlocksBegin, chainHeadHash) && Objects.equal(this.lastGetBlocksEnd, toHash)) {
            log.info("blockChainDownloadLocked({}): ignoring duplicated request: {}", (Object)toHash, (Object)chainHeadHash);
            for (Sha256Hash hash : this.pendingBlockDownloads) {
                log.info("Pending block download: {}", (Object)hash);
            }
            log.info(Throwables.getStackTraceAsString(new Throwable()));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: blockChainDownloadLocked({}) current head = {}", this, toHash, chainHead.getHeader().getHashAsString());
        }
        StoredBlock cursor = chainHead;
        for (int i = 100; cursor != null && i > 0; cursor = cursor.getPrev(store), --i) {
            blockLocator = blockLocator.add(cursor.getHeader().getHash());
            try {
                continue;
            }
            catch (BlockStoreException e) {
                log.error("Failed to walk the block chain whilst constructing a locator");
                throw new RuntimeException(e);
            }
        }
        if (cursor != null) {
            blockLocator = blockLocator.add(this.params.getGenesisBlock().getHash());
        }
        this.lastGetBlocksBegin = chainHeadHash;
        this.lastGetBlocksEnd = toHash;
        if (this.downloadBlockBodies) {
            GetBlocksMessage message = new GetBlocksMessage(this.params, blockLocator, toHash);
            this.sendMessage(message);
        } else {
            GetHeadersMessage message = new GetHeadersMessage(this.params, blockLocator, toHash);
            this.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlockChainDownload() {
        this.setDownloadData(true);
        final int blocksLeft = this.getPeerBlockHeightDifference();
        if (blocksLeft >= 0) {
            for (final ListenerRegistration<ChainDownloadStartedEventListener> registration : this.chainDownloadStartedEventListeners) {
                registration.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ((ChainDownloadStartedEventListener)registration.listener).onChainDownloadStarted(Peer.this, blocksLeft);
                    }
                });
            }
            this.lock.lock();
            try {
                this.blockChainDownloadLocked(Sha256Hash.ZERO_HASH);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void addPingTimeData(long sample) {
        this.lastPingTimesLock.lock();
        try {
            if (this.lastPingTimes == null) {
                this.lastPingTimes = new long[20];
                Arrays.fill(this.lastPingTimes, sample);
            } else {
                System.arraycopy(this.lastPingTimes, 1, this.lastPingTimes, 0, this.lastPingTimes.length - 1);
                this.lastPingTimes[this.lastPingTimes.length - 1] = sample;
            }
        }
        finally {
            this.lastPingTimesLock.unlock();
        }
    }

    public ListenableFuture<Long> ping() throws ProtocolException {
        return this.ping((long)(Math.random() * 9.223372036854776E18));
    }

    protected ListenableFuture<Long> ping(long nonce) throws ProtocolException {
        VersionMessage ver = this.vPeerVersionMessage;
        if (!ver.isPingPongSupported()) {
            throw new ProtocolException("Peer version is too low for measurable pings: " + ver);
        }
        if (this.pendingPings.size() > 50) {
            log.info("{}: Too many pending pings, disconnecting", (Object)this);
            this.close();
        }
        PendingPing pendingPing = new PendingPing(nonce);
        this.pendingPings.add(pendingPing);
        this.sendMessage(new Ping(pendingPing.nonce));
        return pendingPing.future;
    }

    public long getLastPingTime() {
        this.lastPingTimesLock.lock();
        try {
            if (this.lastPingTimes == null) {
                long l = Long.MAX_VALUE;
                return l;
            }
            long l = this.lastPingTimes[this.lastPingTimes.length - 1];
            return l;
        }
        finally {
            this.lastPingTimesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPingTime() {
        this.lastPingTimesLock.lock();
        try {
            if (this.lastPingTimes == null) {
                long l = Long.MAX_VALUE;
                return l;
            }
            long sum = 0L;
            for (long i : this.lastPingTimes) {
                sum += i;
            }
            long l = (long)((double)sum / (double)this.lastPingTimes.length);
            return l;
        }
        finally {
            this.lastPingTimesLock.unlock();
        }
    }

    private void processPing(Ping m4) {
        if (m4.hasNonce()) {
            this.sendMessage(new Pong(m4.getNonce()));
        }
    }

    protected void processPong(Pong m4) {
        for (PendingPing ping : this.pendingPings) {
            if (m4.getNonce() != ping.nonce) continue;
            this.pendingPings.remove(ping);
            ping.complete();
            return;
        }
    }

    public int getPeerBlockHeightDifference() {
        Preconditions.checkNotNull(this.blockChain, "No block chain configured");
        int chainHeight = (int)this.getBestHeight();
        Preconditions.checkState(this.params.allowEmptyPeerChain() || chainHeight > 0, "Connected to peer with zero/negative chain height", chainHeight);
        return chainHeight - this.blockChain.getBestChainHeight();
    }

    private boolean isNotFoundMessageSupported() {
        return this.vPeerVersionMessage.clientVersion >= NotFoundMessage.MIN_PROTOCOL_VERSION;
    }

    public boolean isDownloadData() {
        return this.vDownloadData;
    }

    public void setDownloadData(boolean downloadData) {
        this.vDownloadData = downloadData;
    }

    public VersionMessage getPeerVersionMessage() {
        return this.vPeerVersionMessage;
    }

    public VersionMessage getVersionMessage() {
        return this.versionMessage;
    }

    public long getBestHeight() {
        return this.vPeerVersionMessage.bestHeight + (long)this.blocksAnnounced.get();
    }

    public boolean setMinProtocolVersion(int minProtocolVersion) {
        this.vMinProtocolVersion = minProtocolVersion;
        VersionMessage ver = this.getPeerVersionMessage();
        if (ver != null && ver.clientVersion < minProtocolVersion) {
            log.warn("{}: Disconnecting due to new min protocol version {}, got: {}", this, minProtocolVersion, ver.clientVersion);
            this.close();
            return true;
        }
        return false;
    }

    public void setBloomFilter(BloomFilter filter) {
        this.setBloomFilter(filter, true);
    }

    public void setBloomFilter(BloomFilter filter, boolean andQueryMemPool) {
        Preconditions.checkNotNull(filter, "Clearing filters is not currently supported");
        VersionMessage version = this.vPeerVersionMessage;
        Preconditions.checkNotNull(version, "Cannot set filter before version handshake is complete");
        if (version.isBloomFilteringSupported()) {
            this.vBloomFilter = filter;
            log.info("{}: Sending Bloom filter{}", (Object)this, (Object)(andQueryMemPool ? " and querying mempool" : ""));
            this.sendMessage(filter);
            if (andQueryMemPool) {
                this.sendMessage(new MemoryPoolMessage());
            }
            this.maybeRestartChainDownload();
        } else {
            log.info("{}: Peer does not support bloom filtering.", (Object)this);
            this.close();
        }
    }

    private void maybeRestartChainDownload() {
        this.lock.lock();
        try {
            if (this.awaitingFreshFilter == null) {
                return;
            }
            if (!this.vDownloadData) {
                log.warn("Lost download peer status whilst awaiting fresh filter.");
                return;
            }
            this.ping().addListener(new Runnable(){

                @Override
                public void run() {
                    Peer.this.lock.lock();
                    Preconditions.checkNotNull(Peer.this.awaitingFreshFilter);
                    GetDataMessage getdata = new GetDataMessage(Peer.this.params);
                    for (Sha256Hash hash : Peer.this.awaitingFreshFilter) {
                        getdata.addFilteredBlock(hash);
                    }
                    Peer.this.awaitingFreshFilter = null;
                    Peer.this.lock.unlock();
                    log.info("Restarting chain download");
                    Peer.this.sendMessage(getdata);
                    Peer.this.sendMessage(new Ping((long)(Math.random() * 9.223372036854776E18)));
                }
            }, Threading.SAME_THREAD);
        }
        finally {
            this.lock.unlock();
        }
    }

    public BloomFilter getBloomFilter() {
        return this.vBloomFilter;
    }

    public ListenableFuture<UTXOsMessage> getUTXOs(List<TransactionOutPoint> outPoints) {
        return this.getUTXOs(outPoints, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<UTXOsMessage> getUTXOs(List<TransactionOutPoint> outPoints, boolean includeMempool) {
        this.lock.lock();
        try {
            VersionMessage peerVer = this.getPeerVersionMessage();
            if (peerVer.clientVersion < 70002) {
                throw new ProtocolException("Peer does not support getutxos protocol version");
            }
            if ((peerVer.localServices & 3L) != 3L) {
                throw new ProtocolException("Peer does not support getutxos protocol flag: find Bitcoin XT nodes.");
            }
            SettableFuture<UTXOsMessage> future = SettableFuture.create();
            if (this.getutxoFutures == null) {
                this.getutxoFutures = new LinkedList();
            }
            this.getutxoFutures.add(future);
            this.sendMessage(new GetUTXOsMessage(this.params, outPoints, includeMempool));
            SettableFuture<UTXOsMessage> settableFuture = future;
            return settableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDownloadTxDependencies() {
        return this.vDownloadTxDependencyDepth > 0;
    }

    public void setDownloadTxDependencies(boolean enable) {
        this.vDownloadTxDependencyDepth = enable ? Integer.MAX_VALUE : 0;
    }

    public void setDownloadTxDependencies(int depth) {
        this.vDownloadTxDependencyDepth = depth;
    }

    private class PendingPing {
        public final SettableFuture<Long> future = SettableFuture.create();
        public final long nonce;
        public final long startTimeMsec;

        public PendingPing(long nonce) {
            this.nonce = nonce;
            this.startTimeMsec = Utils.currentTimeMillis();
        }

        public void complete() {
            if (!this.future.isDone()) {
                long elapsed = Utils.currentTimeMillis() - this.startTimeMsec;
                Peer.this.addPingTimeData(elapsed);
                if (log.isDebugEnabled()) {
                    log.debug("{}: ping time is {} ms", (Object)Peer.this.toString(), (Object)elapsed);
                }
                this.future.set(elapsed);
            }
        }
    }

    private static class GetDataRequest {
        final Sha256Hash hash;
        final SettableFuture future;

        public GetDataRequest(Sha256Hash hash, SettableFuture future) {
            this.hash = hash;
            this.future = future;
        }
    }
}

