/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.bitcoinj.core.ChildMessage;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VersionMessage;
import org.bitcoinj.net.OnionCatAddressChecker;
import org.bitcoinj.net.OnionCatConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerAddress
extends ChildMessage {
    private static final Logger log = LoggerFactory.getLogger(PeerAddress.class);
    static final int MESSAGE_SIZE = 30;
    private InetAddress addr;
    private String hostname;
    private int port;
    private BigInteger services;
    private long time;

    public PeerAddress(NetworkParameters params, byte[] payload, int offset, int protocolVersion) throws ProtocolException {
        super(params, payload, offset, protocolVersion);
    }

    public PeerAddress(NetworkParameters params, byte[] payload, int offset, int protocolVersion, Message parent, MessageSerializer serializer) throws ProtocolException {
        super(params, payload, offset, protocolVersion, parent, serializer, Integer.MIN_VALUE);
    }

    public PeerAddress(NetworkParameters params, InetAddress addr, int port, int protocolVersion, BigInteger services) {
        super(params);
        this.addr = Preconditions.checkNotNull(addr);
        this.port = port;
        this.protocolVersion = protocolVersion;
        this.services = services;
        this.length = this.isSerializeTime() ? 30 : 26;
    }

    public PeerAddress(NetworkParameters params, InetAddress addr, int port) {
        this(params, addr, port, params.getProtocolVersionNum(NetworkParameters.ProtocolVersion.CURRENT), BigInteger.ZERO);
    }

    public PeerAddress(NetworkParameters params, InetAddress addr) {
        this(params, addr, params.getPort());
    }

    public PeerAddress(InetSocketAddress addr) {
        InetAddress inetAddress = addr.getAddress();
        if (inetAddress != null) {
            this.addr = inetAddress;
        } else {
            this.hostname = Preconditions.checkNotNull(addr.getHostString());
        }
        this.port = addr.getPort();
        this.protocolVersion = NetworkParameters.ProtocolVersion.CURRENT.getBitcoinProtocolVersion();
        this.services = BigInteger.ZERO;
        this.length = this.protocolVersion > 31402 ? 30 : 26;
    }

    public PeerAddress(NetworkParameters params, InetSocketAddress addr) {
        super(params);
        InetAddress inetAddress = addr.getAddress();
        if (inetAddress != null) {
            this.addr = inetAddress;
        } else {
            this.hostname = Preconditions.checkNotNull(addr.getHostString());
        }
        this.port = addr.getPort();
        this.protocolVersion = params.getProtocolVersionNum(NetworkParameters.ProtocolVersion.CURRENT);
        this.services = BigInteger.ZERO;
        this.length = this.protocolVersion > 31402 ? 30 : 26;
    }

    public PeerAddress(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.protocolVersion = NetworkParameters.ProtocolVersion.CURRENT.getBitcoinProtocolVersion();
        this.services = BigInteger.ZERO;
    }

    public PeerAddress(NetworkParameters params, String hostname, int port) {
        super(params);
        this.hostname = hostname;
        this.port = port;
        this.protocolVersion = params.getProtocolVersionNum(NetworkParameters.ProtocolVersion.CURRENT);
        this.services = BigInteger.ZERO;
    }

    public PeerAddress(NetworkParameters params, String hostname, int port, int protocolVersion, BigInteger services) {
        super(params);
        this.hostname = hostname;
        this.port = port;
        this.protocolVersion = protocolVersion;
        this.services = services;
        this.length = this.isSerializeTime() ? 30 : 26;
    }

    public static PeerAddress localhost(NetworkParameters params) {
        return new PeerAddress(params, InetAddress.getLoopbackAddress(), params.getPort());
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        byte[] ipBytes;
        if (this.isSerializeTime()) {
            int secs = (int)Utils.currentTimeSeconds();
            Utils.uint32ToByteStreamLE(secs, stream);
        }
        Utils.uint64ToByteStreamLE(this.services, stream);
        if (this.hostname != null) {
            ipBytes = this.hostname.endsWith(".onion") ? OnionCatConverter.onionHostToIPV6Bytes(this.hostname) : new byte[16];
        } else if (this.addr != null) {
            ipBytes = this.addr.getAddress();
            if (ipBytes.length == 4) {
                byte[] v6addr = new byte[16];
                System.arraycopy(ipBytes, 0, v6addr, 12, 4);
                v6addr[10] = -1;
                v6addr[11] = -1;
                ipBytes = v6addr;
            }
        } else {
            throw new IllegalStateException("Either hostname or addr should be not null");
        }
        stream.write(ipBytes);
        Utils.uint16ToByteStreamBE(this.port, stream);
    }

    private boolean isSerializeTime() {
        return this.protocolVersion >= 31402 && !(this.parent instanceof VersionMessage);
    }

    @Override
    protected void parse() throws ProtocolException {
        InetAddress inetAddress;
        this.time = this.isSerializeTime() ? this.readUint32() : -1L;
        this.services = this.readUint64();
        byte[] addrBytes = this.readBytes(16);
        try {
            inetAddress = InetAddress.getByAddress(addrBytes);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        if (OnionCatAddressChecker.isOnionCatTor(inetAddress)) {
            this.hostname = OnionCatConverter.IPV6BytesToOnionHost(inetAddress.getAddress());
        } else {
            this.addr = inetAddress;
        }
        this.port = Utils.readUint16BE(this.payload, this.cursor);
        this.cursor += 2;
        this.length = this.isSerializeTime() ? 30 : 26;
    }

    public String getHostname() {
        return this.hostname;
    }

    public InetAddress getAddr() {
        return this.addr;
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.getAddr(), this.getPort());
    }

    public int getPort() {
        return this.port;
    }

    public BigInteger getServices() {
        return this.services;
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        if (this.hostname != null) {
            return "[" + this.hostname + "]:" + this.port;
        }
        if (this.addr != null) {
            return "[" + this.addr.getHostAddress() + "]:" + this.port;
        }
        return "[]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeerAddress that = (PeerAddress)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.time != that.time) {
            return false;
        }
        if (this.addr != null ? !this.addr.equals(that.addr) : that.addr != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        return !(this.services == null ? that.services != null : !this.services.equals(that.services));
    }

    public boolean equalsIgnoringMetadata(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeerAddress that = (PeerAddress)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.addr != null ? !this.addr.equals(that.addr) : that.addr != null) {
            return false;
        }
        return !(this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null);
    }

    public int hashCode() {
        int result = this.addr != null ? this.addr.hashCode() : 0;
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + (this.services != null ? this.services.hashCode() : 0);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }

    public InetSocketAddress toSocketAddress() {
        if (this.hostname != null) {
            return InetSocketAddress.createUnresolved(this.hostname, this.port);
        }
        return new InetSocketAddress(this.addr, this.port);
    }
}

