/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.ChildMessage;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.MessageSerializer;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.TransactionBag;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.TransactionWitness;
import org.bitcoinj.core.TxConfidenceTable;
import org.bitcoinj.core.UnsafeByteArrayOutputStream;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VarInt;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.script.ScriptError;
import org.bitcoinj.script.ScriptException;
import org.bitcoinj.script.ScriptPattern;
import org.bitcoinj.utils.ExchangeRate;
import org.bitcoinj.wallet.WalletTransaction;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction
extends ChildMessage {
    public static final Comparator<Transaction> SORT_TX_BY_UPDATE_TIME = new Comparator<Transaction>(){

        @Override
        public int compare(Transaction tx1, Transaction tx2) {
            long time2;
            long time1 = tx1.getUpdateTime().getTime();
            int updateTimeComparison = -Longs.compare(time1, time2 = tx2.getUpdateTime().getTime());
            return updateTimeComparison != 0 ? updateTimeComparison : tx1.getTxId().compareTo(tx2.getTxId());
        }
    };
    public static final Comparator<Transaction> SORT_TX_BY_HEIGHT = new Comparator<Transaction>(){

        @Override
        public int compare(Transaction tx1, Transaction tx2) {
            TransactionConfidence confidence1 = tx1.getConfidence();
            int height1 = confidence1.getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING ? confidence1.getAppearedAtChainHeight() : -1;
            TransactionConfidence confidence2 = tx2.getConfidence();
            int height2 = confidence2.getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING ? confidence2.getAppearedAtChainHeight() : -1;
            int heightComparison = -Ints.compare(height1, height2);
            return heightComparison != 0 ? heightComparison : tx1.getTxId().compareTo(tx2.getTxId());
        }
    };
    private static final Logger log = LoggerFactory.getLogger(Transaction.class);
    public static final int LOCKTIME_THRESHOLD = 500000000;
    public static final BigInteger LOCKTIME_THRESHOLD_BIG = BigInteger.valueOf(500000000L);
    public static final int MAX_STANDARD_TX_SIZE = 100000;
    public static final Coin REFERENCE_DEFAULT_MIN_TX_FEE = Coin.valueOf(1000L);
    public static final Coin DEFAULT_TX_FEE = Coin.valueOf(100000L);
    public static final Coin MIN_NONDUST_OUTPUT = Coin.valueOf(546L);
    private long version;
    private ArrayList<TransactionInput> inputs;
    private ArrayList<TransactionOutput> outputs;
    private long lockTime;
    private Date updatedAt;
    @Nullable
    private Date includedInBestChainAt;
    private Sha256Hash cachedTxId;
    private Sha256Hash cachedWTxId;
    @Nullable
    private TransactionConfidence confidence;
    private Map<Sha256Hash, Integer> appearsInHashes;
    private int optimalEncodingMessageSize;
    private Purpose purpose = Purpose.UNKNOWN;
    @Nullable
    private ExchangeRate exchangeRate;
    @Nullable
    private String memo;
    @Nullable
    private Coin cachedValue;
    @Nullable
    private TransactionBag cachedForBag;
    public static final byte SIGHASH_ANYONECANPAY_VALUE = -128;

    public Transaction(NetworkParameters params) {
        super(params);
        this.version = 1L;
        this.inputs = new ArrayList();
        this.outputs = new ArrayList();
        this.length = 8;
    }

    public Transaction(NetworkParameters params, byte[] payloadBytes) throws ProtocolException {
        super(params, payloadBytes, 0);
    }

    public Transaction(NetworkParameters params, byte[] payload, int offset) throws ProtocolException {
        super(params, payload, offset);
    }

    public Transaction(NetworkParameters params, byte[] payload, int offset, @Nullable Message parent, MessageSerializer setSerializer, int length, @Nullable byte[] hashFromHeader) throws ProtocolException {
        super(params, payload, offset, parent, setSerializer, length);
        if (hashFromHeader != null) {
            this.cachedWTxId = Sha256Hash.wrapReversed(hashFromHeader);
            if (!this.hasWitnesses()) {
                this.cachedTxId = this.cachedWTxId;
            }
        }
    }

    public Transaction(NetworkParameters params, byte[] payload, @Nullable Message parent, MessageSerializer setSerializer, int length) throws ProtocolException {
        super(params, payload, 0, parent, setSerializer, length);
    }

    @Override
    @Deprecated
    public Sha256Hash getHash() {
        return this.getTxId();
    }

    @Deprecated
    public String getHashAsString() {
        return this.getTxId().toString();
    }

    public Sha256Hash getTxId() {
        if (this.cachedTxId == null) {
            if (!this.hasWitnesses() && this.cachedWTxId != null) {
                this.cachedTxId = this.cachedWTxId;
            } else {
                UnsafeByteArrayOutputStream stream = new UnsafeByteArrayOutputStream(this.length < 32 ? 32 : this.length + 32);
                try {
                    this.bitcoinSerializeToStream(stream, false);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.cachedTxId = Sha256Hash.wrapReversed(Sha256Hash.hashTwice(((ByteArrayOutputStream)stream).toByteArray()));
            }
        }
        return this.cachedTxId;
    }

    public Sha256Hash getWTxId() {
        if (this.cachedWTxId == null) {
            if (!this.hasWitnesses() && this.cachedTxId != null) {
                this.cachedWTxId = this.cachedTxId;
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    this.bitcoinSerializeToStream(baos, this.hasWitnesses());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.cachedWTxId = Sha256Hash.wrapReversed(Sha256Hash.hashTwice(baos.toByteArray()));
            }
        }
        return this.cachedWTxId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getWeight() {
        if (!this.hasWitnesses()) {
            return this.getMessageSize() * 4;
        }
        try (UnsafeByteArrayOutputStream stream = new UnsafeByteArrayOutputStream(this.length);){
            this.bitcoinSerializeToStream(stream, false);
            int baseSize = ((ByteArrayOutputStream)stream).size();
            ((ByteArrayOutputStream)stream).reset();
            this.bitcoinSerializeToStream(stream, true);
            int totalSize = ((ByteArrayOutputStream)stream).size();
            int n = baseSize * 3 + totalSize;
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getVsize() {
        if (!this.hasWitnesses()) {
            return this.getMessageSize();
        }
        return (this.getWeight() + 3) / 4;
    }

    public Coin getInputSum() {
        Coin inputTotal = Coin.ZERO;
        for (TransactionInput input : this.inputs) {
            Coin inputValue = input.getValue();
            if (inputValue == null) continue;
            inputTotal = inputTotal.add(inputValue);
        }
        return inputTotal;
    }

    public Coin getValueSentToMe(TransactionBag transactionBag) {
        Coin v = Coin.ZERO;
        for (TransactionOutput o : this.outputs) {
            if (!o.isMineOrWatched(transactionBag)) continue;
            v = v.add(o.getValue());
        }
        return v;
    }

    @Nullable
    public Map<Sha256Hash, Integer> getAppearsInHashes() {
        return this.appearsInHashes != null ? ImmutableMap.copyOf(this.appearsInHashes) : null;
    }

    public boolean isPending() {
        return this.getConfidence().getConfidenceType() == TransactionConfidence.ConfidenceType.PENDING;
    }

    public void setBlockAppearance(StoredBlock block, boolean bestChain, int relativityOffset) {
        long blockTime = block.getHeader().getTimeSeconds() * 1000L;
        if (bestChain && (this.updatedAt == null || this.updatedAt.getTime() == 0L || this.updatedAt.getTime() > blockTime)) {
            this.updatedAt = new Date(blockTime);
        }
        if (bestChain) {
            this.includedInBestChainAt = new Date(blockTime);
        }
        this.addBlockAppearance(block.getHeader().getHash(), relativityOffset);
        if (bestChain) {
            TransactionConfidence transactionConfidence = this.getConfidence();
            transactionConfidence.setAppearedAtChainHeight(block.getHeight());
        }
    }

    public void addBlockAppearance(Sha256Hash blockHash, int relativityOffset) {
        if (this.appearsInHashes == null) {
            this.appearsInHashes = new TreeMap<Sha256Hash, Integer>();
        }
        this.appearsInHashes.put(blockHash, relativityOffset);
    }

    public Coin getValueSentFromMe(TransactionBag wallet) throws ScriptException {
        Coin v = Coin.ZERO;
        for (TransactionInput input : this.inputs) {
            TransactionOutput connected = input.getConnectedOutput(wallet.getTransactionPool(WalletTransaction.Pool.UNSPENT));
            if (connected == null) {
                connected = input.getConnectedOutput(wallet.getTransactionPool(WalletTransaction.Pool.SPENT));
            }
            if (connected == null) {
                connected = input.getConnectedOutput(wallet.getTransactionPool(WalletTransaction.Pool.PENDING));
            }
            if (connected == null || !connected.isMineOrWatched(wallet)) continue;
            v = v.add(connected.getValue());
        }
        return v;
    }

    public Coin getOutputSum() {
        Coin totalOut = Coin.ZERO;
        for (TransactionOutput output : this.outputs) {
            totalOut = totalOut.add(output.getValue());
        }
        return totalOut;
    }

    public Coin getValue(TransactionBag wallet) throws ScriptException {
        boolean isAndroid = Utils.isAndroidRuntime();
        if (isAndroid && this.cachedValue != null && this.cachedForBag == wallet) {
            return this.cachedValue;
        }
        Coin result = this.getValueSentToMe(wallet).subtract(this.getValueSentFromMe(wallet));
        if (isAndroid) {
            this.cachedValue = result;
            this.cachedForBag = wallet;
        }
        return result;
    }

    public Coin getFee() {
        Coin fee = Coin.ZERO;
        if (this.inputs.isEmpty() || this.outputs.isEmpty()) {
            return null;
        }
        for (TransactionInput input : this.inputs) {
            if (input.getValue() == null) {
                return null;
            }
            fee = fee.add(input.getValue());
        }
        for (TransactionOutput output : this.outputs) {
            fee = fee.subtract(output.getValue());
        }
        return fee;
    }

    public boolean isAnyOutputSpent() {
        for (TransactionOutput output : this.outputs) {
            if (output.isAvailableForSpending()) continue;
            return true;
        }
        return false;
    }

    public boolean isEveryOwnedOutputSpent(TransactionBag transactionBag) {
        for (TransactionOutput output : this.outputs) {
            if (!output.isAvailableForSpending() || !output.isMineOrWatched(transactionBag)) continue;
            return false;
        }
        return true;
    }

    public Date getUpdateTime() {
        if (this.updatedAt == null) {
            this.updatedAt = new Date(0L);
        }
        return this.updatedAt;
    }

    public void setUpdateTime(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Nullable
    public Date getIncludedInBestChainAt() {
        return this.includedInBestChainAt;
    }

    public void setIncludedInBestChainAt(Date includedInBestChainAt) {
        this.includedInBestChainAt = includedInBestChainAt;
    }

    @Override
    protected void unCache() {
        super.unCache();
        this.cachedTxId = null;
        this.cachedWTxId = null;
        this.confidence = null;
    }

    protected static int calcLength(byte[] buf, int offset) {
        long scriptLen;
        int cursor = offset + 4;
        VarInt varint = new VarInt(buf, cursor);
        long txInCount = varint.value;
        cursor += varint.getOriginalSizeInBytes();
        int i = 0;
        while ((long)i < txInCount) {
            varint = new VarInt(buf, cursor += 36);
            scriptLen = varint.value;
            cursor = (int)((long)cursor + (scriptLen + 4L + (long)varint.getOriginalSizeInBytes()));
            ++i;
        }
        varint = new VarInt(buf, cursor);
        long txOutCount = varint.value;
        cursor += varint.getOriginalSizeInBytes();
        i = 0;
        while ((long)i < txOutCount) {
            varint = new VarInt(buf, cursor += 8);
            scriptLen = varint.value;
            cursor = (int)((long)cursor + (scriptLen + (long)varint.getOriginalSizeInBytes()));
            ++i;
        }
        return cursor - offset + 4;
    }

    @Override
    protected void parse() throws ProtocolException {
        boolean useSegwit;
        this.cursor = this.offset;
        this.optimalEncodingMessageSize = 4;
        this.version = this.readUint32();
        byte marker = this.payload[this.cursor];
        boolean bl = useSegwit = marker == 0;
        if (useSegwit) {
            this.readBytes(2);
            this.optimalEncodingMessageSize += 2;
        }
        this.parseInputs();
        this.parseOutputs();
        if (useSegwit) {
            this.parseWitnesses();
        }
        this.lockTime = this.readUint32();
        this.optimalEncodingMessageSize += 4;
        this.length = this.cursor - this.offset;
    }

    private void parseInputs() {
        long numInputs = this.readVarInt();
        this.optimalEncodingMessageSize += VarInt.sizeOf(numInputs);
        this.inputs = new ArrayList(Math.min((int)numInputs, 20));
        for (long i = 0L; i < numInputs; ++i) {
            TransactionInput input = new TransactionInput(this.params, this, this.payload, this.cursor, this.serializer);
            this.inputs.add(input);
            long scriptLen = this.readVarInt(36);
            this.optimalEncodingMessageSize = (int)((long)this.optimalEncodingMessageSize + ((long)(36 + VarInt.sizeOf(scriptLen)) + scriptLen + 4L));
            this.cursor = (int)((long)this.cursor + (scriptLen + 4L));
        }
    }

    private void parseOutputs() {
        long numOutputs = this.readVarInt();
        this.optimalEncodingMessageSize += VarInt.sizeOf(numOutputs);
        this.outputs = new ArrayList(Math.min((int)numOutputs, 20));
        for (long i = 0L; i < numOutputs; ++i) {
            TransactionOutput output = new TransactionOutput(this.params, this, this.payload, this.cursor, this.serializer);
            this.outputs.add(output);
            long scriptLen = this.readVarInt(8);
            this.optimalEncodingMessageSize = (int)((long)this.optimalEncodingMessageSize + ((long)(8 + VarInt.sizeOf(scriptLen)) + scriptLen));
            this.cursor = (int)((long)this.cursor + scriptLen);
        }
    }

    private void parseWitnesses() {
        int numWitnesses = this.inputs.size();
        for (int i = 0; i < numWitnesses; ++i) {
            long pushCount = this.readVarInt();
            TransactionWitness witness = new TransactionWitness((int)pushCount);
            this.getInput(i).setWitness(witness);
            this.optimalEncodingMessageSize += VarInt.sizeOf(pushCount);
            int y = 0;
            while ((long)y < pushCount) {
                long pushSize = this.readVarInt();
                this.optimalEncodingMessageSize = (int)((long)this.optimalEncodingMessageSize + ((long)VarInt.sizeOf(pushSize) + pushSize));
                byte[] push = this.readBytes((int)pushSize);
                witness.setPush(y, push);
                ++y;
            }
        }
    }

    public boolean hasWitnesses() {
        for (TransactionInput in : this.inputs) {
            if (!in.hasWitness()) continue;
            return true;
        }
        return false;
    }

    public int getOptimalEncodingMessageSize() {
        if (this.optimalEncodingMessageSize != 0) {
            return this.optimalEncodingMessageSize;
        }
        this.optimalEncodingMessageSize = this.getMessageSize();
        return this.optimalEncodingMessageSize;
    }

    public int getMessageSizeForPriorityCalc() {
        int size = this.getMessageSize();
        for (TransactionInput input : this.inputs) {
            int benefit = 41 + Math.min(110, input.getScriptSig().getProgram().length);
            if (size <= benefit) continue;
            size -= benefit;
        }
        return size;
    }

    public boolean isCoinBase() {
        return this.inputs.size() == 1 && this.inputs.get(0).isCoinBase();
    }

    public boolean isMature() {
        if (!this.isCoinBase()) {
            return true;
        }
        if (this.getConfidence().getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) {
            return false;
        }
        return this.getConfidence().getDepthInBlocks() >= this.params.getSpendableCoinbaseDepth();
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this);
        helper.addValue(this.toString(null, null));
        return helper.toString();
    }

    public String toString(@Nullable AbstractBlockChain chain, @Nullable CharSequence indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder s2 = new StringBuilder();
        Sha256Hash txId = this.getTxId();
        Sha256Hash wTxId = this.getWTxId();
        s2.append(indent).append(txId);
        if (!wTxId.equals(txId)) {
            s2.append(", wtxid ").append(wTxId);
        }
        s2.append('\n');
        int weight = this.getWeight();
        int size = this.unsafeBitcoinSerialize().length;
        int vsize = this.getVsize();
        s2.append(indent).append("weight: ").append(weight).append(" wu, ");
        if (size != vsize) {
            s2.append(vsize).append(" virtual bytes, ");
        }
        s2.append(size).append(" bytes\n");
        if (this.updatedAt != null) {
            s2.append(indent).append("updated: ").append(Utils.dateTimeFormat(this.updatedAt)).append('\n');
        }
        if (this.includedInBestChainAt != null) {
            s2.append(indent).append("included in best chain at: ").append(Utils.dateTimeFormat(this.includedInBestChainAt)).append('\n');
        }
        if (this.version != 1L) {
            s2.append(indent).append("version ").append(this.version).append('\n');
        }
        if (this.isTimeLocked()) {
            s2.append(indent).append("time locked until ");
            if (this.lockTime < 500000000L) {
                s2.append("block ").append(this.lockTime);
                if (chain != null) {
                    s2.append(" (estimated to be reached at ").append(Utils.dateTimeFormat(chain.estimateBlockTime((int)this.lockTime))).append(')');
                }
            } else {
                s2.append(Utils.dateTimeFormat(this.lockTime * 1000L));
            }
            s2.append('\n');
        }
        if (this.hasRelativeLockTime()) {
            s2.append(indent).append("has relative lock time\n");
        }
        if (this.isOptInFullRBF()) {
            s2.append(indent).append("opts into full replace-by-fee\n");
        }
        if (this.purpose != null) {
            s2.append(indent).append("purpose: ").append((Object)this.purpose).append('\n');
        }
        if (this.isCoinBase()) {
            String script2;
            String script;
            try {
                script = this.inputs.get(0).getScriptSig().toString();
                script2 = this.outputs.get(0).getScriptPubKey().toString();
            }
            catch (ScriptException e) {
                script = "???";
                script2 = "???";
            }
            s2.append(indent).append("   == COINBASE TXN (scriptSig ").append(script).append(")  (scriptPubKey ").append(script2).append(")\n");
            return s2.toString();
        }
        if (!this.inputs.isEmpty()) {
            int i = 0;
            for (TransactionInput in : this.inputs) {
                s2.append(indent).append("   ");
                s2.append("in   ");
                try {
                    s2.append(in.getScriptSig());
                    Coin value = in.getValue();
                    if (value != null) {
                        s2.append("  ").append(value.toFriendlyString()).append(" (").append(value).append(")");
                    }
                    s2.append('\n');
                    if (in.hasWitness()) {
                        s2.append(indent).append("        witness:");
                        s2.append(in.getWitness());
                        s2.append('\n');
                    }
                    TransactionOutPoint outpoint = in.getOutpoint();
                    TransactionOutput connectedOutput = outpoint.getConnectedOutput();
                    s2.append(indent).append("        ");
                    if (connectedOutput != null) {
                        Script scriptPubKey = connectedOutput.getScriptPubKey();
                        Script.ScriptType scriptType = scriptPubKey.getScriptType();
                        if (scriptType != null) {
                            s2.append((Object)scriptType).append(" addr:").append(scriptPubKey.getToAddress(this.params));
                        } else {
                            s2.append("unknown script type");
                        }
                    } else {
                        s2.append("unconnected");
                    }
                    s2.append("  outpoint:").append(outpoint).append('\n');
                    if (in.hasSequence()) {
                        s2.append(indent).append("        sequence:").append(Long.toHexString(in.getSequenceNumber()));
                        if (in.isOptInFullRBF()) {
                            s2.append(", opts into full RBF");
                        }
                        if (this.version >= 2L && in.hasRelativeLockTime()) {
                            s2.append(", has RLT");
                        }
                        s2.append('\n');
                    }
                }
                catch (Exception e) {
                    s2.append("[exception: ").append(e.getMessage()).append("]\n");
                }
                ++i;
            }
        } else {
            s2.append(indent).append("   ");
            s2.append("INCOMPLETE: No inputs!\n");
        }
        for (TransactionOutput out : this.outputs) {
            s2.append(indent).append("   ");
            s2.append("out  ");
            try {
                Script scriptPubKey = out.getScriptPubKey();
                s2.append(scriptPubKey.getChunks().size() > 0 ? scriptPubKey.toString() : "<no scriptPubKey>");
                s2.append(" (").append(Utils.HEX.encode(scriptPubKey.getProgram())).append(")");
                s2.append("  ");
                s2.append(out.getValue().toFriendlyString()).append(" (").append(out.getValue()).append(")");
                s2.append('\n');
                s2.append(indent).append("        ");
                Script.ScriptType scriptType = scriptPubKey.getScriptType();
                if (scriptType != null) {
                    s2.append((Object)scriptType).append(" addr:").append(scriptPubKey.getToAddress(this.params));
                } else {
                    s2.append("unknown script type");
                }
                if (!out.isAvailableForSpending()) {
                    s2.append("  spent");
                    TransactionInput spentBy = out.getSpentBy();
                    if (spentBy != null) {
                        s2.append(" by:");
                        s2.append(spentBy.getParentTransaction().getTxId()).append(':').append(spentBy.getIndex());
                    }
                }
                s2.append('\n');
            }
            catch (Exception e) {
                s2.append("[exception: ").append(e.getMessage()).append("]\n");
            }
        }
        Coin fee = this.getFee();
        if (fee != null) {
            s2.append(indent).append("   fee  ");
            s2.append(fee.multiply(1000L).divide(weight).toFriendlyString()).append("/wu, ");
            if (size != vsize) {
                s2.append(fee.multiply(1000L).divide(vsize).toFriendlyString()).append("/vkB, ");
            }
            s2.append(fee.multiply(1000L).divide(size).toFriendlyString()).append("/kB  ");
            s2.append(fee.toFriendlyString()).append('\n');
        }
        return s2.toString();
    }

    public void clearInputs() {
        this.unCache();
        for (TransactionInput input : this.inputs) {
            input.setParent(null);
        }
        this.inputs.clear();
        this.length = this.unsafeBitcoinSerialize().length;
    }

    public TransactionInput addInput(TransactionOutput from) {
        return this.addInput(new TransactionInput(this.params, this, from));
    }

    public TransactionInput addInput(TransactionInput input) {
        this.unCache();
        input.setParent(this);
        this.inputs.add(input);
        this.adjustLength(this.inputs.size(), input.length);
        return input;
    }

    public TransactionInput addInput(Sha256Hash spendTxHash, long outputIndex, Script script) {
        return this.addInput(new TransactionInput(this.params, this, script.getProgram(), new TransactionOutPoint(this.params, outputIndex, spendTxHash)));
    }

    public TransactionInput addSignedInput(TransactionOutPoint prevOut, Script scriptPubKey, ECKey sigKey, SigHash sigHash, boolean anyoneCanPay) throws ScriptException {
        Preconditions.checkState(!this.outputs.isEmpty(), "Attempting to sign tx without outputs.");
        TransactionInput input = new TransactionInput(this.params, this, new byte[0], prevOut);
        this.addInput(input);
        int inputIndex = this.inputs.size() - 1;
        if (ScriptPattern.isP2PK(scriptPubKey)) {
            TransactionSignature signature = this.calculateSignature(inputIndex, sigKey, scriptPubKey, sigHash, anyoneCanPay);
            input.setScriptSig(ScriptBuilder.createInputScript(signature));
            input.setWitness(null);
        } else if (ScriptPattern.isP2PKH(scriptPubKey)) {
            TransactionSignature signature = this.calculateSignature(inputIndex, sigKey, scriptPubKey, sigHash, anyoneCanPay);
            input.setScriptSig(ScriptBuilder.createInputScript(signature, sigKey));
            input.setWitness(null);
        } else if (ScriptPattern.isP2WPKH(scriptPubKey)) {
            Script scriptCode = ScriptBuilder.createP2PKHOutputScript(sigKey);
            TransactionSignature signature = this.calculateWitnessSignature(inputIndex, sigKey, scriptCode, input.getValue(), sigHash, anyoneCanPay);
            input.setScriptSig(ScriptBuilder.createEmpty());
            input.setWitness(TransactionWitness.redeemP2WPKH(signature, sigKey));
        } else {
            throw new ScriptException(ScriptError.SCRIPT_ERR_UNKNOWN_ERROR, "Don't know how to sign for this kind of scriptPubKey: " + scriptPubKey);
        }
        return input;
    }

    public TransactionInput addSignedInput(TransactionOutPoint prevOut, Script scriptPubKey, ECKey sigKey) throws ScriptException {
        return this.addSignedInput(prevOut, scriptPubKey, sigKey, SigHash.ALL, false);
    }

    public TransactionInput addSignedInput(TransactionOutput output, ECKey signingKey) {
        return this.addSignedInput(output.getOutPointFor(), output.getScriptPubKey(), signingKey);
    }

    public TransactionInput addSignedInput(TransactionOutput output, ECKey signingKey, SigHash sigHash, boolean anyoneCanPay) {
        return this.addSignedInput(output.getOutPointFor(), output.getScriptPubKey(), signingKey, sigHash, anyoneCanPay);
    }

    public void clearOutputs() {
        this.unCache();
        for (TransactionOutput output : this.outputs) {
            output.setParent(null);
        }
        this.outputs.clear();
        this.length = this.unsafeBitcoinSerialize().length;
    }

    public TransactionOutput addOutput(TransactionOutput to) {
        this.unCache();
        to.setParent(this);
        this.outputs.add(to);
        this.adjustLength(this.outputs.size(), to.length);
        return to;
    }

    public TransactionOutput addOutput(Coin value, Address address) {
        return this.addOutput(new TransactionOutput(this.params, this, value, address));
    }

    public TransactionOutput addOutput(Coin value, ECKey pubkey) {
        return this.addOutput(new TransactionOutput(this.params, this, value, pubkey));
    }

    public TransactionOutput addOutput(Coin value, Script script) {
        return this.addOutput(new TransactionOutput(this.params, this, value, script.getProgram()));
    }

    public TransactionSignature calculateSignature(int inputIndex, ECKey key, byte[] redeemScript, SigHash hashType, boolean anyoneCanPay) {
        Sha256Hash hash = this.hashForSignature(inputIndex, redeemScript, hashType, anyoneCanPay);
        return new TransactionSignature(key.sign(hash), hashType, anyoneCanPay);
    }

    public TransactionSignature calculateSignature(int inputIndex, ECKey key, Script redeemScript, SigHash hashType, boolean anyoneCanPay) {
        Sha256Hash hash = this.hashForSignature(inputIndex, redeemScript.getProgram(), hashType, anyoneCanPay);
        return new TransactionSignature(key.sign(hash), hashType, anyoneCanPay);
    }

    public TransactionSignature calculateSignature(int inputIndex, ECKey key, @Nullable KeyParameter aesKey, byte[] redeemScript, SigHash hashType, boolean anyoneCanPay) {
        Sha256Hash hash = this.hashForSignature(inputIndex, redeemScript, hashType, anyoneCanPay);
        return new TransactionSignature(key.sign(hash, aesKey), hashType, anyoneCanPay);
    }

    public TransactionSignature calculateSignature(int inputIndex, ECKey key, @Nullable KeyParameter aesKey, Script redeemScript, SigHash hashType, boolean anyoneCanPay) {
        Sha256Hash hash = this.hashForSignature(inputIndex, redeemScript.getProgram(), hashType, anyoneCanPay);
        return new TransactionSignature(key.sign(hash, aesKey), hashType, anyoneCanPay);
    }

    public Sha256Hash hashForSignature(int inputIndex, byte[] redeemScript, SigHash type, boolean anyoneCanPay) {
        byte sigHashType = (byte)TransactionSignature.calcSigHashValue(type, anyoneCanPay);
        return this.hashForSignature(inputIndex, redeemScript, sigHashType);
    }

    public Sha256Hash hashForSignature(int inputIndex, Script redeemScript, SigHash type, boolean anyoneCanPay) {
        int sigHash = TransactionSignature.calcSigHashValue(type, anyoneCanPay);
        return this.hashForSignature(inputIndex, redeemScript.getProgram(), (byte)sigHash);
    }

    public Sha256Hash hashForSignature(int inputIndex, byte[] connectedScript, byte sigHashType) {
        try {
            Transaction tx = this.params.getDefaultSerializer().makeTransaction(this.bitcoinSerialize());
            for (int i = 0; i < tx.inputs.size(); ++i) {
                TransactionInput input = tx.inputs.get(i);
                input.clearScriptBytes();
                input.setWitness(null);
            }
            connectedScript = Script.removeAllInstancesOfOp(connectedScript, 171);
            TransactionInput input = tx.inputs.get(inputIndex);
            input.setScriptBytes(connectedScript);
            if ((sigHashType & 0x1F) == SigHash.NONE.value) {
                tx.outputs = new ArrayList(0);
                for (int i = 0; i < tx.inputs.size(); ++i) {
                    if (i == inputIndex) continue;
                    tx.inputs.get(i).setSequenceNumber(0L);
                }
            } else if ((sigHashType & 0x1F) == SigHash.SINGLE.value) {
                int i;
                if (inputIndex >= tx.outputs.size()) {
                    return Sha256Hash.wrap("0100000000000000000000000000000000000000000000000000000000000000");
                }
                tx.outputs = new ArrayList<TransactionOutput>(tx.outputs.subList(0, inputIndex + 1));
                for (i = 0; i < inputIndex; ++i) {
                    tx.outputs.set(i, new TransactionOutput(tx.params, tx, Coin.NEGATIVE_SATOSHI, new byte[0]));
                }
                for (i = 0; i < tx.inputs.size(); ++i) {
                    if (i == inputIndex) continue;
                    tx.inputs.get(i).setSequenceNumber(0L);
                }
            }
            if ((sigHashType & SigHash.ANYONECANPAY.value) == SigHash.ANYONECANPAY.value) {
                tx.inputs = new ArrayList();
                tx.inputs.add(input);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream(tx.length);
            tx.bitcoinSerializeToStream(bos, false);
            Utils.uint32ToByteStreamLE(0xFF & sigHashType, bos);
            Sha256Hash hash = Sha256Hash.twiceOf(bos.toByteArray());
            bos.close();
            return hash;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TransactionSignature calculateWitnessSignature(int inputIndex, ECKey key, byte[] scriptCode, Coin value, SigHash hashType, boolean anyoneCanPay) {
        Sha256Hash hash = this.hashForWitnessSignature(inputIndex, scriptCode, value, hashType, anyoneCanPay);
        return new TransactionSignature(key.sign(hash), hashType, anyoneCanPay);
    }

    public TransactionSignature calculateWitnessSignature(int inputIndex, ECKey key, Script scriptCode, Coin value, SigHash hashType, boolean anyoneCanPay) {
        return this.calculateWitnessSignature(inputIndex, key, scriptCode.getProgram(), value, hashType, anyoneCanPay);
    }

    public TransactionSignature calculateWitnessSignature(int inputIndex, ECKey key, @Nullable KeyParameter aesKey, byte[] scriptCode, Coin value, SigHash hashType, boolean anyoneCanPay) {
        Sha256Hash hash = this.hashForWitnessSignature(inputIndex, scriptCode, value, hashType, anyoneCanPay);
        return new TransactionSignature(key.sign(hash, aesKey), hashType, anyoneCanPay);
    }

    public TransactionSignature calculateWitnessSignature(int inputIndex, ECKey key, @Nullable KeyParameter aesKey, Script scriptCode, Coin value, SigHash hashType, boolean anyoneCanPay) {
        return this.calculateWitnessSignature(inputIndex, key, aesKey, scriptCode.getProgram(), value, hashType, anyoneCanPay);
    }

    public synchronized Sha256Hash hashForWitnessSignature(int inputIndex, byte[] scriptCode, Coin prevValue, SigHash type, boolean anyoneCanPay) {
        int sigHash = TransactionSignature.calcSigHashValue(type, anyoneCanPay);
        return this.hashForWitnessSignature(inputIndex, scriptCode, prevValue, (byte)sigHash);
    }

    public synchronized Sha256Hash hashForWitnessSignature(int inputIndex, Script scriptCode, Coin prevValue, SigHash type, boolean anyoneCanPay) {
        return this.hashForWitnessSignature(inputIndex, scriptCode.getProgram(), prevValue, type, anyoneCanPay);
    }

    public synchronized Sha256Hash hashForWitnessSignature(int inputIndex, byte[] scriptCode, Coin prevValue, byte sigHashType) {
        UnsafeByteArrayOutputStream bos = new UnsafeByteArrayOutputStream(this.length == Integer.MIN_VALUE ? 256 : this.length + 4);
        try {
            UnsafeByteArrayOutputStream bosHashOutputs;
            int i;
            boolean signAll;
            byte[] hashPrevouts = new byte[32];
            byte[] hashSequence = new byte[32];
            byte[] hashOutputs = new byte[32];
            int basicSigHashType = sigHashType & 0x1F;
            boolean anyoneCanPay = (sigHashType & SigHash.ANYONECANPAY.value) == SigHash.ANYONECANPAY.value;
            boolean bl = signAll = basicSigHashType != SigHash.SINGLE.value && basicSigHashType != SigHash.NONE.value;
            if (!anyoneCanPay) {
                UnsafeByteArrayOutputStream bosHashPrevouts = new UnsafeByteArrayOutputStream(256);
                for (i = 0; i < this.inputs.size(); ++i) {
                    bosHashPrevouts.write(this.inputs.get(i).getOutpoint().getHash().getReversedBytes());
                    Utils.uint32ToByteStreamLE(this.inputs.get(i).getOutpoint().getIndex(), bosHashPrevouts);
                }
                hashPrevouts = Sha256Hash.hashTwice(((ByteArrayOutputStream)bosHashPrevouts).toByteArray());
            }
            if (!anyoneCanPay && signAll) {
                UnsafeByteArrayOutputStream bosSequence = new UnsafeByteArrayOutputStream(256);
                for (i = 0; i < this.inputs.size(); ++i) {
                    Utils.uint32ToByteStreamLE(this.inputs.get(i).getSequenceNumber(), bosSequence);
                }
                hashSequence = Sha256Hash.hashTwice(((ByteArrayOutputStream)bosSequence).toByteArray());
            }
            if (signAll) {
                bosHashOutputs = new UnsafeByteArrayOutputStream(256);
                for (i = 0; i < this.outputs.size(); ++i) {
                    Utils.uint64ToByteStreamLE(BigInteger.valueOf(this.outputs.get(i).getValue().getValue()), bosHashOutputs);
                    bosHashOutputs.write(new VarInt(this.outputs.get(i).getScriptBytes().length).encode());
                    bosHashOutputs.write(this.outputs.get(i).getScriptBytes());
                }
                hashOutputs = Sha256Hash.hashTwice(((ByteArrayOutputStream)bosHashOutputs).toByteArray());
            } else if (basicSigHashType == SigHash.SINGLE.value && inputIndex < this.outputs.size()) {
                bosHashOutputs = new UnsafeByteArrayOutputStream(256);
                Utils.uint64ToByteStreamLE(BigInteger.valueOf(this.outputs.get(inputIndex).getValue().getValue()), bosHashOutputs);
                bosHashOutputs.write(new VarInt(this.outputs.get(inputIndex).getScriptBytes().length).encode());
                bosHashOutputs.write(this.outputs.get(inputIndex).getScriptBytes());
                hashOutputs = Sha256Hash.hashTwice(((ByteArrayOutputStream)bosHashOutputs).toByteArray());
            }
            Utils.uint32ToByteStreamLE(this.version, bos);
            bos.write(hashPrevouts);
            bos.write(hashSequence);
            bos.write(this.inputs.get(inputIndex).getOutpoint().getHash().getReversedBytes());
            Utils.uint32ToByteStreamLE(this.inputs.get(inputIndex).getOutpoint().getIndex(), bos);
            bos.write(new VarInt(scriptCode.length).encode());
            bos.write(scriptCode);
            Utils.uint64ToByteStreamLE(BigInteger.valueOf(prevValue.getValue()), bos);
            Utils.uint32ToByteStreamLE(this.inputs.get(inputIndex).getSequenceNumber(), bos);
            bos.write(hashOutputs);
            Utils.uint32ToByteStreamLE(this.lockTime, bos);
            Utils.uint32ToByteStreamLE(0xFF & sigHashType, bos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Sha256Hash.twiceOf(((ByteArrayOutputStream)bos).toByteArray());
    }

    public byte[] bitcoinSerialize(boolean segwit) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.bitcoinSerializeToStream(stream, segwit);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stream.toByteArray();
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        boolean useSegwit = this.hasWitnesses() && this.protocolVersion >= NetworkParameters.ProtocolVersion.WITNESS_VERSION.getBitcoinProtocolVersion();
        this.bitcoinSerializeToStream(stream, useSegwit);
    }

    protected void bitcoinSerializeToStream(OutputStream stream, boolean useSegwit) throws IOException {
        Utils.uint32ToByteStreamLE(this.version, stream);
        if (useSegwit) {
            stream.write(0);
            stream.write(1);
        }
        stream.write(new VarInt(this.inputs.size()).encode());
        for (TransactionInput in : this.inputs) {
            in.bitcoinSerialize(stream);
        }
        stream.write(new VarInt(this.outputs.size()).encode());
        for (TransactionOutput out : this.outputs) {
            out.bitcoinSerialize(stream);
        }
        if (useSegwit) {
            for (TransactionInput in : this.inputs) {
                in.getWitness().bitcoinSerializeToStream(stream);
            }
        }
        Utils.uint32ToByteStreamLE(this.lockTime, stream);
    }

    public long getLockTime() {
        return this.lockTime;
    }

    public void setLockTime(long lockTime) {
        this.unCache();
        boolean seqNumSet = false;
        for (TransactionInput input : this.inputs) {
            if (input.getSequenceNumber() == 0xFFFFFFFFL) continue;
            seqNumSet = true;
            break;
        }
        if (lockTime != 0L && (!seqNumSet || this.inputs.isEmpty())) {
            log.warn("You are setting the lock time on a transaction but none of the inputs have non-default sequence numbers. This will not do what you expect!");
        }
        this.lockTime = lockTime;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
        this.unCache();
    }

    public List<TransactionInput> getInputs() {
        return Collections.unmodifiableList(this.inputs);
    }

    public List<TransactionOutput> getOutputs() {
        return Collections.unmodifiableList(this.outputs);
    }

    public List<TransactionOutput> getWalletOutputs(TransactionBag transactionBag) {
        LinkedList<TransactionOutput> walletOutputs = new LinkedList<TransactionOutput>();
        for (TransactionOutput o : this.outputs) {
            if (!o.isMineOrWatched(transactionBag)) continue;
            walletOutputs.add(o);
        }
        return walletOutputs;
    }

    public void shuffleOutputs() {
        Collections.shuffle(this.outputs);
    }

    public TransactionInput getInput(long index) {
        return this.inputs.get((int)index);
    }

    public TransactionOutput getOutput(long index) {
        return this.outputs.get((int)index);
    }

    public TransactionConfidence getConfidence() {
        return this.getConfidence(Context.get());
    }

    public TransactionConfidence getConfidence(Context context) {
        return this.getConfidence(context.getConfidenceTable());
    }

    public TransactionConfidence getConfidence(TxConfidenceTable table) {
        if (this.confidence == null) {
            this.confidence = table.getOrCreate(this.getTxId());
        }
        return this.confidence;
    }

    public boolean hasConfidence() {
        return this.getConfidence().getConfidenceType() != TransactionConfidence.ConfidenceType.UNKNOWN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.getTxId().equals(((Transaction)o).getTxId());
    }

    public int hashCode() {
        return this.getTxId().hashCode();
    }

    public int getSigOpCount() throws ScriptException {
        int sigOps = 0;
        for (TransactionInput input : this.inputs) {
            sigOps += Script.getSigOpCount(input.getScriptBytes());
        }
        for (TransactionOutput output : this.outputs) {
            sigOps += Script.getSigOpCount(output.getScriptBytes());
        }
        return sigOps;
    }

    public void checkCoinBaseHeight(int height) throws VerificationException {
        Preconditions.checkArgument(height >= 0);
        Preconditions.checkState(this.isCoinBase());
        TransactionInput in = this.getInputs().get(0);
        ScriptBuilder builder = new ScriptBuilder();
        builder.number(height);
        byte[] expected = builder.build().getProgram();
        byte[] actual = in.getScriptBytes();
        if (actual.length < expected.length) {
            throw new VerificationException.CoinbaseHeightMismatch("Block height mismatch in coinbase.");
        }
        for (int scriptIdx = 0; scriptIdx < expected.length; ++scriptIdx) {
            if (actual[scriptIdx] == expected[scriptIdx]) continue;
            throw new VerificationException.CoinbaseHeightMismatch("Block height mismatch in coinbase.");
        }
    }

    public Sha256Hash findWitnessCommitment() {
        Preconditions.checkState(this.isCoinBase());
        for (TransactionOutput out : Lists.reverse(this.outputs)) {
            Script scriptPubKey = out.getScriptPubKey();
            if (!ScriptPattern.isWitnessCommitment(scriptPubKey)) continue;
            return ScriptPattern.extractWitnessCommitmentHash(scriptPubKey);
        }
        return null;
    }

    public void verify() throws VerificationException {
        if (this.inputs.size() == 0 || this.outputs.size() == 0) {
            throw new VerificationException.EmptyInputsOrOutputs();
        }
        if (this.getMessageSize() > 1000000) {
            throw new VerificationException.LargerThanMaxBlockSize();
        }
        Coin valueOut = Coin.ZERO;
        HashSet<TransactionOutPoint> outpoints = new HashSet<TransactionOutPoint>();
        for (TransactionInput input : this.inputs) {
            if (outpoints.contains(input.getOutpoint())) {
                throw new VerificationException.DuplicatedOutPoint();
            }
            outpoints.add(input.getOutpoint());
        }
        try {
            for (TransactionOutput output : this.outputs) {
                if (output.getValue().signum() < 0) {
                    throw new VerificationException.NegativeValueOutput();
                }
                valueOut = valueOut.add(output.getValue());
                if (!this.params.hasMaxMoney() || valueOut.compareTo(this.params.getMaxMoney()) <= 0) continue;
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalStateException e) {
            throw new VerificationException.ExcessiveValue();
        }
        catch (IllegalArgumentException e) {
            throw new VerificationException.ExcessiveValue();
        }
        if (this.isCoinBase()) {
            if (this.inputs.get(0).getScriptBytes().length < 2 || this.inputs.get(0).getScriptBytes().length > 100) {
                throw new VerificationException.CoinbaseScriptSizeOutOfRange();
            }
        } else {
            for (TransactionInput input : this.inputs) {
                if (!input.isCoinBase()) continue;
                throw new VerificationException.UnexpectedCoinbaseInput();
            }
        }
    }

    public boolean isTimeLocked() {
        if (this.getLockTime() == 0L) {
            return false;
        }
        for (TransactionInput input : this.getInputs()) {
            if (!input.hasSequence()) continue;
            return true;
        }
        return false;
    }

    public boolean hasRelativeLockTime() {
        if (this.version < 2L) {
            return false;
        }
        for (TransactionInput input : this.getInputs()) {
            if (!input.hasRelativeLockTime()) continue;
            return true;
        }
        return false;
    }

    public boolean isOptInFullRBF() {
        for (TransactionInput input : this.getInputs()) {
            if (!input.isOptInFullRBF()) continue;
            return true;
        }
        return false;
    }

    public boolean isFinal(int height, long blockTimeSeconds) {
        long time;
        return time < ((time = this.getLockTime()) < 500000000L ? (long)height : blockTimeSeconds) || !this.isTimeLocked();
    }

    public Date estimateLockTime(AbstractBlockChain chain) {
        if (this.lockTime < 500000000L) {
            return chain.estimateBlockTime((int)this.getLockTime());
        }
        return new Date(this.getLockTime() * 1000L);
    }

    public Purpose getPurpose() {
        return this.purpose;
    }

    public void setPurpose(Purpose purpose) {
        this.purpose = purpose;
    }

    @Nullable
    public ExchangeRate getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(ExchangeRate exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    @Nullable
    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public static enum SigHash {
        ALL(1),
        NONE(2),
        SINGLE(3),
        ANYONECANPAY(128),
        ANYONECANPAY_ALL(129),
        ANYONECANPAY_NONE(130),
        ANYONECANPAY_SINGLE(131),
        UNSET(0);

        public final int value;

        private SigHash(int value) {
            this.value = value;
        }

        public byte byteValue() {
            return (byte)this.value;
        }
    }

    public static enum Purpose {
        UNKNOWN,
        USER_PAYMENT,
        KEY_ROTATION,
        ASSURANCE_CONTRACT_CLAIM,
        ASSURANCE_CONTRACT_PLEDGE,
        ASSURANCE_CONTRACT_STUB,
        RAISE_FEE;

    }
}

