/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VarInt;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.script.Script;

public class TransactionWitness {
    public static final TransactionWitness EMPTY = new TransactionWitness(0);
    private final List<byte[]> pushes;

    public static TransactionWitness redeemP2WPKH(@Nullable TransactionSignature signature, ECKey pubKey) {
        Preconditions.checkArgument(pubKey.isCompressed(), "only compressed keys allowed");
        TransactionWitness witness = new TransactionWitness(2);
        witness.setPush(0, signature != null ? signature.encodeToBitcoin() : new byte[]{});
        witness.setPush(1, pubKey.getPubKey());
        return witness;
    }

    public static TransactionWitness redeemP2WSH(Script witnessScript, TransactionSignature ... signatures) {
        int i;
        TransactionWitness witness = new TransactionWitness(signatures.length + 2);
        witness.setPush(0, new byte[0]);
        for (i = 0; i < signatures.length; ++i) {
            witness.setPush(i + 1, signatures[i].encodeToBitcoin());
        }
        witness.setPush(i + 1, witnessScript.getProgram());
        return witness;
    }

    public TransactionWitness(int pushCount) {
        this.pushes = new ArrayList<byte[]>(Math.min(pushCount, 20));
    }

    public byte[] getPush(int i) {
        return this.pushes.get(i);
    }

    public int getPushCount() {
        return this.pushes.size();
    }

    public void setPush(int i, byte[] value) {
        while (i >= this.pushes.size()) {
            this.pushes.add(new byte[0]);
        }
        this.pushes.set(i, value);
    }

    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        stream.write(new VarInt(this.pushes.size()).encode());
        for (int i = 0; i < this.pushes.size(); ++i) {
            byte[] push = this.pushes.get(i);
            stream.write(new VarInt(push.length).encode());
            stream.write(push);
        }
    }

    public String toString() {
        ArrayList<String> stringPushes = new ArrayList<String>();
        for (int j = 0; j < this.getPushCount(); ++j) {
            byte[] push = this.getPush(j);
            if (push == null) {
                stringPushes.add("NULL");
                continue;
            }
            if (push.length == 0) {
                stringPushes.add("EMPTY");
                continue;
            }
            stringPushes.add(Utils.HEX.encode(push));
        }
        return Utils.SPACE_JOINER.join(stringPushes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionWitness other = (TransactionWitness)o;
        if (this.pushes.size() != other.pushes.size()) {
            return false;
        }
        for (int i = 0; i < this.pushes.size(); ++i) {
            if (Arrays.equals(this.pushes.get(i), other.pushes.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (byte[] push : this.pushes) {
            hashCode = 31 * hashCode + (push == null ? 0 : Arrays.hashCode(push));
        }
        return hashCode;
    }
}

