/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core.listeners;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.FilteredBlock;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.listeners.AbstractPeerDataEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadProgressTracker
extends AbstractPeerDataEventListener {
    private static final Logger log = LoggerFactory.getLogger(DownloadProgressTracker.class);
    private int originalBlocksLeft = -1;
    private int lastPercent = 0;
    private SettableFuture<Long> future = SettableFuture.create();
    private boolean caughtUp = false;

    @Override
    public void onChainDownloadStarted(Peer peer, int blocksLeft) {
        if (blocksLeft > 0 && this.originalBlocksLeft == -1) {
            this.startDownload(blocksLeft);
        }
        if (this.originalBlocksLeft == -1) {
            this.originalBlocksLeft = blocksLeft;
        } else {
            log.info("Chain download switched to {}", (Object)peer);
        }
        if (blocksLeft == 0) {
            this.doneDownload();
            this.future.set(peer.getBestHeight());
        }
    }

    @Override
    public void onBlocksDownloaded(Peer peer, Block block, @Nullable FilteredBlock filteredBlock, int blocksLeft) {
        if (this.caughtUp) {
            return;
        }
        if (blocksLeft == 0) {
            this.caughtUp = true;
            if (this.lastPercent != 100) {
                this.lastPercent = 100;
                this.progress(this.lastPercent, blocksLeft, new Date(block.getTimeSeconds() * 1000L));
            }
            this.doneDownload();
            this.future.set(peer.getBestHeight());
            return;
        }
        if (blocksLeft < 0 || this.originalBlocksLeft <= 0) {
            return;
        }
        double pct = 100.0 - 100.0 * ((double)blocksLeft / (double)this.originalBlocksLeft);
        if ((int)pct != this.lastPercent) {
            this.progress(pct, blocksLeft, new Date(block.getTimeSeconds() * 1000L));
            this.lastPercent = (int)pct;
        }
    }

    protected void progress(double pct, int blocksSoFar, Date date) {
        log.info(String.format(Locale.US, "Chain download %d%% done with %d blocks to go, block date %s", (int)pct, blocksSoFar, Utils.dateTimeFormat(date)));
    }

    protected void startDownload(int blocks) {
        log.info("Downloading block chain of size " + blocks + ". " + (blocks > 1000 ? "This may take a while." : ""));
    }

    protected void doneDownload() {
    }

    public void await() throws InterruptedException {
        try {
            this.future.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public ListenableFuture<Long> getFuture() {
        return this.future;
    }
}

