/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.bitcoinj.net.MessageWriteTarget;
import org.bitcoinj.net.StreamConnection;
import org.bitcoinj.net.StreamConnectionFactory;
import org.bitcoinj.utils.Threading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionHandler
implements MessageWriteTarget {
    private static final Logger log = LoggerFactory.getLogger(ConnectionHandler.class);
    private static final int BUFFER_SIZE_LOWER_BOUND = 4096;
    private static final int BUFFER_SIZE_UPPER_BOUND = 65536;
    private static final int OUTBOUND_BUFFER_BYTE_COUNT = 33554456;
    private final ReentrantLock lock = Threading.lock("nioConnectionHandler");
    @GuardedBy(value="lock")
    private final ByteBuffer readBuff;
    @GuardedBy(value="lock")
    private final SocketChannel channel;
    @GuardedBy(value="lock")
    private final SelectionKey key;
    @GuardedBy(value="lock")
    StreamConnection connection;
    @GuardedBy(value="lock")
    private boolean closeCalled = false;
    @GuardedBy(value="lock")
    private long bytesToWriteRemaining = 0L;
    @GuardedBy(value="lock")
    private final LinkedList<BytesAndFuture> bytesToWrite = new LinkedList();
    private Set<ConnectionHandler> connectedHandlers;

    public ConnectionHandler(StreamConnectionFactory connectionFactory, SelectionKey key) throws IOException {
        this(connectionFactory.getNewConnection(((SocketChannel)key.channel()).socket().getInetAddress(), ((SocketChannel)key.channel()).socket().getPort()), key);
        if (this.connection == null) {
            throw new IOException("Parser factory.getNewConnection returned null");
        }
    }

    private ConnectionHandler(@Nullable StreamConnection connection, SelectionKey key) {
        this.key = key;
        this.channel = Preconditions.checkNotNull((SocketChannel)key.channel());
        if (connection == null) {
            this.readBuff = null;
            return;
        }
        this.connection = connection;
        this.readBuff = ByteBuffer.allocateDirect(Math.min(Math.max(connection.getMaxMessageSize(), 4096), 65536));
        connection.setWriteTarget(this);
        this.connectedHandlers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionHandler(StreamConnection connection, SelectionKey key, Set<ConnectionHandler> connectedHandlers) {
        this(Preconditions.checkNotNull(connection), key);
        this.lock.lock();
        try {
            this.connectedHandlers = connectedHandlers;
            if (!this.closeCalled) {
                Preconditions.checkState(this.connectedHandlers.add(this));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private void setWriteOps() {
        this.key.interestOps(this.key.interestOps() | 4);
        this.key.selector().wakeup();
    }

    private void tryWriteBytes() throws IOException {
        this.lock.lock();
        try {
            Iterator iterator2 = this.bytesToWrite.iterator();
            while (iterator2.hasNext()) {
                BytesAndFuture bytesAndFuture = (BytesAndFuture)iterator2.next();
                this.bytesToWriteRemaining -= (long)this.channel.write(bytesAndFuture.bytes);
                if (!bytesAndFuture.bytes.hasRemaining()) {
                    iterator2.remove();
                    bytesAndFuture.future.set(null);
                    continue;
                }
                this.setWriteOps();
                break;
            }
            if (this.bytesToWrite.isEmpty()) {
                this.key.interestOps(this.key.interestOps() & 0xFFFFFFFB);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ListenableFuture writeBytes(byte[] message) throws IOException {
        boolean andUnlock = true;
        this.lock.lock();
        try {
            if (this.bytesToWriteRemaining + (long)message.length > 33554456L) {
                throw new IOException("Outbound buffer overflowed");
            }
            SettableFuture future = SettableFuture.create();
            this.bytesToWrite.offer(new BytesAndFuture(ByteBuffer.wrap(Arrays.copyOf(message, message.length)), future));
            this.bytesToWriteRemaining += (long)message.length;
            this.setWriteOps();
            SettableFuture settableFuture = future;
            return settableFuture;
        }
        catch (IOException e) {
            this.lock.unlock();
            andUnlock = false;
            log.warn("Error writing message to connection, closing connection", e);
            this.closeConnection();
            throw e;
        }
        catch (CancelledKeyException e) {
            this.lock.unlock();
            andUnlock = false;
            log.warn("Error writing message to connection, closing connection", e);
            this.closeConnection();
            throw new IOException(e);
        }
        finally {
            if (andUnlock) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void closeConnection() {
        Preconditions.checkState(!this.lock.isHeldByCurrentThread());
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.connectionClosed();
    }

    private void connectionClosed() {
        boolean callClosed = false;
        this.lock.lock();
        try {
            callClosed = !this.closeCalled;
            this.closeCalled = true;
        }
        finally {
            this.lock.unlock();
        }
        if (callClosed) {
            Preconditions.checkState(this.connectedHandlers == null || this.connectedHandlers.remove(this));
            this.connection.connectionClosed();
        }
    }

    public static void handleKey(SelectionKey key) {
        ConnectionHandler handler = (ConnectionHandler)key.attachment();
        try {
            if (handler == null) {
                return;
            }
            if (!key.isValid()) {
                handler.closeConnection();
                return;
            }
            if (key.isReadable()) {
                int read = handler.channel.read(handler.readBuff);
                if (read == 0) {
                    return;
                }
                if (read == -1) {
                    key.cancel();
                    handler.closeConnection();
                    return;
                }
                handler.readBuff.flip();
                int bytesConsumed = Preconditions.checkNotNull(handler.connection).receiveBytes(handler.readBuff);
                Preconditions.checkState(handler.readBuff.position() == bytesConsumed);
                handler.readBuff.compact();
            }
            if (key.isWritable()) {
                handler.tryWriteBytes();
            }
        }
        catch (Exception e) {
            Throwable t2 = Throwables.getRootCause(e);
            log.warn("Error handling SelectionKey: {} {}", t2.getClass().getName(), t2.getMessage() != null ? t2.getMessage() : "", e);
            handler.closeConnection();
        }
    }

    private static class BytesAndFuture {
        public final ByteBuffer bytes;
        public final SettableFuture future;

        public BytesAndFuture(ByteBuffer bytes, SettableFuture future) {
            this.bytes = bytes;
            this.future = future;
        }
    }
}

