/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.PeerFilterProvider;

public class FilterMerger {
    private final long bloomFilterTweak = (long)(Math.random() * 9.223372036854776E18);
    private volatile double vBloomFilterFPRate;
    private int lastBloomFilterElementCount;
    private BloomFilter lastFilter;

    public FilterMerger(double bloomFilterFPRate) {
        this.vBloomFilterFPRate = bloomFilterFPRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result calculate(ImmutableList<PeerFilterProvider> providers) {
        LinkedList<PeerFilterProvider> begunProviders = Lists.newLinkedList();
        try {
            for (PeerFilterProvider provider : providers) {
                provider.beginBloomFilterCalculation();
                begunProviders.add(provider);
            }
            Result result = new Result();
            result.earliestKeyTimeSecs = Long.MAX_VALUE;
            int elements = 0;
            boolean requiresUpdateAll = false;
            for (PeerFilterProvider p : providers) {
                result.earliestKeyTimeSecs = Math.min(result.earliestKeyTimeSecs, p.getEarliestKeyCreationTime());
                elements += p.getBloomFilterElementCount();
                requiresUpdateAll = requiresUpdateAll || p.isRequiringUpdateAllBloomFilter();
            }
            if (elements > 0) {
                this.lastBloomFilterElementCount = elements > this.lastBloomFilterElementCount ? elements + 100 : this.lastBloomFilterElementCount;
                BloomFilter.BloomUpdate bloomFlags = requiresUpdateAll ? BloomFilter.BloomUpdate.UPDATE_ALL : BloomFilter.BloomUpdate.UPDATE_P2PUBKEY_ONLY;
                double fpRate = this.vBloomFilterFPRate;
                BloomFilter filter = new BloomFilter(this.lastBloomFilterElementCount, fpRate, this.bloomFilterTweak, bloomFlags);
                for (PeerFilterProvider p : providers) {
                    filter.merge(p.getBloomFilter(this.lastBloomFilterElementCount, fpRate, this.bloomFilterTweak));
                }
                result.changed = !filter.equals(this.lastFilter);
                result.filter = this.lastFilter = filter;
            }
            result.earliestKeyTimeSecs -= 604800L;
            Result result2 = result;
            return result2;
        }
        finally {
            for (PeerFilterProvider provider : begunProviders) {
                provider.endBloomFilterCalculation();
            }
        }
    }

    public void setBloomFilterFPRate(double bloomFilterFPRate) {
        this.vBloomFilterFPRate = bloomFilterFPRate;
    }

    public double getBloomFilterFPRate() {
        return this.vBloomFilterFPRate;
    }

    public BloomFilter getLastFilter() {
        return this.lastFilter;
    }

    public static class Result {
        public BloomFilter filter;
        public long earliestKeyTimeSecs;
        public boolean changed;
    }
}

